/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.actions;

import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.committed.RefreshIncomingChangesAction;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.PerforceChangeList;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager;

public class SyncToRevisionAction
extends DumbAwareAction {
    public SyncToRevisionAction() {
        super("Sync to This Revision");
    }

    public void actionPerformed(AnActionEvent e) {
        final Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        final String revision = String.valueOf(((PerforceChangeList)((ChangeList[])e.getRequiredData(VcsDataKeys.CHANGE_LISTS))[0]).getNumber());
        final Set<VirtualFile> roots = PerforceConnectionManager.getInstance(project).getAllConnections().keySet();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Updating Project", true, PerformInBackgroundOption.ALWAYS_BACKGROUND){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    for (VirtualFile root : roots) {
                        PerforceRunner.getInstance(project).sync(P4File.create(root), revision);
                    }
                }
                catch (VcsException error) {
                    AbstractVcsHelper.getInstance((Project)project).showError(error, "Perforce Sync Error");
                }
            }

            public void onSuccess() {
                RefreshIncomingChangesAction.doRefresh((Project)project);
                SaveAndSyncHandler.getInstance().refreshOpenFiles();
                VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)true, (VirtualFile[])roots.toArray(VirtualFile.EMPTY_ARRAY));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/idea/perforce/actions/SyncToRevisionAction$1", "run"));
            }
        });
    }

    public void update(AnActionEvent e) {
        Project project = e.getProject();
        ChangeList[] lists = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
        e.getPresentation().setEnabledAndVisible(project != null && lists != null && lists.length == 1 && lists[0] instanceof PerforceChangeList);
    }
}

