/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application.annotation;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspect;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspectAdapter;
import com.intellij.openapi.vcs.annotate.VFSForAnnotationListener;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.text.DateFormatUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.actions.ShowAllSubmittedFilesAction;
import org.jetbrains.idea.perforce.application.PerforceFileRevision;
import org.jetbrains.idea.perforce.application.PerforceOnlyRevisionNumber;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.application.PerforceVcsRevisionNumber;
import org.jetbrains.idea.perforce.application.annotation.AnnotationInfo;
import org.jetbrains.idea.perforce.perforce.P4Revision;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager;

public class PerforceFileAnnotation
extends FileAnnotation {
    private final AnnotationInfo myAnnotationInfo;
    private final P4Revision[] myRevisions;
    private final VirtualFile myFile;
    private final long myRevision;
    private final VirtualFileListener myListener;
    private final Project myProject;
    private final List<VcsFileRevision> myPerforceRevisions;
    private final LineAnnotationAspect REVISION;
    private final LineAnnotationAspect CLIENT;
    private final LineAnnotationAspect DATE;

    public PerforceFileAnnotation(AnnotationInfo annotationInfo, VirtualFile file, P4Revision[] revisions, Project project, @NotNull P4Connection connection, long revision) {
        if (connection == null) {
            PerforceFileAnnotation.$$$reportNull$$$0(0);
        }
        super(project);
        this.REVISION = new PerforceAnnotationAspect(LineAnnotationAspect.REVISION, false){

            public String getValue(int lineNumber) {
                P4Revision p4Revision = PerforceFileAnnotation.this.findRevisionForLine(lineNumber);
                if (p4Revision != null) {
                    return String.valueOf(p4Revision.getChangeNumber());
                }
                return "";
            }
        };
        this.CLIENT = new PerforceAnnotationAspect(LineAnnotationAspect.AUTHOR, true){

            public String getValue(int lineNumber) {
                P4Revision p4Revision = PerforceFileAnnotation.this.findRevisionForLine(lineNumber);
                if (p4Revision != null) {
                    return p4Revision.getUser();
                }
                return "";
            }
        };
        this.DATE = new PerforceAnnotationAspect(LineAnnotationAspect.DATE, true){

            public String getValue(int lineNumber) {
                P4Revision p4Revision = PerforceFileAnnotation.this.findRevisionForLine(lineNumber);
                if (p4Revision != null) {
                    return DateFormatUtil.formatPrettyDate((Date)p4Revision.getDate());
                }
                return "";
            }
        };
        this.myAnnotationInfo = annotationInfo;
        this.myRevisions = revisions;
        this.myProject = project;
        this.myFile = file;
        this.myRevision = revision;
        this.myListener = new VFSForAnnotationListener(file, (FileAnnotation)this);
        VirtualFileManager.getInstance().addVirtualFileListener(this.myListener);
        this.myPerforceRevisions = new ArrayList<VcsFileRevision>();
        for (P4Revision p4Revision : this.myRevisions) {
            this.myPerforceRevisions.add(new PerforceFileRevision(p4Revision, connection, project));
        }
        Collections.sort(this.myPerforceRevisions, (o1, o2) -> -1 * o1.getRevisionNumber().compareTo((Object)o2.getRevisionNumber()));
    }

    public void dispose() {
        VirtualFileManager.getInstance().removeVirtualFileListener(this.myListener);
    }

    @NotNull
    public LineAnnotationAspect[] getAspects() {
        LineAnnotationAspect[] lineAnnotationAspectArray = new LineAnnotationAspect[]{this.REVISION, this.DATE, this.CLIENT};
        if (lineAnnotationAspectArray == null) {
            PerforceFileAnnotation.$$$reportNull$$$0(1);
        }
        return lineAnnotationAspectArray;
    }

    public String getToolTip(int lineNumber) {
        P4Revision revision = this.findRevisionForLine(lineNumber);
        return revision != null ? "Revision " + revision.getChangeNumber() + ": " + revision.getSubmitMessage() : "";
    }

    public String getAnnotatedContent() {
        return this.myAnnotationInfo.getContent();
    }

    @Nullable
    @VisibleForTesting
    public P4Revision findRevisionForLine(int lineNumber) {
        long revision = this.myAnnotationInfo.getRevision(lineNumber);
        if (revision == -1L) {
            return null;
        }
        for (P4Revision p4Revision : this.myRevisions) {
            if (!(this.myAnnotationInfo.isUseChangelistNumbers() ? p4Revision.getChangeNumber() == revision : p4Revision.getRevisionNumber() == revision)) continue;
            return p4Revision;
        }
        return null;
    }

    public VcsRevisionNumber getLineRevisionNumber(int lineNumber) {
        P4Revision p4Revision = this.findRevisionForLine(lineNumber);
        if (p4Revision != null) {
            return new PerforceVcsRevisionNumber(p4Revision);
        }
        return null;
    }

    @Nullable
    public Date getLineDate(int lineNumber) {
        P4Revision p4Revision = this.findRevisionForLine(lineNumber);
        return p4Revision == null ? null : p4Revision.getDate();
    }

    @NotNull
    public VcsRevisionNumber getCurrentRevision() {
        PerforceOnlyRevisionNumber perforceOnlyRevisionNumber = new PerforceOnlyRevisionNumber(this.myRevision);
        if (perforceOnlyRevisionNumber == null) {
            PerforceFileAnnotation.$$$reportNull$$$0(2);
        }
        return perforceOnlyRevisionNumber;
    }

    public List<VcsFileRevision> getRevisions() {
        return this.myPerforceRevisions;
    }

    public int getLineCount() {
        return this.myAnnotationInfo.getLineCount();
    }

    public VcsKey getVcsKey() {
        return PerforceVcs.getKey();
    }

    public boolean isBaseRevisionChanged(@NotNull VcsRevisionNumber number) {
        if (number == null) {
            PerforceFileAnnotation.$$$reportNull$$$0(3);
        }
        return PerforceVcs.revisionsSame(this.getCurrentRevision(), number);
    }

    public VirtualFile getFile() {
        return this.myFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/perforce/application/annotation/PerforceFileAnnotation";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "number";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/perforce/application/annotation/PerforceFileAnnotation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAspects";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentRevision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isBaseRevisionChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private abstract class PerforceAnnotationAspect
    extends LineAnnotationAspectAdapter {
        public PerforceAnnotationAspect(String id, boolean showByDefault) {
            super(id, showByDefault);
        }

        protected void showAffectedPaths(int lineNum) {
            P4Revision p4Revision = PerforceFileAnnotation.this.findRevisionForLine(lineNum);
            P4Connection connection = PerforceConnectionManager.getInstance(PerforceFileAnnotation.this.myProject).getConnectionForFile(PerforceFileAnnotation.this.myFile);
            if (p4Revision != null && connection != null) {
                long changeNumber = p4Revision.getChangeNumber();
                ShowAllSubmittedFilesAction.showAllSubmittedFiles(PerforceFileAnnotation.this.myProject, changeNumber, p4Revision.getSubmitMessage(), p4Revision.getDate(), p4Revision.getUser(), connection);
            }
        }
    }
}

