/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.info;

import java.util.LinkedList;
import java.util.List;

public class CfmlFunctionDescription {
    private String myName;
    private String myReturnType;
    private String myDescription;
    private List<CfmlParameterDescription> myParameters = new LinkedList<CfmlParameterDescription>();

    public CfmlFunctionDescription(String name, String returnType) {
        this.myName = name;
        this.myReturnType = returnType;
    }

    public void addParameter(CfmlParameterDescription newParameter) {
        this.myParameters.add(newParameter);
    }

    public String getName() {
        return this.myName;
    }

    public List<CfmlParameterDescription> getParameters() {
        return this.myParameters;
    }

    public String getReturnType() {
        return this.myReturnType;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(String description) {
        this.myDescription = description;
    }

    public String getPresentableText() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getName());
        buffer.append("(");
        buffer.append(this.getParametersListPresentableText());
        buffer.append(")");
        String type = this.getReturnType();
        if (type != null) {
            buffer.append(" : ");
            buffer.append(type);
        }
        return buffer.toString();
    }

    public String getParametersListPresentableText() {
        StringBuffer buffer = new StringBuffer();
        List<CfmlParameterDescription> params = this.getParameters();
        int i = 0;
        for (CfmlParameterDescription param : params) {
            buffer.append(param.getPresetableText());
            if (++i == params.size()) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }

    public static class CfmlParameterDescription {
        private String myName;
        private String myType;
        private boolean myIsRequired;
        private String myDescription;

        public CfmlParameterDescription(String name, String type, boolean isRequired) {
            this.myName = name;
            this.myType = type;
            this.myIsRequired = isRequired;
        }

        public String getName() {
            return this.myName;
        }

        public String getType() {
            return this.myType;
        }

        public boolean isRequired() {
            return this.myIsRequired;
        }

        public String getDescription() {
            return this.myDescription;
        }

        public void setDescription(String description) {
            this.myDescription = description;
        }

        public String getPresetableText() {
            StringBuilder sb = new StringBuilder();
            String paramDescription = this.getName();
            String type = this.getType();
            if (type != null) {
                paramDescription = paramDescription + " : " + type;
            }
            if (!this.isRequired()) {
                sb.append("[");
                sb.append(paramDescription);
                sb.append("]");
            } else {
                sb.append(paramDescription);
            }
            return sb.toString();
        }
    }
}

