/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.psi;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.coldFusion.UI.CfmlLookUpItemUtil;
import com.intellij.coldFusion.model.CfmlUtil;
import com.intellij.coldFusion.model.info.CfmlFunctionDescription;
import com.intellij.coldFusion.model.info.CfmlLangInfo;
import com.intellij.coldFusion.model.lexer.CfmlTokenTypes;
import com.intellij.coldFusion.model.lexer.CfscriptTokenTypes;
import com.intellij.coldFusion.model.psi.CfmlArgumentList;
import com.intellij.coldFusion.model.psi.CfmlExpression;
import com.intellij.coldFusion.model.psi.CfmlFunction;
import com.intellij.coldFusion.model.psi.CfmlFunctionCallExpression;
import com.intellij.coldFusion.model.psi.CfmlParameter;
import com.intellij.coldFusion.model.psi.CfmlPsiUtil;
import com.intellij.coldFusion.model.psi.CfmlReference;
import com.intellij.coldFusion.model.psi.CfmlReferenceExpression;
import com.intellij.coldFusion.model.psi.impl.CfmlNamedAttributeImpl;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CfmlArgumentNameReference
extends CfmlReferenceExpression
implements PsiElement {
    public CfmlArgumentNameReference(@NotNull ASTNode node) {
        if (node == null) {
            CfmlArgumentNameReference.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public String getFunctionName() {
        CfmlFunctionCallExpression parentOfType = (CfmlFunctionCallExpression)PsiTreeUtil.getParentOfType((PsiElement)this, CfmlFunctionCallExpression.class);
        if (parentOfType != null) {
            return parentOfType.getFunctionName();
        }
        return "";
    }

    @Nullable
    private CfmlFunction resolveToFunction() {
        CfmlFunctionCallExpression parentOfType = (CfmlFunctionCallExpression)PsiTreeUtil.getParentOfType((PsiElement)this, CfmlFunctionCallExpression.class);
        if (parentOfType != null) {
            CfmlReference referenceExpression = parentOfType.getReferenceExpression();
            PsiElement resolve = referenceExpression.resolve();
            if (resolve instanceof CfmlNamedAttributeImpl) {
                resolve = resolve.getParent();
            }
            if (resolve instanceof CfmlFunction) {
                return (CfmlFunction)resolve;
            }
        }
        return null;
    }

    @Nullable
    private CfmlParameter[] getFunctionParameters() {
        CfmlFunction cfmlFunction = this.resolveToFunction();
        if (cfmlFunction != null) {
            return cfmlFunction.getParameters();
        }
        return null;
    }

    @Override
    @NotNull
    protected ResolveResult[] resolveInner() {
        PsiElement nextSibling = this.getNextSibling();
        while (nextSibling instanceof PsiWhiteSpace) {
            nextSibling = nextSibling.getNextSibling();
        }
        if (nextSibling != null && nextSibling.getNode().getElementType() != CfmlTokenTypes.ASSIGN) {
            ResolveResult[] resolveResultArray = super.resolveInner();
            if (resolveResultArray == null) {
                CfmlArgumentNameReference.$$$reportNull$$$0(1);
            }
            return resolveResultArray;
        }
        CfmlParameter[] functionParameters = this.getFunctionParameters();
        if (functionParameters != null) {
            LinkedList<PsiElementResolveResult> result = new LinkedList<PsiElementResolveResult>();
            String referenceName = this.getReferenceName();
            for (CfmlParameter param : functionParameters) {
                if (!referenceName.equals(param.getName())) continue;
                result.add(new PsiElementResolveResult((PsiElement)param));
            }
            ResolveResult[] resolveResultArray = result.toArray(ResolveResult.EMPTY_ARRAY);
            if (resolveResultArray == null) {
                CfmlArgumentNameReference.$$$reportNull$$$0(2);
            }
            return resolveResultArray;
        }
        if (ResolveResult.EMPTY_ARRAY == null) {
            CfmlArgumentNameReference.$$$reportNull$$$0(3);
        }
        return ResolveResult.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    protected CfmlReferenceExpression parseReference(String newText) {
        CfmlReferenceExpression cfmlReferenceExpression = CfmlPsiUtil.createReferenceExpression(newText, this.getProject());
        if (cfmlReferenceExpression == null) {
            CfmlArgumentNameReference.$$$reportNull$$$0(4);
        }
        return cfmlReferenceExpression;
    }

    @Override
    protected PsiElement getSeparator() {
        return this.findChildByType(CfscriptTokenTypes.POINT);
    }

    @Override
    @NotNull
    public String getReferenceName() {
        PsiElement referenceNameElement = this.getReferenceNameElement();
        if (referenceNameElement != null) {
            String string = referenceNameElement.getText();
            if (string == null) {
                CfmlArgumentNameReference.$$$reportNull$$$0(5);
            }
            return string;
        }
        if ("" == null) {
            CfmlArgumentNameReference.$$$reportNull$$$0(6);
        }
        return "";
    }

    @Override
    protected PsiElement getReferenceNameElement() {
        return this.findChildByType(CfscriptTokenTypes.IDENTIFIER);
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        CfmlParameter[] functionParameters;
        LinkedList<Object> result = new LinkedList<Object>();
        Object[] superResult = ArrayUtil.EMPTY_OBJECT_ARRAY;
        String functionName = this.getFunctionName();
        if (CfmlUtil.isPredefinedFunction(functionName, this.getProject())) {
            CfmlFunctionDescription cfmlFunctionDescription = CfmlLangInfo.getInstance(this.getProject()).getFunctionParameters().get(functionName.toLowerCase());
            for (CfmlFunctionDescription.CfmlParameterDescription param : cfmlFunctionDescription.getParameters()) {
                result.add(TailTypeDecorator.withTail((LookupElement)LookupElementBuilder.create((String)param.getName()).withCaseSensitivity(false), (TailType)TailType.createSimpleTailType((char)'=')));
            }
        } else {
            CfmlExpression[] arguments;
            CfmlArgumentList parentArgumentsList = (CfmlArgumentList)PsiTreeUtil.getParentOfType((PsiElement)this, CfmlArgumentList.class);
            if (parentArgumentsList != null && (arguments = parentArgumentsList.getArguments()).length == 1) {
                result.add(LookupElementBuilder.create((String)"argumentCollection").withCaseSensitivity(false));
            }
        }
        PsiElement nextSibling = this.getNextSibling();
        while (nextSibling instanceof PsiWhiteSpace) {
            nextSibling = nextSibling.getNextSibling();
        }
        if (nextSibling != null && nextSibling.getNode().getElementType() != CfmlTokenTypes.ASSIGN) {
            superResult = super.getVariants();
        }
        if ((functionParameters = this.getFunctionParameters()) != null) {
            for (CfmlParameter param : functionParameters) {
                result.add(CfmlLookUpItemUtil.namedElementToLookupItem(param, null));
            }
        }
        if (!result.isEmpty() || superResult.length > 0) {
            Object[] objectArray = ArrayUtil.mergeArrays((Object[])superResult, (Object[])ContainerUtil.map2Array(result, Object.class, lookupElement -> lookupElement));
            if (objectArray == null) {
                CfmlArgumentNameReference.$$$reportNull$$$0(7);
            }
            return objectArray;
        }
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            CfmlArgumentNameReference.$$$reportNull$$$0(8);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @NotNull
    public String getName() {
        PsiElement referenceNameElement = this.getReferenceNameElement();
        String string = referenceNameElement != null ? referenceNameElement.getText() : "";
        if (string == null) {
            CfmlArgumentNameReference.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    public String toString() {
        return "Argument " + this.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coldFusion/model/psi/CfmlArgumentNameReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coldFusion/model/psi/CfmlArgumentNameReference";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveInner";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parseReference";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

