/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.psi;

import com.intellij.coldFusion.model.CfmlScopesInfo;
import com.intellij.coldFusion.model.psi.CfmlArgumentList;
import com.intellij.coldFusion.model.psi.CfmlFunction;
import com.intellij.coldFusion.model.psi.CfmlFunctionCall;
import com.intellij.coldFusion.model.psi.CfmlFunctionCallExpression;
import com.intellij.coldFusion.model.psi.CfmlReferenceExpression;
import com.intellij.coldFusion.model.psi.CfmlVariable;
import com.intellij.coldFusion.model.psi.impl.CfmlNamedAttributeImpl;
import com.intellij.coldFusion.model.psi.impl.CfmlTagInvokeImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.resolve.JavaMethodCandidateInfo;
import com.intellij.psi.resolve.JavaMethodResolveHelper;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CfmlVariantsProcessor<T>
extends BaseScopeProcessor {
    private final Set<T> myResult = new LinkedHashSet<T>();
    private final String myReferenceName;
    private final JavaMethodResolveHelper myMethods;
    private final boolean myIsMethodCall;
    private final boolean myIsForCompletion;
    private final PsiElement myElement;
    private boolean myStaticScopeFlag = false;
    private PsiClass myInitialClass = null;
    private boolean myWasConstructorFound = false;
    private int myScope = 17;

    protected CfmlVariantsProcessor(PsiElement element, PsiElement parent, @Nullable String referenceName) {
        PsiElement scope;
        if (element instanceof CfmlReferenceExpression && (scope = ((CfmlReferenceExpression)element).getScope()) != null) {
            this.myScope = CfmlScopesInfo.getScopeByString(scope.getText());
        }
        this.myElement = element;
        this.myIsForCompletion = referenceName == null;
        this.myReferenceName = referenceName != null ? referenceName.toLowerCase() : null;
        boolean bl = this.myIsMethodCall = parent instanceof CfmlFunctionCallExpression || parent instanceof CfmlTagInvokeImpl;
        if (parent instanceof CfmlFunctionCallExpression && !this.myIsForCompletion) {
            PsiType[] parameterTypes = ((CfmlFunctionCallExpression)parent).getArgumentTypes();
            this.myMethods = new JavaMethodResolveHelper(parent, parent.getContainingFile(), parameterTypes);
        } else {
            this.myMethods = new JavaMethodResolveHelper(parent, parent.getContainingFile(), null);
        }
    }

    public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == null) {
            CfmlVariantsProcessor.$$$reportNull$$$0(0);
        }
        if (event == JavaScopeProcessorEvent.START_STATIC) {
            this.myStaticScopeFlag = true;
        } else if (event == CfmlProcessorEvent.SET_INITIAL_CLASS && associated instanceof PsiClass) {
            this.myInitialClass = (PsiClass)associated;
            this.myWasConstructorFound = false;
        }
    }

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        PsiMethod method;
        PsiModifierListOwner owner;
        PsiElement namedElement;
        if (element == null) {
            CfmlVariantsProcessor.$$$reportNull$$$0(1);
        }
        if (state == null) {
            CfmlVariantsProcessor.$$$reportNull$$$0(2);
        }
        if (!(element instanceof PsiNamedElement)) {
            return true;
        }
        if (StringUtil.isEmpty((String)((PsiNamedElement)element).getName())) {
            return true;
        }
        String elementName = ((PsiNamedElement)element).getName();
        PsiElement psiElement = namedElement = element instanceof CfmlNamedAttributeImpl ? element.getParent() : element;
        if (!CfmlScopesInfo.isConvenient(namedElement, this.myScope)) {
            return true;
        }
        if (namedElement instanceof PsiClass) {
            return true;
        }
        if (namedElement instanceof PsiModifierListOwner && ((owner = (PsiModifierListOwner)namedElement).hasModifierProperty("private") || owner.hasModifierProperty("packageLocal") || owner.hasModifierProperty("protected"))) {
            return true;
        }
        boolean isJavaMethodCall = namedElement instanceof PsiMethod;
        if (isJavaMethodCall && (method = (PsiMethod)namedElement).isConstructor()) {
            PsiClass methodClass = method.getContainingClass();
            if (methodClass == null) {
                return true;
            }
            if (this.myStaticScopeFlag && (methodClass.equals(this.myInitialClass) || !this.myWasConstructorFound) && (this.myIsForCompletion || "init".equals(this.myReferenceName))) {
                this.myWasConstructorFound = true;
                if (!methodClass.equals(this.myInitialClass) && !this.myIsForCompletion) {
                    ContainerUtil.addIfNotNull(this.myResult, this.execute((PsiNamedElement)this.myInitialClass, false));
                    return true;
                }
                ContainerUtil.addIfNotNull(this.myResult, this.execute((PsiNamedElement)method, this.myMethods.getResolveError() == JavaMethodResolveHelper.ErrorType.RESOLVE));
                return true;
            }
        }
        if (namedElement instanceof PsiModifierListOwner) {
            PsiModifierListOwner owner2 = (PsiModifierListOwner)namedElement;
            if (this.myStaticScopeFlag && !owner2.hasModifierProperty("static")) {
                return true;
            }
        }
        boolean isMyMethodCall = namedElement instanceof CfmlFunction;
        if (!this.myIsForCompletion) {
            String referenceNameLoweCase = this.myReferenceName.toLowerCase(Locale.ENGLISH);
            if (this.myIsMethodCall && (referenceNameLoweCase.startsWith("get") || referenceNameLoweCase.startsWith("set")) && referenceNameLoweCase.substring(3).equalsIgnoreCase(elementName)) {
                if (!referenceNameLoweCase.startsWith("get") || this.methodCallArity() == 0) {
                    ContainerUtil.addIfNotNull(this.myResult, this.execute((PsiNamedElement)element, false));
                }
                return this.myResult.isEmpty();
            }
            if (!referenceNameLoweCase.equalsIgnoreCase(elementName)) {
                return true;
            }
        }
        if (!this.myIsForCompletion && (isJavaMethodCall || isMyMethodCall) != this.myIsMethodCall) {
            return true;
        }
        if (isJavaMethodCall) {
            this.myMethods.addMethod((PsiMethod)namedElement, (PsiSubstitutor)state.get(PsiSubstitutor.KEY), false);
            return true;
        }
        T execute = this.execute((PsiNamedElement)element, false);
        if (execute != null) {
            ContainerUtil.addIfNotNull(this.myResult, execute);
            if (this.myIsForCompletion || this.myResult.isEmpty()) {
                return true;
            }
            if (namedElement instanceof CfmlVariable) {
                return !((CfmlVariable)namedElement).isTrulyDeclaration();
            }
            return false;
        }
        return true;
    }

    private int methodCallArity() {
        if (!this.myIsMethodCall) {
            return 0;
        }
        CfmlArgumentList argumentList = ((CfmlFunctionCall)this.myElement.getParent()).findArgumentList();
        if (argumentList != null) {
            return argumentList.getArguments().length;
        }
        return 0;
    }

    @Nullable
    protected abstract T execute(PsiNamedElement var1, boolean var2);

    public T[] getVariants(T[] array) {
        if (this.myMethods != null) {
            for (JavaMethodCandidateInfo method : this.myMethods.getMethods()) {
                T execute = this.execute((PsiNamedElement)method.getMethod(), this.myMethods.getResolveError() == JavaMethodResolveHelper.ErrorType.RESOLVE);
                if (execute == null) continue;
                ContainerUtil.addIfNotNull(this.myResult, execute);
            }
        }
        return this.myResult.toArray(array);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "com/intellij/coldFusion/model/psi/CfmlVariantsProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleEvent";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class CfmlProcessorEvent
    implements PsiScopeProcessor.Event {
        public static final CfmlProcessorEvent SET_INITIAL_CLASS = new CfmlProcessorEvent();

        private CfmlProcessorEvent() {
        }
    }
}

