/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.SdkConstants;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.utils.XmlUtils;
import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

@Beta
public class DefaultConfiguration
extends Configuration {
    private final LintClient client;
    public static final String CONFIG_FILE_NAME = "lint.xml";
    public static final String TAG_LINT = "lint";
    private static final String TAG_ISSUE = "issue";
    private static final String ATTR_ID = "id";
    private static final String ATTR_SEVERITY = "severity";
    private static final String ATTR_PATH = "path";
    private static final String ATTR_REGEXP = "regexp";
    private static final String TAG_IGNORE = "ignore";
    public static final String VALUE_ALL = "all";
    private static final String ATTR_BASELINE = "baseline";
    private static final String RES_PATH_START = "res/";
    private static final int RES_PATH_START_LEN = "res/".length();
    private final Configuration parent;
    private final Project project;
    private final File configFile;
    private boolean bulkEditing;
    private File baselineFile;
    private Map<String, List<String>> suppressed;
    private Map<String, List<Pattern>> regexps;
    protected Map<String, Severity> severity;

    protected DefaultConfiguration(LintClient client, Project project, Configuration parent, File configFile) {
        this.client = client;
        this.project = project;
        this.parent = parent;
        this.configFile = configFile;
    }

    protected DefaultConfiguration(LintClient client, Project project, Configuration parent) {
        this(client, project, parent, new File(project.getDir(), CONFIG_FILE_NAME));
    }

    public static DefaultConfiguration create(LintClient client, Project project, Configuration parent) {
        return new DefaultConfiguration(client, project, parent);
    }

    public static DefaultConfiguration create(LintClient client, File lintFile) {
        return new DefaultConfiguration(client, null, null, lintFile);
    }

    @Override
    public boolean isIgnored(Context context, Issue issue, Location location, String message) {
        this.ensureInitialized();
        String id = issue.getId();
        List<String> paths = this.suppressed.get(id);
        if (paths == null) {
            paths = this.suppressed.get(VALUE_ALL);
        }
        if (paths != null && location != null) {
            File file = location.getFile();
            String relativePath = context.getProject().getRelativePath(file);
            for (String suppressedPath : paths) {
                if (suppressedPath.equals(relativePath)) {
                    return true;
                }
                if (!relativePath.startsWith(suppressedPath)) continue;
                return true;
            }
            Set suppressedPathSet = paths.stream().filter(p -> p.startsWith(RES_PATH_START)).map(p -> Paths.get(p.substring(RES_PATH_START_LEN), new String[0])).collect(Collectors.toSet());
            if (!suppressedPathSet.isEmpty()) {
                Path toCheck = file.toPath();
                for (File resDir : context.getProject().getResourceFolders()) {
                    Path path = resDir.toPath();
                    Path relative = path.relativize(toCheck);
                    if (suppressedPathSet.contains(relative)) {
                        return true;
                    }
                    if (!suppressedPathSet.stream().anyMatch(relative::startsWith)) continue;
                    return true;
                }
            }
        }
        if (this.regexps != null) {
            List<Pattern> regexps = this.regexps.get(id);
            if (regexps == null) {
                regexps = this.regexps.get(VALUE_ALL);
            }
            if (regexps != null && location != null) {
                Matcher matcher;
                for (Pattern regexp : regexps) {
                    Matcher matcher2 = regexp.matcher(message);
                    if (!matcher2.find()) continue;
                    return true;
                }
                File file = location.getFile();
                String relativePath = context.getProject().getRelativePath(file);
                boolean checkUnixPath = false;
                for (Pattern regexp : regexps) {
                    matcher = regexp.matcher(relativePath);
                    if (matcher.find()) {
                        return true;
                    }
                    if (regexp.pattern().indexOf(47) == -1) continue;
                    checkUnixPath = true;
                }
                if (checkUnixPath && SdkConstants.CURRENT_PLATFORM == 2) {
                    relativePath = relativePath.replace('\\', '/');
                    for (Pattern regexp : regexps) {
                        matcher = regexp.matcher(relativePath);
                        if (!matcher.find()) continue;
                        return true;
                    }
                }
            }
        }
        return this.parent != null && this.parent.isIgnored(context, issue, location, message);
    }

    protected Severity getDefaultSeverity(Issue issue) {
        if (!issue.isEnabledByDefault()) {
            return Severity.IGNORE;
        }
        return issue.getDefaultSeverity();
    }

    @Override
    public Severity getSeverity(Issue issue) {
        this.ensureInitialized();
        Severity severity = this.severity.get(issue.getId());
        if (severity == null) {
            severity = this.severity.get(VALUE_ALL);
        }
        if (severity != null) {
            return severity;
        }
        if (this.parent != null) {
            return this.parent.getSeverity(issue);
        }
        return this.getDefaultSeverity(issue);
    }

    private void ensureInitialized() {
        if (this.suppressed == null) {
            this.readConfig();
        }
    }

    private void formatError(String message, Object ... args) {
        if (args != null && args.length > 0) {
            message = String.format(message, args);
        }
        message = "Failed to parse `lint.xml` configuration file: " + message;
        LintDriver driver = new LintDriver(new IssueRegistry(){

            @Override
            public List<Issue> getIssues() {
                return Collections.emptyList();
            }
        }, this.client);
        this.client.report(new Context(driver, this.project, this.project, this.configFile), IssueRegistry.LINT_ERROR, this.project.getConfiguration(driver).getSeverity(IssueRegistry.LINT_ERROR), Location.create(this.configFile), message, TextFormat.RAW);
    }

    private void readConfig() {
        this.suppressed = new HashMap<String, List<String>>();
        this.severity = new HashMap<String, Severity>();
        if (!this.configFile.exists()) {
            return;
        }
        try {
            Document document = XmlUtils.parseUtfXmlFile((File)this.configFile, (boolean)false);
            String baseline = document.getDocumentElement().getAttribute(ATTR_BASELINE);
            if (!baseline.isEmpty()) {
                this.baselineFile = new File(baseline.replace('/', File.separatorChar));
                if (!this.baselineFile.isAbsolute()) {
                    this.baselineFile = new File(this.project.getDir(), this.baselineFile.getPath());
                }
            }
            NodeList issues = document.getElementsByTagName(TAG_ISSUE);
            Splitter splitter = Splitter.on((char)',').trimResults().omitEmptyStrings();
            int count = issues.getLength();
            for (int i = 0; i < count; ++i) {
                Node node = issues.item(i);
                Element element = (Element)node;
                String idList = element.getAttribute(ATTR_ID);
                if (idList.isEmpty()) {
                    this.formatError("Invalid lint config file: Missing required issue id attribute", new Object[0]);
                    continue;
                }
                Iterable ids = splitter.split((CharSequence)idList);
                NamedNodeMap attributes = node.getAttributes();
                int n = attributes.getLength();
                block4: for (int j = 0; j < n; ++j) {
                    Node attribute = attributes.item(j);
                    String name = attribute.getNodeName();
                    String value = attribute.getNodeValue();
                    if (ATTR_ID.equals(name)) continue;
                    if (ATTR_SEVERITY.equals(name)) {
                        for (Severity severity : Severity.values()) {
                            if (!value.equalsIgnoreCase(severity.name())) continue;
                            for (String id : ids) {
                                this.severity.put(id, severity);
                            }
                            continue block4;
                        }
                        continue;
                    }
                    this.formatError("Unexpected attribute \"%1$s\"", name);
                }
                NodeList childNodes = element.getChildNodes();
                if (childNodes.getLength() <= 0) continue;
                int n2 = childNodes.getLength();
                for (int j = 0; j < n2; ++j) {
                    String regexp;
                    Node child = childNodes.item(j);
                    if (child.getNodeType() != 1) continue;
                    Element ignore = (Element)child;
                    String path = ignore.getAttribute(ATTR_PATH);
                    if (path.isEmpty()) {
                        regexp = ignore.getAttribute(ATTR_REGEXP);
                        if (regexp.isEmpty()) {
                            this.formatError("Missing required attribute %1$s or %2$s under %3$s", ATTR_PATH, ATTR_REGEXP, idList);
                            continue;
                        }
                        this.addRegexp(idList, ids, n2, regexp, false);
                        continue;
                    }
                    path = File.separatorChar == '/' ? path.replace('\\', '/') : path.replace('/', File.separatorChar);
                    if (path.indexOf(42) != -1) {
                        regexp = DefaultConfiguration.globToRegexp(path);
                        this.addRegexp(idList, ids, n2, regexp, false);
                        continue;
                    }
                    for (String id : ids) {
                        List<String> paths = this.suppressed.get(id);
                        if (paths == null) {
                            paths = new ArrayList<String>(n2 / 2 + 1);
                            this.suppressed.put(id, paths);
                        }
                        paths.add(path);
                    }
                }
            }
        }
        catch (SAXParseException e) {
            this.formatError(e.getMessage(), new Object[0]);
        }
        catch (Exception e) {
            this.client.log(e, null, new Object[0]);
        }
    }

    public static String globToRegexp(String glob) {
        StringBuilder sb = new StringBuilder(glob.length() * 2);
        int begin = 0;
        sb.append('^');
        int n = glob.length();
        for (int i = 0; i < n; ++i) {
            char c = glob.charAt(i);
            if (c == '*') {
                begin = DefaultConfiguration.appendQuoted(sb, glob, begin, i) + 1;
                if (i < n - 1 && glob.charAt(i + 1) == '*') {
                    ++i;
                    ++begin;
                }
                sb.append(".*?");
                continue;
            }
            if (c != '?') continue;
            begin = DefaultConfiguration.appendQuoted(sb, glob, begin, i) + 1;
            sb.append(".?");
        }
        DefaultConfiguration.appendQuoted(sb, glob, begin, glob.length());
        sb.append('$');
        return sb.toString();
    }

    private static int appendQuoted(StringBuilder sb, String s, int from, int to) {
        if (to > from) {
            int i;
            boolean isSimple = true;
            for (i = from; i < to; ++i) {
                char c = s.charAt(i);
                if (Character.isLetterOrDigit(c) || c == '/' || c == ' ') continue;
                isSimple = false;
                break;
            }
            if (isSimple) {
                for (i = from; i < to; ++i) {
                    sb.append(s.charAt(i));
                }
                return to;
            }
            sb.append(Pattern.quote(s.substring(from, to)));
        }
        return to;
    }

    private void addRegexp(String idList, Iterable<String> ids, int n, String regexp, boolean silent) {
        block5: {
            try {
                if (this.regexps == null) {
                    this.regexps = new HashMap<String, List<Pattern>>();
                }
                Pattern pattern = Pattern.compile(regexp);
                for (String id : ids) {
                    List<Pattern> paths = this.regexps.get(id);
                    if (paths == null) {
                        paths = new ArrayList<Pattern>(n / 2 + 1);
                        this.regexps.put(id, paths);
                    }
                    paths.add(pattern);
                }
            }
            catch (PatternSyntaxException e) {
                if (silent) break block5;
                this.formatError("Invalid pattern %1$s under %2$s: %3$s", regexp, idList, e.getDescription());
            }
        }
    }

    private void writeConfig() {
        try {
            boolean ok;
            File file = new File(this.configFile.getParentFile(), this.configFile.getName() + ".new");
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<");
            writer.write(TAG_LINT);
            if (this.baselineFile != null) {
                writer.write(" baseline=\"");
                String path = this.project != null ? this.project.getRelativePath(this.baselineFile) : this.baselineFile.getPath();
                DefaultConfiguration.writeAttribute(writer, ATTR_BASELINE, path.replace('\\', '/'));
            }
            writer.write(">\n");
            if (!this.suppressed.isEmpty() || !this.severity.isEmpty()) {
                HashSet<String> idSet = new HashSet<String>();
                for (String id : this.suppressed.keySet()) {
                    idSet.add(id);
                }
                for (String id : this.severity.keySet()) {
                    idSet.add(id);
                }
                ArrayList ids = new ArrayList(idSet);
                Collections.sort(ids);
                for (String id : ids) {
                    writer.write("    <");
                    writer.write(TAG_ISSUE);
                    DefaultConfiguration.writeAttribute(writer, ATTR_ID, id);
                    Severity severity = this.severity.get(id);
                    if (severity != null) {
                        DefaultConfiguration.writeAttribute(writer, ATTR_SEVERITY, severity.name().toLowerCase(Locale.US));
                    }
                    List<Pattern> regexps = this.regexps != null ? this.regexps.get(id) : null;
                    List<String> paths = this.suppressed.get(id);
                    if (paths != null && !paths.isEmpty() || regexps != null && !regexps.isEmpty()) {
                        ((Writer)writer).write(62);
                        ((Writer)writer).write(10);
                        if (paths != null) {
                            for (String path : paths) {
                                writer.write("        <");
                                writer.write(TAG_IGNORE);
                                DefaultConfiguration.writeAttribute(writer, ATTR_PATH, path.replace('\\', '/'));
                                writer.write(" />\n");
                            }
                        }
                        if (regexps != null) {
                            for (Pattern regexp : regexps) {
                                writer.write("        <");
                                writer.write(TAG_IGNORE);
                                DefaultConfiguration.writeAttribute(writer, ATTR_REGEXP, regexp.pattern());
                                writer.write(" />\n");
                            }
                        }
                        writer.write("    </");
                        writer.write(TAG_ISSUE);
                        ((Writer)writer).write(62);
                        ((Writer)writer).write(10);
                        continue;
                    }
                    writer.write(" />\n");
                }
            }
            writer.write("</lint>\n");
            ((Writer)writer).close();
            File oldFile = new File(this.configFile.getParentFile(), this.configFile.getName() + '~');
            if (oldFile.exists()) {
                oldFile.delete();
            }
            if (this.configFile.exists()) {
                this.configFile.renameTo(oldFile);
            }
            if ((ok = file.renameTo(this.configFile)) && oldFile.exists()) {
                oldFile.delete();
            }
        }
        catch (Exception e) {
            this.client.log(e, null, new Object[0]);
        }
    }

    private static void writeAttribute(Writer writer, String name, String value) throws IOException {
        writer.write(32);
        writer.write(name);
        writer.write(61);
        writer.write(34);
        writer.write(value);
        writer.write(34);
    }

    @Override
    public void ignore(Context context, Issue issue, Location location, String message) {
        if (location != null) {
            this.ignore(issue, location.getFile());
        }
    }

    @Override
    public void ignore(Issue issue, File file) {
        this.ensureInitialized();
        String path = this.project != null ? this.project.getRelativePath(file) : file.getPath();
        List<String> paths = this.suppressed.get(issue.getId());
        if (paths == null) {
            paths = new ArrayList<String>();
            this.suppressed.put(issue.getId(), paths);
        }
        paths.add(path);
        Collections.sort(paths);
        if (!this.bulkEditing) {
            this.writeConfig();
        }
    }

    @Override
    public void setSeverity(Issue issue, Severity severity) {
        this.ensureInitialized();
        String id = issue.getId();
        if (severity == null) {
            this.severity.remove(id);
        } else {
            this.severity.put(id, severity);
        }
        if (!this.bulkEditing) {
            this.writeConfig();
        }
    }

    @Override
    public void startBulkEditing() {
        this.bulkEditing = true;
    }

    @Override
    public void finishBulkEditing() {
        this.bulkEditing = false;
        this.writeConfig();
    }

    @VisibleForTesting
    File getConfigFile() {
        return this.configFile;
    }

    @Override
    public File getBaselineFile() {
        if (this.baselineFile != null && this.project != null && !this.baselineFile.isAbsolute()) {
            return new File(this.project.getDir(), this.baselineFile.getPath());
        }
        return this.baselineFile;
    }

    @Override
    public void setBaselineFile(File baselineFile) {
        this.baselineFile = baselineFile;
    }
}

