/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import javax.annotation.Nonnull;
import org.fest.swing.core.MouseButton;
import org.fest.util.Preconditions;
import org.fest.util.Strings;

public final class MouseClickInfo {
    private final MouseButton button;
    private int times;

    @Nonnull
    public static MouseClickInfo leftButton() {
        MouseClickInfo mouseClickInfo = MouseClickInfo.button(MouseButton.LEFT_BUTTON);
        if (mouseClickInfo == null) {
            MouseClickInfo.$$$reportNull$$$0(0);
        }
        return mouseClickInfo;
    }

    @Nonnull
    public static MouseClickInfo middleButton() {
        MouseClickInfo mouseClickInfo = MouseClickInfo.button(MouseButton.MIDDLE_BUTTON);
        if (mouseClickInfo == null) {
            MouseClickInfo.$$$reportNull$$$0(1);
        }
        return mouseClickInfo;
    }

    @Nonnull
    public static MouseClickInfo rightButton() {
        MouseClickInfo mouseClickInfo = MouseClickInfo.button(MouseButton.RIGHT_BUTTON);
        if (mouseClickInfo == null) {
            MouseClickInfo.$$$reportNull$$$0(2);
        }
        return mouseClickInfo;
    }

    @Nonnull
    public static MouseClickInfo button(@Nonnull MouseButton button) {
        if (button == null) {
            MouseClickInfo.$$$reportNull$$$0(3);
        }
        MouseClickInfo mouseClickInfo = new MouseClickInfo(button, 1);
        if (mouseClickInfo == null) {
            MouseClickInfo.$$$reportNull$$$0(4);
        }
        return mouseClickInfo;
    }

    private MouseClickInfo(@Nonnull MouseButton button, int times) {
        if (button == null) {
            MouseClickInfo.$$$reportNull$$$0(5);
        }
        this.button = (MouseButton)((Object)Preconditions.checkNotNull((Object)((Object)button)));
        this.times = times;
    }

    @Nonnull
    public MouseButton button() {
        MouseButton mouseButton = this.button;
        if (mouseButton == null) {
            MouseClickInfo.$$$reportNull$$$0(6);
        }
        return mouseButton;
    }

    public int times() {
        return this.times;
    }

    public MouseClickInfo times(int newTimes) {
        this.times = newTimes;
        return this;
    }

    @Nonnull
    public String toString() {
        String string = Strings.concat((Object[])new Object[]{String.format("%s[button=%s, times=%d]", this.getClass().getName(), this.button.toString(), this.times)});
        if (string == null) {
            MouseClickInfo.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 5: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/core/MouseClickInfo";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "leftButton";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "middleButton";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "rightButton";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/core/MouseClickInfo";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "button";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "button";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

