/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.cell.JTableCellReader;
import org.fest.swing.driver.BasicCellRendererReader;
import org.fest.swing.driver.BasicJComboBoxCellReader;
import org.fest.swing.driver.CellRendererReader;
import org.fest.swing.driver.ModelValueToString;
import org.fest.util.Preconditions;

public class BasicJTableCellReader
implements JTableCellReader {
    private final CellRendererReader rendererReader;
    private final BasicJComboBoxCellReader comboBoxCellReader;

    public BasicJTableCellReader() {
        this(new BasicCellRendererReader());
    }

    public BasicJTableCellReader(@Nonnull CellRendererReader reader) {
        if (reader == null) {
            BasicJTableCellReader.$$$reportNull$$$0(0);
        }
        this.comboBoxCellReader = new BasicJComboBoxCellReader();
        this.rendererReader = (CellRendererReader)Preconditions.checkNotNull((Object)reader);
    }

    @Override
    @Nullable
    @RunsInCurrentThread
    public String valueAt(@Nonnull JTable table, int row, int column) {
        Component c;
        String value;
        if (table == null) {
            BasicJTableCellReader.$$$reportNull$$$0(1);
        }
        String string = value = (c = this.cellRendererIn(table, row, column)) != null ? this.rendererReader.valueFrom(c) : null;
        if (value != null) {
            return value;
        }
        if (c instanceof JLabel) {
            return ((JLabel)c).getText();
        }
        if (c instanceof JCheckBox) {
            return String.valueOf(((JCheckBox)c).isSelected());
        }
        if (c instanceof JComboBox) {
            return this.valueAsText((JComboBox)c);
        }
        return ModelValueToString.asText(table.getValueAt(row, column));
    }

    @Nullable
    private String valueAsText(@Nonnull JComboBox comboBox) {
        int selectedIndex;
        if (comboBox == null) {
            BasicJTableCellReader.$$$reportNull$$$0(2);
        }
        if ((selectedIndex = comboBox.getSelectedIndex()) == -1) {
            return null;
        }
        return this.comboBoxCellReader.valueAt(comboBox, selectedIndex);
    }

    @Override
    @Nullable
    @RunsInCurrentThread
    public Font fontAt(@Nonnull JTable table, int row, int column) {
        Component c;
        if (table == null) {
            BasicJTableCellReader.$$$reportNull$$$0(3);
        }
        return (c = this.cellRendererIn(table, row, column)) != null ? c.getFont() : null;
    }

    @Override
    @Nullable
    @RunsInCurrentThread
    public Color backgroundAt(@Nonnull JTable table, int row, int column) {
        Component c;
        if (table == null) {
            BasicJTableCellReader.$$$reportNull$$$0(4);
        }
        return (c = this.cellRendererIn(table, row, column)) != null ? c.getBackground() : null;
    }

    @Override
    @Nullable
    @RunsInCurrentThread
    public Color foregroundAt(@Nonnull JTable table, int row, int column) {
        Component c;
        if (table == null) {
            BasicJTableCellReader.$$$reportNull$$$0(5);
        }
        return (c = this.cellRendererIn(table, row, column)) != null ? c.getForeground() : null;
    }

    @Nullable
    @RunsInCurrentThread
    private Component cellRendererIn(@Nonnull JTable table, int row, int column) {
        if (table == null) {
            BasicJTableCellReader.$$$reportNull$$$0(6);
        }
        return table.prepareRenderer(table.getCellRenderer(row, column), row, column);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBox";
                break;
            }
        }
        objectArray2[1] = "org/fest/swing/driver/BasicJTableCellReader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "valueAt";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "valueAsText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fontAt";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "backgroundAt";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "foregroundAt";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "cellRendererIn";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

