/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Point;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JPopupMenu;
import javax.swing.table.JTableHeader;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.ComponentPreconditions;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JTableHeaderLocation;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.timing.Pause;
import org.fest.swing.util.Pair;
import org.fest.swing.util.PatternTextMatcher;
import org.fest.swing.util.StringTextMatcher;
import org.fest.swing.util.TextMatcher;
import org.fest.util.InternalApi;
import org.fest.util.Preconditions;

@InternalApi
public class JTableHeaderDriver
extends JComponentDriver {
    private final JTableHeaderLocation location;

    public JTableHeaderDriver(@Nonnull Robot robot) {
        if (robot == null) {
            JTableHeaderDriver.$$$reportNull$$$0(0);
        }
        super(robot);
        this.location = new JTableHeaderLocation();
    }

    @RunsInEDT
    public void clickColumn(@Nonnull JTableHeader tableHeader, int columnIndex) {
        if (tableHeader == null) {
            JTableHeaderDriver.$$$reportNull$$$0(1);
        }
        this.clickColumn(tableHeader, columnIndex, MouseButton.LEFT_BUTTON, 1);
    }

    @RunsInEDT
    public void clickColumn(@Nonnull JTableHeader tableHeader, int columnIndex, @Nonnull MouseButton button, int times) {
        if (tableHeader == null) {
            JTableHeaderDriver.$$$reportNull$$$0(2);
        }
        if (button == null) {
            JTableHeaderDriver.$$$reportNull$$$0(3);
        }
        Point p = JTableHeaderDriver.pointAtIndex(tableHeader, columnIndex, this.location);
        this.robot.click(tableHeader, p, button, times);
        Pause.pause(300L);
    }

    @RunsInEDT
    public void clickColumn(@Nonnull JTableHeader tableHeader, @Nullable String columnName) {
        if (tableHeader == null) {
            JTableHeaderDriver.$$$reportNull$$$0(4);
        }
        this.clickColumn(tableHeader, columnName, MouseButton.LEFT_BUTTON, 1);
    }

    @RunsInEDT
    public void clickColumn(@Nonnull JTableHeader tableHeader, @Nonnull Pattern columnNamePattern) {
        if (tableHeader == null) {
            JTableHeaderDriver.$$$reportNull$$$0(5);
        }
        if (columnNamePattern == null) {
            JTableHeaderDriver.$$$reportNull$$$0(6);
        }
        this.clickColumn(tableHeader, columnNamePattern, MouseButton.LEFT_BUTTON, 1);
    }

    @RunsInEDT
    public void clickColumn(@Nonnull JTableHeader tableHeader, @Nullable String columnName, @Nonnull MouseButton button, int times) {
        if (tableHeader == null) {
            JTableHeaderDriver.$$$reportNull$$$0(7);
        }
        if (button == null) {
            JTableHeaderDriver.$$$reportNull$$$0(8);
        }
        this.clickColumn(tableHeader, new StringTextMatcher(columnName), button, times);
    }

    @RunsInEDT
    public void clickColumn(@Nonnull JTableHeader tableHeader, @Nonnull Pattern columnNamePattern, @Nonnull MouseButton button, int times) {
        if (tableHeader == null) {
            JTableHeaderDriver.$$$reportNull$$$0(9);
        }
        if (columnNamePattern == null) {
            JTableHeaderDriver.$$$reportNull$$$0(10);
        }
        if (button == null) {
            JTableHeaderDriver.$$$reportNull$$$0(11);
        }
        this.clickColumn(tableHeader, new PatternTextMatcher(columnNamePattern), button, times);
    }

    @RunsInEDT
    private void clickColumn(@Nonnull JTableHeader tableHeader, @Nonnull TextMatcher matcher, @Nonnull MouseButton button, int times) {
        if (tableHeader == null) {
            JTableHeaderDriver.$$$reportNull$$$0(12);
        }
        if (matcher == null) {
            JTableHeaderDriver.$$$reportNull$$$0(13);
        }
        if (button == null) {
            JTableHeaderDriver.$$$reportNull$$$0(14);
        }
        Point p = JTableHeaderDriver.pointAtName(tableHeader, matcher, this.location());
        this.robot.click(tableHeader, p, button, times);
    }

    @Nonnull
    @RunsInEDT
    public JPopupMenu showPopupMenu(@Nonnull JTableHeader tableHeader, int columnIndex) {
        if (tableHeader == null) {
            JTableHeaderDriver.$$$reportNull$$$0(15);
        }
        JPopupMenu jPopupMenu = this.robot.showPopupMenu(tableHeader, JTableHeaderDriver.pointAtIndex(tableHeader, columnIndex, this.location));
        if (jPopupMenu == null) {
            JTableHeaderDriver.$$$reportNull$$$0(16);
        }
        return jPopupMenu;
    }

    @Nonnull
    @RunsInEDT
    private static Point pointAtIndex(final @Nonnull JTableHeader tableHeader, final int columnIndex, final JTableHeaderLocation location) {
        if (tableHeader == null) {
            JTableHeaderDriver.$$$reportNull$$$0(17);
        }
        Point result = GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                Point p = location.pointAt(tableHeader, columnIndex);
                ComponentPreconditions.checkEnabledAndShowing(tableHeader);
                tableHeader.getTable().scrollRectToVisible(tableHeader.getHeaderRect(columnIndex));
                return p;
            }
        });
        Point point = (Point)Preconditions.checkNotNull((Object)result);
        if (point == null) {
            JTableHeaderDriver.$$$reportNull$$$0(18);
        }
        return point;
    }

    @Nonnull
    @RunsInEDT
    public JPopupMenu showPopupMenu(@Nonnull JTableHeader tableHeader, @Nullable String columnName) {
        if (tableHeader == null) {
            JTableHeaderDriver.$$$reportNull$$$0(19);
        }
        JPopupMenu jPopupMenu = this.robot.showPopupMenu(tableHeader, JTableHeaderDriver.pointAtName(tableHeader, new StringTextMatcher(columnName), this.location()));
        if (jPopupMenu == null) {
            JTableHeaderDriver.$$$reportNull$$$0(20);
        }
        return jPopupMenu;
    }

    @Nonnull
    @RunsInEDT
    public JPopupMenu showPopupMenu(@Nonnull JTableHeader tableHeader, @Nonnull Pattern pattern) {
        if (tableHeader == null) {
            JTableHeaderDriver.$$$reportNull$$$0(21);
        }
        if (pattern == null) {
            JTableHeaderDriver.$$$reportNull$$$0(22);
        }
        JPopupMenu jPopupMenu = this.robot.showPopupMenu(tableHeader, JTableHeaderDriver.pointAtName(tableHeader, new PatternTextMatcher(pattern), this.location()));
        if (jPopupMenu == null) {
            JTableHeaderDriver.$$$reportNull$$$0(23);
        }
        return jPopupMenu;
    }

    @Nonnull
    @RunsInEDT
    private static Point pointAtName(final @Nonnull JTableHeader tableHeader, final @Nonnull TextMatcher matcher, final @Nonnull JTableHeaderLocation location) {
        if (tableHeader == null) {
            JTableHeaderDriver.$$$reportNull$$$0(24);
        }
        if (matcher == null) {
            JTableHeaderDriver.$$$reportNull$$$0(25);
        }
        if (location == null) {
            JTableHeaderDriver.$$$reportNull$$$0(26);
        }
        Point result = GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                Pair<Integer, Point> indexAndLocation = location.pointAt(tableHeader, matcher);
                ComponentPreconditions.checkEnabledAndShowing(tableHeader);
                tableHeader.getTable().scrollRectToVisible(tableHeader.getHeaderRect((Integer)indexAndLocation.first));
                return (Point)indexAndLocation.second;
            }
        });
        Point point = (Point)Preconditions.checkNotNull((Object)result);
        if (point == null) {
            JTableHeaderDriver.$$$reportNull$$$0(27);
        }
        return point;
    }

    @Nonnull
    private JTableHeaderLocation location() {
        JTableHeaderLocation jTableHeaderLocation = this.location;
        if (jTableHeaderLocation == null) {
            JTableHeaderDriver.$$$reportNull$$$0(28);
        }
        return jTableHeaderLocation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 18: 
            case 20: 
            case 23: 
            case 27: 
            case 28: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 18: 
            case 20: 
            case 23: 
            case 27: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "robot";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableHeader";
                break;
            }
            case 3: 
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnNamePattern";
                break;
            }
            case 13: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 16: 
            case 18: 
            case 20: 
            case 23: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/driver/JTableHeaderDriver";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/driver/JTableHeaderDriver";
                break;
            }
            case 16: 
            case 20: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "showPopupMenu";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "pointAtIndex";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "pointAtName";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "clickColumn";
                break;
            }
            case 15: 
            case 19: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "showPopupMenu";
                break;
            }
            case 16: 
            case 18: 
            case 20: 
            case 23: 
            case 27: 
            case 28: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "pointAtIndex";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "pointAtName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 18: 
            case 20: 
            case 23: 
            case 27: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

