/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.image;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.FocusOwnerFinder;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.image.ImageException;
import org.fest.swing.image.ImageFileWriter;
import org.fest.swing.query.ComponentLocationOnScreenQuery;
import org.fest.swing.query.ComponentSizeQuery;
import org.fest.swing.util.RobotFactory;
import org.fest.util.IORuntimeException;
import org.fest.util.Preconditions;
import org.fest.util.VisibleForTesting;

public class ScreenshotTaker {
    private final Robot robot;
    private final ImageFileWriter writer;

    public ScreenshotTaker() {
        this(new ImageFileWriter(), new RobotFactory());
    }

    @VisibleForTesting
    ScreenshotTaker(@Nonnull ImageFileWriter writer, @Nonnull RobotFactory robotFactory) {
        if (writer == null) {
            ScreenshotTaker.$$$reportNull$$$0(0);
        }
        if (robotFactory == null) {
            ScreenshotTaker.$$$reportNull$$$0(1);
        }
        this.writer = writer;
        try {
            this.robot = robotFactory.newRobotInPrimaryScreen();
        }
        catch (AWTException e) {
            throw new ImageException("Unable to create AWT Robot", e);
        }
    }

    public void saveDesktopAsPng(String imageFilePath) {
        BufferedImage image = this.takeDesktopScreenshot();
        ScreenshotTaker.indicatePointerLocation(image);
        this.saveImage(image, imageFilePath);
    }

    private static void indicatePointerLocation(BufferedImage image) {
        Point mouse = MouseInfo.getPointerInfo().getLocation();
        Graphics g = image.getGraphics();
        g.setColor(Color.RED);
        g.fillRect(mouse.x - 10, mouse.y, 20, 1);
        g.fillRect(mouse.x, mouse.y - 10, 1, 20);
        g.dispose();
    }

    public BufferedImage takeDesktopScreenshot() {
        Rectangle r = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
        return this.takeScreenshot(r);
    }

    public void saveComponentAsPng(@Nonnull Component c, @Nonnull String imageFilePath) {
        if (c == null) {
            ScreenshotTaker.$$$reportNull$$$0(2);
        }
        if (imageFilePath == null) {
            ScreenshotTaker.$$$reportNull$$$0(3);
        }
        this.saveImage(this.takeScreenshotOf(c), imageFilePath);
    }

    @Nonnull
    public BufferedImage takeScreenshotOf(@Nonnull Component c) {
        if (c == null) {
            ScreenshotTaker.$$$reportNull$$$0(4);
        }
        Point locationOnScreen = ComponentLocationOnScreenQuery.locationOnScreen(c);
        Dimension size = ComponentSizeQuery.sizeOf(c);
        Rectangle r = new Rectangle(locationOnScreen.x, locationOnScreen.y, size.width, size.height);
        BufferedImage bufferedImage = this.takeScreenshot(r);
        if (bufferedImage == null) {
            ScreenshotTaker.$$$reportNull$$$0(5);
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private BufferedImage takeScreenshot(Rectangle r) {
        JTextComponent textComponent = ScreenshotTaker.findFocusOwnerAndHideItsCaret();
        this.robot.waitForIdle();
        BufferedImage bufferedImage = ScreenshotTaker.takeScreenshot(this.robot, r);
        BufferedImage bufferedImage2 = bufferedImage;
        if (bufferedImage2 == null) {
            ScreenshotTaker.$$$reportNull$$$0(6);
        }
        return bufferedImage2;
        finally {
            this.showCaretIfPossible(textComponent);
        }
    }

    @RunsInEDT
    private static JTextComponent findFocusOwnerAndHideItsCaret() {
        return GuiActionRunner.execute(new GuiQuery<JTextComponent>(){

            @Override
            protected JTextComponent executeInEDT() {
                Component focusOwner = FocusOwnerFinder.focusOwner();
                if (!(focusOwner instanceof JTextComponent)) {
                    return null;
                }
                JTextComponent textComponent = (JTextComponent)focusOwner;
                Caret caret = textComponent.getCaret();
                if (caret == null || !caret.isVisible()) {
                    return null;
                }
                caret.setVisible(false);
                return textComponent;
            }
        });
    }

    @Nonnull
    private static BufferedImage takeScreenshot(final @Nonnull Robot robot, final @Nonnull Rectangle r) {
        if (robot == null) {
            ScreenshotTaker.$$$reportNull$$$0(7);
        }
        if (r == null) {
            ScreenshotTaker.$$$reportNull$$$0(8);
        }
        BufferedImage result = GuiActionRunner.execute(new GuiQuery<BufferedImage>(){

            @Override
            @Nullable
            protected BufferedImage executeInEDT() {
                return robot.createScreenCapture(r);
            }
        });
        BufferedImage bufferedImage = (BufferedImage)Preconditions.checkNotNull((Object)result);
        if (bufferedImage == null) {
            ScreenshotTaker.$$$reportNull$$$0(9);
        }
        return bufferedImage;
    }

    private void showCaretIfPossible(@Nullable JTextComponent textComponent) {
        if (textComponent == null) {
            return;
        }
        ScreenshotTaker.showCaretOf(textComponent);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private static void showCaretOf(final @Nonnull JTextComponent textComponent) {
        if (textComponent == null) {
            ScreenshotTaker.$$$reportNull$$$0(10);
        }
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                Caret caret = textComponent.getCaret();
                if (caret != null) {
                    caret.setVisible(true);
                }
            }
        });
    }

    public void saveImage(@Nonnull BufferedImage image, @Nonnull String filePath) {
        if (image == null) {
            ScreenshotTaker.$$$reportNull$$$0(11);
        }
        if (filePath == null) {
            ScreenshotTaker.$$$reportNull$$$0(12);
        }
        Preconditions.checkNotNullOrEmpty((String)filePath);
        if (!filePath.endsWith("png")) {
            String format = String.format("The file in path '%s' should have extension 'png'", filePath);
            throw new IllegalArgumentException(format);
        }
        try {
            this.writer.writeAsPng(image, filePath);
        }
        catch (IOException e) {
            String msg = String.format("Unable to save image as '%s'", filePath);
            throw new IORuntimeException(msg, e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "robotFactory";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageFilePath";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/image/ScreenshotTaker";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "robot";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textComponent";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/image/ScreenshotTaker";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "takeScreenshotOf";
                break;
            }
            case 6: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "takeScreenshot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "saveComponentAsPng";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "takeScreenshotOf";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "takeScreenshot";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "showCaretOf";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "saveImage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

