/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.lock;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.fest.swing.exception.ScreenLockException;

@ThreadSafe
public final class ScreenLock {
    private final Lock lock = new ReentrantLock();
    private final Condition released = this.lock.newCondition();
    @GuardedBy(value="lock")
    private Object owner;
    @GuardedBy(value="lock")
    private boolean acquired;

    public void acquire(@Nonnull Object newOwner) {
        if (newOwner == null) {
            ScreenLock.$$$reportNull$$$0(0);
        }
        this.lock.lock();
        try {
            if (this.acquired && this.owner == newOwner) {
                return;
            }
            while (this.acquired) {
                this.released.await();
            }
            this.owner = newOwner;
            this.acquired = true;
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void release(@Nonnull Object currentOwner) {
        if (currentOwner == null) {
            ScreenLock.$$$reportNull$$$0(1);
        }
        this.lock.lock();
        try {
            if (!this.acquired) {
                throw new ScreenLockException("No lock to release");
            }
            if (this.owner != currentOwner) {
                throw new ScreenLockException(String.format("%s is not the lock owner", currentOwner.toString()));
            }
            this.acquired = false;
            this.owner = null;
            this.released.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean acquiredBy(@Nullable Object possibleOwner) {
        if (possibleOwner == null) {
            return false;
        }
        this.lock.lock();
        try {
            boolean bl = this.acquired && this.owner == possibleOwner;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean acquired() {
        this.lock.lock();
        try {
            boolean bl = this.acquired;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Nonnull
    public static ScreenLock instance() {
        ScreenLock screenLock = ScreenLockHolder.instance;
        if (screenLock == null) {
            ScreenLock.$$$reportNull$$$0(2);
        }
        return screenLock;
    }

    ScreenLock() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newOwner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentOwner";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/lock/ScreenLock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/lock/ScreenLock";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "instance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "acquire";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "release";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ScreenLockHolder {
        static ScreenLock instance = new ScreenLock();

        private ScreenLockHolder() {
        }
    }
}

