/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.remote.RemoteFile;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.WebDeploymentCredentialsHolder;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.remote.ext.PathMappingProviderEx;
import com.intellij.remote.ext.PathMappingType;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PublishConfigMappingProvider
extends PathMappingProviderEx {
    @NotNull
    public PathMappingType getMappingType() {
        PathMappingType pathMappingType = PathMappingType.DEPLOYMENT;
        if (pathMappingType == null) {
            PublishConfigMappingProvider.$$$reportNull$$$0(0);
        }
        return pathMappingType;
    }

    @NotNull
    public String getProviderPresentableName(@NotNull RemoteSdkAdditionalData data) {
        if (data == null) {
            PublishConfigMappingProvider.$$$reportNull$$$0(1);
        }
        final Ref name = new Ref();
        data.switchOnConnectionType(new CredentialsCase[]{new CredentialsCase.Ssh(){

            public void process(RemoteCredentialsHolder credentials) {
                name.set((Object)"SFTP Deployment configurations");
            }
        }, new CredentialsCase.WebDeployment(){

            public void process(WebDeploymentCredentialsHolder cred) {
                name.set((Object)("'" + cred.getWebServerConfigName() + "' Deployment configuration"));
            }
        }});
        String string = (String)name.get();
        if (string == null) {
            PublishConfigMappingProvider.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean accepts(@Nullable RemoteSdkAdditionalData data) {
        return data != null && (data.connectionCredentials().getRemoteConnectionType() == CredentialsType.WEB_DEPLOYMENT || data.connectionCredentials().getRemoteConnectionType() == CredentialsType.SSH_HOST);
    }

    @NotNull
    public PathMappingSettings getPathMappingSettings(final @NotNull Project project, final @NotNull RemoteSdkAdditionalData data) {
        if (project == null) {
            PublishConfigMappingProvider.$$$reportNull$$$0(3);
        }
        if (data == null) {
            PublishConfigMappingProvider.$$$reportNull$$$0(4);
        }
        final PathMappingSettings mappingSettings = new PathMappingSettings();
        data.switchOnConnectionType(new CredentialsCase[]{new CredentialsCase.Ssh(){

            public void process(RemoteCredentialsHolder cred) {
                try {
                    RemoteSdkCredentials credentials = data.getRemoteSdkCredentials(project, false);
                    mappingSettings.addAll(PublishConfigMappingProvider.getPathMappingsForDeploymentConfigurations(project, (RemoteCredentials)credentials));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, new CredentialsCase.WebDeployment(){

            public void process(WebDeploymentCredentialsHolder cred) {
                PublishConfig publishConfig = PublishConfig.getInstance((Project)project);
                for (WebServerConfig webConfig : RemoteSdkUtil.getSftpServerList(project)) {
                    if (cred.getWebServerConfigId() == null || !cred.getWebServerConfigId().equals(webConfig.getId())) continue;
                    PublishConfigMappingProvider.addMappings(webConfig, publishConfig, mappingSettings);
                }
            }
        }});
        PathMappingSettings pathMappingSettings = mappingSettings;
        if (pathMappingSettings == null) {
            PublishConfigMappingProvider.$$$reportNull$$$0(5);
        }
        return pathMappingSettings;
    }

    private static void addMappings(WebServerConfig webConfig, PublishConfig publishConfig, PathMappingSettings mappingSettings) {
        List mappings = publishConfig.getPathMappings(webConfig.getId());
        for (DeploymentPathMapping mapping : mappings) {
            String rootFolder = webConfig.getFileTransferConfig().getRootFolder();
            rootFolder = rootFolder.replaceAll("\\\\", "/").trim();
            rootFolder = StringUtil.trimEnd((String)rootFolder, (String)"/");
            if (StringUtil.isEmpty((String)mapping.getLocalPath()) || StringUtil.isEmpty((String)mapping.getDeployPath())) continue;
            mappingSettings.addMapping(mapping.getLocalPath(), new RemoteFile(rootFolder, mapping.getDeployPath()).getPath());
        }
    }

    public static PathMappingSettings getPathMappingsForDeploymentConfigurations(Project project, RemoteCredentials data) {
        PathMappingSettings mappingSettings = new PathMappingSettings();
        PublishConfig publishConfig = PublishConfig.getInstance((Project)project);
        for (WebServerConfig webConfig : RemoteSdkUtil.getSftpServerList(project)) {
            if (!StringUtil.equals((CharSequence)PublishConfigMappingProvider.normalizeHost(webConfig.getFileTransferConfig().getHost()), (CharSequence)PublishConfigMappingProvider.normalizeHost(data.getHost()))) continue;
            PublishConfigMappingProvider.addMappings(webConfig, publishConfig, mappingSettings);
        }
        return mappingSettings;
    }

    public static String getDeploymentConfigurationWithMappingsName(Project project, RemoteCredentials data) {
        PublishConfig publishConfig = PublishConfig.getInstance((Project)project);
        for (WebServerConfig webConfig : RemoteSdkUtil.getSftpServerList(project)) {
            DeploymentPathMapping mapping;
            List mappings = publishConfig.getPathMappings(webConfig.getId());
            if (mappings.isEmpty()) continue;
            boolean mappingsNotEmpty = false;
            Iterator iterator = mappings.iterator();
            while (iterator.hasNext() && !(mappingsNotEmpty = !StringUtil.isEmptyOrSpaces((String)(mapping = (DeploymentPathMapping)iterator.next()).getLocalPath()) && !StringUtil.isEmptyOrSpaces((String)mapping.getDeployPath()))) {
            }
            if (!mappingsNotEmpty || !StringUtil.equals((CharSequence)PublishConfigMappingProvider.normalizeHost(webConfig.getFileTransferConfig().getHost()), (CharSequence)PublishConfigMappingProvider.normalizeHost(data.getHost()))) continue;
            return webConfig.getName();
        }
        return null;
    }

    @Nullable
    private static CharSequence normalizeHost(@Nullable String host) {
        if ("localhost".equals(host)) {
            return "127.0.0.1";
        }
        return host;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/remotesdk/PublishConfigMappingProvider";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappingType";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/remotesdk/PublishConfigMappingProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviderPresentableName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathMappingSettings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getProviderPresentableName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPathMappingSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

