/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.osgi.bnd.resolve;

import aQute.bnd.build.Project;
import aQute.bnd.build.Run;
import aQute.bnd.build.Workspace;
import aQute.bnd.build.model.BndEditModel;
import aQute.bnd.build.model.clauses.HeaderClause;
import aQute.bnd.build.model.clauses.VersionedClause;
import aQute.bnd.header.Attrs;
import aQute.bnd.properties.IDocument;
import biz.aQute.resolve.ProjectResolver;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.osgi.bnd.resolve.ResolutionFailed;
import org.jetbrains.osgi.bnd.resolve.ResolveConfirm;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.service.resolver.ResolutionException;
import org.osmorc.i18n.OsmorcBundle;

public class ResolveAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(ResolveAction.class);

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            ResolveAction.$$$reportNull$$$0(0);
        }
        final VirtualFile virtualFile = (VirtualFile)event.getData(CommonDataKeys.VIRTUAL_FILE);
        final com.intellij.openapi.project.Project project = event.getProject();
        if (virtualFile == null || project == null) {
            return;
        }
        final Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document == null) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        new Task.Backgroundable(project, OsmorcBundle.message("bnd.resolve.requirements.title", new Object[0]), true){
            private Map<Resource, List<Wire>> resolveResult;
            private String updatedText;

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setIndeterminate(true);
                File file = new File(virtualFile.getPath());
                try (Workspace workspace = Workspace.findWorkspace((File)file);
                     Run run = Run.createRun((Workspace)workspace, (File)file);
                     ProjectResolver projectResolver = new ProjectResolver((Project)run);){
                    this.resolveResult = projectResolver.resolve();
                    List versionedClauses = projectResolver.getRunBundles().stream().map(c -> {
                        Attrs attrs = new Attrs();
                        attrs.put("version", c.getVersion());
                        return new VersionedClause(c.getBundleSymbolicName(), attrs);
                    }).sorted(Comparator.comparing(HeaderClause::getName)).collect(Collectors.toList());
                    BndEditModel editModel = new BndEditModel();
                    aQute.bnd.properties.Document bndDocument = new aQute.bnd.properties.Document(document.getImmutableCharSequence().toString());
                    editModel.loadFrom((IDocument)bndDocument);
                    editModel.setRunBundles(versionedClauses);
                    editModel.saveChangesTo((IDocument)bndDocument);
                    this.updatedText = bndDocument.get();
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new WrappingException(e);
                }
                indicator.checkCanceled();
            }

            public void onSuccess() {
                if (new ResolutionSucceedDialog(project, this.resolveResult).showAndGet() && FileModificationService.getInstance().prepareVirtualFilesForWrite(project, Collections.singleton(virtualFile))) {
                    WriteCommandAction.writeCommandAction((com.intellij.openapi.project.Project)project).withName("Bndrun Resolve").run(() -> document.setText((CharSequence)this.updatedText));
                }
            }

            public void onThrowable(@NotNull Throwable t) {
                if (t == null) {
                    1.$$$reportNull$$$0(1);
                }
                Throwable cause = t instanceof WrappingException ? t.getCause() : t;
                LOG.warn("Resolution failed", cause);
                if (cause instanceof ResolutionException) {
                    new ResolutionFailedDialog(project, (ResolutionException)cause).show();
                } else {
                    OsmorcBundle.notification(OsmorcBundle.message("bnd.resolve.failed.title", new Object[0]), cause.getMessage(), NotificationType.ERROR).notify(project);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "t";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/osgi/bnd/resolve/ResolveAction$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "run";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onThrowable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.queue();
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            ResolveAction.$$$reportNull$$$0(1);
        }
        VirtualFile virtualFile = (VirtualFile)event.getData(CommonDataKeys.VIRTUAL_FILE);
        event.getPresentation().setEnabledAndVisible(virtualFile != null && "bndrun".equals(virtualFile.getExtension()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "event";
        objectArray2[1] = "org/jetbrains/osgi/bnd/resolve/ResolveAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ResolutionFailedDialog
    extends DialogWrapper {
        private final ResolutionException myResolutionException;

        public ResolutionFailedDialog(com.intellij.openapi.project.Project project, ResolutionException resolutionException) {
            super(project);
            this.myResolutionException = resolutionException;
            this.init();
            this.setTitle(OsmorcBundle.message("bnd.resolve.failed.title", new Object[0]));
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return new ResolutionFailed(this.myResolutionException).getContentPane();
        }

        @NotNull
        protected Action[] createActions() {
            Action[] actionArray = new Action[]{this.getOKAction()};
            if (actionArray == null) {
                ResolutionFailedDialog.$$$reportNull$$$0(0);
            }
            return actionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/bnd/resolve/ResolveAction$ResolutionFailedDialog", "createActions"));
        }
    }

    private static class ResolutionSucceedDialog
    extends DialogWrapper {
        private final Map<Resource, List<Wire>> myResolveResult;

        public ResolutionSucceedDialog(com.intellij.openapi.project.Project project, Map<Resource, List<Wire>> resolveResult) {
            super(project);
            this.myResolveResult = resolveResult;
            this.init();
            this.setTitle(OsmorcBundle.message("bnd.resolve.succeed.title", new Object[0]));
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return new ResolveConfirm(this.myResolveResult).getContentPane();
        }

        @NotNull
        protected Action[] createActions() {
            Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction()};
            if (actionArray == null) {
                ResolutionSucceedDialog.$$$reportNull$$$0(0);
            }
            return actionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/bnd/resolve/ResolveAction$ResolutionSucceedDialog", "createActions"));
        }
    }

    private static class WrappingException
    extends RuntimeException {
        private WrappingException(Throwable cause) {
            super(cause);
        }
    }
}

