/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.facet;

import com.intellij.facet.FacetType;
import com.intellij.framework.detection.FacetBasedFrameworkDetector;
import com.intellij.framework.detection.FileContentPattern;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileContent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.lang.manifest.ManifestFileTypeFactory;
import org.jetbrains.osgi.jps.model.ManifestGenerationMode;
import org.osmorc.facet.OsmorcFacet;
import org.osmorc.facet.OsmorcFacetConfiguration;
import org.osmorc.facet.OsmorcFacetType;

public class OsmorcFrameworkDetector
extends FacetBasedFrameworkDetector<OsmorcFacet, OsmorcFacetConfiguration> {
    private final Logger logger = Logger.getInstance((String)"#org.osmorc.facet.OsmorcFrameworkDetector");
    private final String[] DETECTION_HEADERS = new String[]{"Bundle-SymbolicName"};

    public OsmorcFrameworkDetector() {
        super("osmorc");
    }

    @NotNull
    public FacetType<OsmorcFacet, OsmorcFacetConfiguration> getFacetType() {
        OsmorcFacetType osmorcFacetType = OsmorcFacetType.getInstance();
        if (osmorcFacetType == null) {
            OsmorcFrameworkDetector.$$$reportNull$$$0(0);
        }
        return osmorcFacetType;
    }

    protected OsmorcFacetConfiguration createConfiguration(Collection<VirtualFile> files) {
        OsmorcFacetConfiguration osmorcFacetConfiguration = (OsmorcFacetConfiguration)this.getFacetType().createDefaultConfiguration();
        osmorcFacetConfiguration.setManifestGenerationMode(ManifestGenerationMode.Manually);
        osmorcFacetConfiguration.setManifestLocation(((VirtualFile)ContainerUtil.getFirstItem(files)).getPath());
        osmorcFacetConfiguration.setUseProjectDefaultManifestFileLocation(false);
        return osmorcFacetConfiguration;
    }

    public void setupFacet(@NotNull OsmorcFacet facet, ModifiableRootModel model) {
        if (facet == null) {
            OsmorcFrameworkDetector.$$$reportNull$$$0(1);
        }
        VirtualFile[] contentRoots = model.getContentRoots();
        OsmorcFacetConfiguration osmorcFacetConfiguration = (OsmorcFacetConfiguration)facet.getConfiguration();
        VirtualFile manifestFile = LocalFileSystem.getInstance().findFileByPath(osmorcFacetConfiguration.getManifestLocation());
        if (manifestFile != null) {
            for (VirtualFile contentRoot : contentRoots) {
                if (!VfsUtilCore.isAncestor((VirtualFile)contentRoot, (VirtualFile)manifestFile, (boolean)false)) continue;
                osmorcFacetConfiguration.setManifestLocation(VfsUtilCore.getRelativePath((VirtualFile)manifestFile, (VirtualFile)contentRoot, (char)'/'));
                break;
            }
        } else {
            osmorcFacetConfiguration.setManifestLocation("");
            osmorcFacetConfiguration.setUseProjectDefaultManifestFileLocation(true);
        }
        String manifestFileName = osmorcFacetConfiguration.getManifestLocation();
        if (manifestFileName.endsWith("template.mf")) {
            osmorcFacetConfiguration.setManifestLocation("");
            osmorcFacetConfiguration.setBundlorFileLocation(manifestFileName);
            osmorcFacetConfiguration.setManifestGenerationMode(ManifestGenerationMode.Bundlor);
        }
    }

    @NotNull
    public ElementPattern<FileContent> createSuitableFilePattern() {
        ObjectPattern objectPattern = FileContentPattern.fileContent().with((PatternCondition)new PatternCondition<FileContent>("osmorc manifest file"){

            public boolean accepts(@NotNull FileContent content, ProcessingContext context) {
                if (content == null) {
                    1.$$$reportNull$$$0(0);
                }
                return OsmorcFrameworkDetector.this.isSuitableFile(content.getContentAsText());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/osmorc/facet/OsmorcFrameworkDetector$1", "accepts"));
            }
        });
        if (objectPattern == null) {
            OsmorcFrameworkDetector.$$$reportNull$$$0(2);
        }
        return objectPattern;
    }

    @NotNull
    public FileType getFileType() {
        LanguageFileType languageFileType = ManifestFileTypeFactory.MANIFEST;
        if (languageFileType == null) {
            OsmorcFrameworkDetector.$$$reportNull$$$0(3);
        }
        return languageFileType;
    }

    private boolean isSuitableFile(CharSequence fileContent) {
        ArrayList<String> headersToDetect = new ArrayList<String>(Arrays.asList(this.DETECTION_HEADERS));
        StringTokenizer linesTokenizer = new StringTokenizer(fileContent.toString(), "\r\n");
        block0: while (linesTokenizer.hasMoreTokens()) {
            String line = linesTokenizer.nextToken();
            Iterator iterator = headersToDetect.iterator();
            while (iterator.hasNext()) {
                String headerToDetect = (String)iterator.next();
                if (!line.startsWith(headerToDetect)) continue;
                iterator.remove();
                continue block0;
            }
        }
        return headersToDetect.size() == 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/osmorc/facet/OsmorcFrameworkDetector";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacetType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/osmorc/facet/OsmorcFrameworkDetector";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createSuitableFilePattern";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setupFacet";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

