/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.make;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.osgi.jps.build.BndWrapper;
import org.jetbrains.osgi.jps.build.OsgiBuildException;
import org.jetbrains.osgi.jps.build.Reporter;
import org.jetbrains.osgi.jps.model.LibraryBundlificationRule;
import org.osmorc.settings.ApplicationSettings;

public class BundleCompiler
implements Reporter {
    private static final Logger LOG = Logger.getInstance(BundleCompiler.class);
    private final ProgressIndicator myIndicator;

    public BundleCompiler(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            BundleCompiler.$$$reportNull$$$0(0);
        }
        this.myIndicator = indicator;
    }

    @NotNull
    public List<String> bundlifyLibraries(@NotNull Module module) throws OsgiBuildException {
        if (module == null) {
            BundleCompiler.$$$reportNull$$$0(1);
        }
        this.myIndicator.setText("Bundling non-OSGi libraries for module '" + module.getName() + "'");
        File outputDir = BndWrapper.getOutputDir((File)BundleCompiler.getModuleOutputDir(module));
        List<LibraryBundlificationRule> libRules = ApplicationSettings.getInstance().getLibraryBundlificationRules();
        List paths = OrderEnumerator.orderEntries((Module)module).withoutSdk().withoutModuleSourceEntries().withoutDepModules().productionOnly().runtimeOnly().recursively().exportedOnly().classes().getPathsList().getPathList();
        List files = ContainerUtil.map((Collection)paths, path -> new File((String)path));
        List list = new BndWrapper((Reporter)this).bundlifyLibraries((Collection)files, outputDir, libRules);
        if (list == null) {
            BundleCompiler.$$$reportNull$$$0(2);
        }
        return list;
    }

    private static File getModuleOutputDir(@NotNull Module module) throws OsgiBuildException {
        String url;
        CompilerModuleExtension extension;
        if (module == null) {
            BundleCompiler.$$$reportNull$$$0(3);
        }
        if ((extension = CompilerModuleExtension.getInstance((Module)module)) != null && (url = extension.getCompilerOutputUrl()) != null) {
            return new File(VfsUtilCore.urlToPath((String)url));
        }
        throw new OsgiBuildException("Unable to determine the compiler output path for the module '" + module.getName() + "'");
    }

    public void progress(@NotNull String message) {
        if (message == null) {
            BundleCompiler.$$$reportNull$$$0(4);
        }
        LOG.debug(message);
        this.myIndicator.setText2(message);
    }

    public void warning(@NotNull String message, @Nullable Throwable t, @Nullable String sourcePath, int lineNum) {
        if (message == null) {
            BundleCompiler.$$$reportNull$$$0(5);
        }
        LOG.warn(message, t);
    }

    public void error(@NotNull String message, @Nullable Throwable t, @Nullable String sourcePath, int lineNum) {
        if (message == null) {
            BundleCompiler.$$$reportNull$$$0(6);
        }
        LOG.warn(message, t);
    }

    public boolean isDebugEnabled() {
        return LOG.isDebugEnabled();
    }

    public void debug(@NotNull String message) {
        if (message == null) {
            BundleCompiler.$$$reportNull$$$0(7);
        }
        LOG.debug(message);
    }

    public String setReportSource(String source) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/osmorc/make/BundleCompiler";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/osmorc/make/BundleCompiler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "bundlifyLibraries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "bundlifyLibraries";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getModuleOutputDir";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "progress";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "warning";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "debug";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

