/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.CommonBundle;
import com.intellij.codeEditor.printing.ExportToHTMLSettings;
import com.intellij.coverage.CoverageAnnotator;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.IdeaClassFinder;
import com.intellij.coverage.JavaCoverageAnnotator;
import com.intellij.coverage.JavaCoverageEngineExtension;
import com.intellij.coverage.JavaCoverageOptionsProvider;
import com.intellij.coverage.JavaCoverageSuite;
import com.intellij.coverage.SourceLineCounterUtil;
import com.intellij.coverage.view.CoverageViewExtension;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.coverage.view.JavaCoverageViewExtension;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.configurations.coverage.JavaCoverageEnabledConfiguration;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.controlFlow.AllVariablesControlFlowPolicy;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ConditionalBranchingInstruction;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowPolicy;
import com.intellij.psi.controlFlow.Instruction;
import com.intellij.psi.impl.source.tree.java.PsiSwitchStatementImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.rt.coverage.data.JumpData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.data.SwitchData;
import com.intellij.rt.coverage.instrumentation.SaveHook;
import com.intellij.rt.coverage.util.classFinder.ClassFinder;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import jetbrains.coverage.report.ClassInfo;
import jetbrains.coverage.report.CoverageData;
import jetbrains.coverage.report.ReportBuilderFactory;
import jetbrains.coverage.report.ReportGenerationFailedException;
import jetbrains.coverage.report.SourceCodeProvider;
import jetbrains.coverage.report.html.HTMLReportBuilder;
import jetbrains.coverage.report.idea.IDEACoverageData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class JavaCoverageEngine
extends CoverageEngine {
    private static final Logger LOG = Logger.getInstance((String)JavaCoverageEngine.class.getName());

    public static JavaCoverageEngine getInstance() {
        return (JavaCoverageEngine)Extensions.findExtension((ExtensionPointName)EP_NAME, JavaCoverageEngine.class);
    }

    @Override
    public boolean isApplicableTo(@Nullable RunConfigurationBase conf) {
        if (conf instanceof CommonJavaRunConfigurationParameters) {
            return true;
        }
        for (JavaCoverageEngineExtension extension : (JavaCoverageEngineExtension[])Extensions.getExtensions(JavaCoverageEngineExtension.EP_NAME)) {
            if (!extension.isApplicableTo(conf)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canHavePerTestCoverage(@Nullable RunConfigurationBase conf) {
        return !(conf instanceof ApplicationConfiguration) && conf instanceof CommonJavaRunConfigurationParameters;
    }

    @Override
    @NotNull
    public CoverageEnabledConfiguration createCoverageEnabledConfiguration(@Nullable RunConfigurationBase conf) {
        JavaCoverageEnabledConfiguration javaCoverageEnabledConfiguration = new JavaCoverageEnabledConfiguration(conf, this);
        if (javaCoverageEnabledConfiguration == null) {
            JavaCoverageEngine.$$$reportNull$$$0(0);
        }
        return javaCoverageEnabledConfiguration;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public CoverageSuite createCoverageSuite(@NotNull CoverageRunner covRunner, @NotNull String name, @NotNull CoverageFileProvider coverageDataFileProvider, String[] filters, long lastCoverageTimeStamp, String suiteToMerge, boolean coverageByTestEnabled, boolean tracingEnabled, boolean trackTestFolders, Project project) {
        void project2;
        if (covRunner == null) {
            JavaCoverageEngine.$$$reportNull$$$0(1);
        }
        if (name == null) {
            JavaCoverageEngine.$$$reportNull$$$0(2);
        }
        if (coverageDataFileProvider == null) {
            JavaCoverageEngine.$$$reportNull$$$0(3);
        }
        return this.createSuite(covRunner, name, coverageDataFileProvider, filters, null, lastCoverageTimeStamp, coverageByTestEnabled, tracingEnabled, trackTestFolders, (Project)project2);
    }

    @Override
    public CoverageSuite createCoverageSuite(@NotNull CoverageRunner covRunner, @NotNull String name, @NotNull CoverageFileProvider coverageDataFileProvider, @NotNull CoverageEnabledConfiguration config) {
        if (covRunner == null) {
            JavaCoverageEngine.$$$reportNull$$$0(4);
        }
        if (name == null) {
            JavaCoverageEngine.$$$reportNull$$$0(5);
        }
        if (coverageDataFileProvider == null) {
            JavaCoverageEngine.$$$reportNull$$$0(6);
        }
        if (config == null) {
            JavaCoverageEngine.$$$reportNull$$$0(7);
        }
        if (config instanceof JavaCoverageEnabledConfiguration) {
            JavaCoverageEnabledConfiguration javaConfig = (JavaCoverageEnabledConfiguration)config;
            return this.createSuite(covRunner, name, coverageDataFileProvider, javaConfig.getPatterns(), javaConfig.getExcludePatterns(), new Date().getTime(), javaConfig.isTrackPerTestCoverage() && !javaConfig.isSampling(), !javaConfig.isSampling(), javaConfig.isTrackTestFolders(), config.getConfiguration().getProject());
        }
        return null;
    }

    @Override
    @Nullable
    public CoverageSuite createEmptyCoverageSuite(@NotNull CoverageRunner coverageRunner) {
        if (coverageRunner == null) {
            JavaCoverageEngine.$$$reportNull$$$0(8);
        }
        return new JavaCoverageSuite(this);
    }

    @Override
    @NotNull
    public CoverageAnnotator getCoverageAnnotator(Project project) {
        JavaCoverageAnnotator javaCoverageAnnotator = JavaCoverageAnnotator.getInstance(project);
        if (javaCoverageAnnotator == null) {
            JavaCoverageEngine.$$$reportNull$$$0(9);
        }
        return javaCoverageAnnotator;
    }

    @Override
    public boolean coverageEditorHighlightingApplicableTo(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            JavaCoverageEngine.$$$reportNull$$$0(10);
        }
        if (!(psiFile instanceof PsiClassOwner)) {
            return false;
        }
        Module module = (Module)ReadAction.compute(() -> {
            if (psiFile == null) {
                JavaCoverageEngine.$$$reportNull$$$0(53);
            }
            return ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile);
        });
        return module != null;
    }

    @Override
    public boolean acceptedByFilters(@NotNull PsiFile psiFile, @NotNull CoverageSuitesBundle suite) {
        VirtualFile virtualFile;
        if (psiFile == null) {
            JavaCoverageEngine.$$$reportNull$$$0(11);
        }
        if (suite == null) {
            JavaCoverageEngine.$$$reportNull$$$0(12);
        }
        if ((virtualFile = psiFile.getVirtualFile()) == null) {
            return false;
        }
        Project project = psiFile.getProject();
        if (!suite.isTrackTestFolders() && TestSourcesFilter.isTestSources((VirtualFile)virtualFile, (Project)project)) {
            return false;
        }
        for (CoverageSuite coverageSuite : suite.getSuites()) {
            JavaCoverageSuite javaSuite = (JavaCoverageSuite)coverageSuite;
            if (javaSuite.isPackageFiltered((String)ReadAction.compute(() -> {
                if (psiFile == null) {
                    JavaCoverageEngine.$$$reportNull$$$0(52);
                }
                return ((PsiClassOwner)psiFile).getPackageName();
            }))) {
                return true;
            }
            List<PsiClass> classes = javaSuite.getCurrentSuiteClasses(project);
            for (PsiClass aClass : classes) {
                PsiFile containingFile = (PsiFile)ReadAction.compute(() -> ((PsiClass)aClass).getContainingFile());
                if (!psiFile.equals(containingFile)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean recompileProjectAndRerunAction(@NotNull Module module, final @NotNull CoverageSuitesBundle suite, @NotNull Runnable chooseSuiteAction) {
        if (module == null) {
            JavaCoverageEngine.$$$reportNull$$$0(13);
        }
        if (suite == null) {
            JavaCoverageEngine.$$$reportNull$$$0(14);
        }
        if (chooseSuiteAction == null) {
            JavaCoverageEngine.$$$reportNull$$$0(15);
        }
        VirtualFile outputpath = CompilerModuleExtension.getInstance((Module)module).getCompilerOutputPath();
        VirtualFile testOutputpath = CompilerModuleExtension.getInstance((Module)module).getCompilerOutputPathForTests();
        if (outputpath == null && JavaCoverageEngine.isModuleOutputNeeded(module, JavaSourceRootType.SOURCE) || suite.isTrackTestFolders() && testOutputpath == null && JavaCoverageEngine.isModuleOutputNeeded(module, JavaSourceRootType.TEST_SOURCE)) {
            final Project project = module.getProject();
            if (suite.isModuleChecked(module)) {
                return false;
            }
            suite.checkModule(module);
            Runnable runnable = () -> {
                if (suite == null) {
                    JavaCoverageEngine.$$$reportNull$$$0(51);
                }
                if (Messages.showOkCancelDialog((String)"Project class files are out of date. Would you like to recompile? The refusal to do it will result in incomplete coverage information", (String)"Project is out of date", (Icon)Messages.getWarningIcon()) == 0) {
                    CompilerManager compilerManager = CompilerManager.getInstance((Project)project);
                    compilerManager.make(compilerManager.createProjectCompileScope(project), new CompileStatusNotification(){

                        public void finished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
                            if (aborted || errors != 0) {
                                return;
                            }
                            ApplicationManager.getApplication().invokeLater(() -> {
                                if (suite == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                if (project.isDisposed()) {
                                    return;
                                }
                                CoverageDataManager.getInstance(project).chooseSuitesBundle(suite);
                            });
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suite", "com/intellij/coverage/JavaCoverageEngine$1", "lambda$finished$0"));
                        }
                    });
                } else if (!project.isDisposed()) {
                    CoverageDataManager.getInstance(project).chooseSuitesBundle(null);
                }
            };
            ApplicationManager.getApplication().invokeLater(runnable);
            return true;
        }
        return false;
    }

    private static boolean isModuleOutputNeeded(Module module, JavaSourceRootType rootType) {
        CompilerManager compilerManager = CompilerManager.getInstance((Project)module.getProject());
        return ModuleRootManager.getInstance((Module)module).getSourceRoots((JpsModuleSourceRootType)rootType).stream().anyMatch(vFile -> !compilerManager.isExcludedFromCompilation(vFile));
    }

    @Override
    @Nullable
    public List<Integer> collectSrcLinesForUntouchedFile(@NotNull File classFile, @NotNull CoverageSuitesBundle suite) {
        byte[] content;
        if (classFile == null) {
            JavaCoverageEngine.$$$reportNull$$$0(16);
        }
        if (suite == null) {
            JavaCoverageEngine.$$$reportNull$$$0(17);
        }
        ArrayList<Integer> uncoveredLines = new ArrayList<Integer>();
        try {
            content = FileUtil.loadFileBytes((File)classFile);
        }
        catch (IOException e) {
            return null;
        }
        try {
            SourceLineCounterUtil.collectSrcLinesForUntouchedFiles(uncoveredLines, content, suite.isTracingEnabled(), suite.getProject());
        }
        catch (Exception e) {
            LOG.error("Fail to process class from: " + classFile.getPath(), (Throwable)e);
        }
        return uncoveredLines;
    }

    @Override
    public boolean includeUntouchedFileInCoverage(@NotNull String qualifiedName, @NotNull File outputFile, @NotNull PsiFile sourceFile, @NotNull CoverageSuitesBundle suite) {
        if (qualifiedName == null) {
            JavaCoverageEngine.$$$reportNull$$$0(18);
        }
        if (outputFile == null) {
            JavaCoverageEngine.$$$reportNull$$$0(19);
        }
        if (sourceFile == null) {
            JavaCoverageEngine.$$$reportNull$$$0(20);
        }
        if (suite == null) {
            JavaCoverageEngine.$$$reportNull$$$0(21);
        }
        for (CoverageSuite coverageSuite : suite.getSuites()) {
            JavaCoverageSuite javaSuite = (JavaCoverageSuite)coverageSuite;
            if (!javaSuite.isClassFiltered(qualifiedName) && !javaSuite.isPackageFiltered(JavaCoverageEngine.getPackageName(sourceFile))) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public String getQualifiedName(@NotNull File outputFile, @NotNull PsiFile sourceFile) {
        if (outputFile == null) {
            JavaCoverageEngine.$$$reportNull$$$0(22);
        }
        if (sourceFile == null) {
            JavaCoverageEngine.$$$reportNull$$$0(23);
        }
        String packageFQName = JavaCoverageEngine.getPackageName(sourceFile);
        String string = StringUtil.getQualifiedName((String)packageFQName, (String)FileUtil.getNameWithoutExtension((File)outputFile));
        if (string == null) {
            JavaCoverageEngine.$$$reportNull$$$0(24);
        }
        return string;
    }

    @Override
    @NotNull
    public Set<String> getQualifiedNames(@NotNull PsiFile sourceFile) {
        if (sourceFile == null) {
            JavaCoverageEngine.$$$reportNull$$$0(25);
        }
        PsiClass[] classes = (PsiClass[])ReadAction.compute(() -> {
            if (sourceFile == null) {
                JavaCoverageEngine.$$$reportNull$$$0(50);
            }
            return ((PsiClassOwner)sourceFile).getClasses();
        });
        HashSet qNames = new HashSet();
        for (JavaCoverageEngineExtension javaCoverageEngineExtension : (JavaCoverageEngineExtension[])Extensions.getExtensions(JavaCoverageEngineExtension.EP_NAME)) {
            if (!((Boolean)ReadAction.compute(() -> JavaCoverageEngine.lambda$getQualifiedNames$5(javaCoverageEngineExtension, sourceFile, classes, (Set)qNames))).booleanValue()) continue;
            HashSet hashSet = qNames;
            if (hashSet == null) {
                JavaCoverageEngine.$$$reportNull$$$0(26);
            }
            return hashSet;
        }
        for (JavaCoverageEngineExtension javaCoverageEngineExtension : classes) {
            String qName = (String)ReadAction.compute(() -> JavaCoverageEngine.lambda$getQualifiedNames$6((PsiClass)javaCoverageEngineExtension));
            if (qName == null) continue;
            qNames.add(qName);
        }
        HashSet hashSet = qNames;
        if (hashSet == null) {
            JavaCoverageEngine.$$$reportNull$$$0(27);
        }
        return hashSet;
    }

    @Override
    @NotNull
    public Set<File> getCorrespondingOutputFiles(@NotNull PsiFile srcFile, @Nullable Module module, @NotNull CoverageSuitesBundle suite) {
        PsiClass[] classes;
        File vDir;
        if (srcFile == null) {
            JavaCoverageEngine.$$$reportNull$$$0(28);
        }
        if (suite == null) {
            JavaCoverageEngine.$$$reportNull$$$0(29);
        }
        if (module == null) {
            Set<File> set = Collections.emptySet();
            if (set == null) {
                JavaCoverageEngine.$$$reportNull$$$0(30);
            }
            return set;
        }
        HashSet classFiles = new HashSet();
        VirtualFile outputpath = CompilerModuleExtension.getInstance((Module)module).getCompilerOutputPath();
        VirtualFile testOutputpath = CompilerModuleExtension.getInstance((Module)module).getCompilerOutputPathForTests();
        for (JavaCoverageEngineExtension extension : (JavaCoverageEngineExtension[])Extensions.getExtensions(JavaCoverageEngineExtension.EP_NAME)) {
            if (!extension.collectOutputFiles(srcFile, outputpath, testOutputpath, suite, (Set<File>)classFiles)) continue;
            HashSet hashSet = classFiles;
            if (hashSet == null) {
                JavaCoverageEngine.$$$reportNull$$$0(31);
            }
            return hashSet;
        }
        String packageFQName = JavaCoverageEngine.getPackageName(srcFile);
        String packageVmName = packageFQName.replace('.', '/');
        ArrayList children = new ArrayList();
        File file = outputpath == null ? null : (vDir = packageVmName.length() > 0 ? new File(outputpath.getPath() + File.separator + packageVmName) : VfsUtilCore.virtualToIoFile((VirtualFile)outputpath));
        if (vDir != null && vDir.exists()) {
            Collections.addAll(children, vDir.listFiles());
        }
        if (suite.isTrackTestFolders()) {
            File testDir;
            File file2 = testOutputpath == null ? null : (testDir = packageVmName.length() > 0 ? new File(testOutputpath.getPath() + File.separator + packageVmName) : VfsUtilCore.virtualToIoFile((VirtualFile)testOutputpath));
            if (testDir != null && testDir.exists()) {
                Collections.addAll(children, testDir.listFiles());
            }
        }
        for (PsiClass psiClass : classes = (PsiClass[])ReadAction.compute(() -> {
            if (srcFile == null) {
                JavaCoverageEngine.$$$reportNull$$$0(48);
            }
            return ((PsiClassOwner)srcFile).getClasses();
        })) {
            String className = (String)ReadAction.compute(() -> psiClass.getName());
            for (File child : children) {
                String childName;
                if (!FileUtilRt.extensionEquals((String)child.getName(), (String)StdFileTypes.CLASS.getDefaultExtension()) || !(childName = FileUtil.getNameWithoutExtension((File)child)).equals(className) && (!childName.startsWith(className) || childName.charAt(className.length()) != '$')) continue;
                classFiles.add(child);
            }
        }
        HashSet hashSet = classFiles;
        if (hashSet == null) {
            JavaCoverageEngine.$$$reportNull$$$0(32);
        }
        return hashSet;
    }

    @Override
    public String generateBriefReport(@NotNull Editor editor, @NotNull PsiFile psiFile, int lineNumber, int startOffset, int endOffset, @Nullable LineData lineData) {
        if (editor == null) {
            JavaCoverageEngine.$$$reportNull$$$0(33);
        }
        if (psiFile == null) {
            JavaCoverageEngine.$$$reportNull$$$0(34);
        }
        StringBuffer buf = new StringBuffer();
        buf.append("Hits: ");
        if (lineData == null) {
            buf.append(0);
            return buf.toString();
        }
        buf.append(lineData.getHits()).append("\n");
        for (JavaCoverageEngineExtension extension : (JavaCoverageEngineExtension[])Extensions.getExtensions(JavaCoverageEngineExtension.EP_NAME)) {
            String report = extension.generateBriefReport(editor, psiFile, lineNumber, startOffset, endOffset, lineData);
            if (report == null) continue;
            buf.append(report);
            return report;
        }
        ArrayList<PsiExpression> expressions = new ArrayList<PsiExpression>();
        Project project = editor.getProject();
        for (int offset = startOffset; offset < endOffset; ++offset) {
            PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)psiFile.findElementAt(offset), PsiStatement.class);
            PsiExpression condition = null;
            if (parent instanceof PsiIfStatement) {
                condition = ((PsiIfStatement)parent).getCondition();
            } else if (parent instanceof PsiSwitchStatement) {
                condition = ((PsiSwitchStatement)parent).getExpression();
            } else if (parent instanceof PsiDoWhileStatement) {
                condition = ((PsiDoWhileStatement)parent).getCondition();
            } else if (parent instanceof PsiForStatement) {
                condition = ((PsiForStatement)parent).getCondition();
            } else if (parent instanceof PsiWhileStatement) {
                condition = ((PsiWhileStatement)parent).getCondition();
            } else if (parent instanceof PsiForeachStatement) {
                condition = ((PsiForeachStatement)parent).getIteratedValue();
            } else if (parent instanceof PsiAssertStatement) {
                condition = ((PsiAssertStatement)parent).getAssertCondition();
            }
            if (condition == null || !PsiTreeUtil.isAncestor((PsiElement)condition, (PsiElement)psiFile.findElementAt(offset), (boolean)false)) continue;
            try {
                ControlFlow controlFlow = ControlFlowFactory.getInstance((Project)project).getControlFlow(parent, (ControlFlowPolicy)AllVariablesControlFlowPolicy.getInstance());
                for (Instruction instruction : controlFlow.getInstructions()) {
                    PsiExpression psiExpression;
                    if (!(instruction instanceof ConditionalBranchingInstruction) || expressions.contains(psiExpression = ((ConditionalBranchingInstruction)instruction).expression)) continue;
                    expressions.add(psiExpression);
                }
                continue;
            }
            catch (AnalysisCanceledException e) {
                return buf.toString();
            }
        }
        String indent = "    ";
        try {
            int idx = 0;
            int hits = 0;
            if (lineData.getJumps() != null) {
                for (JumpData jumpData : lineData.getJumps()) {
                    PsiExpression expression;
                    PsiElement parentExpression;
                    JumpData jumpData2 = jumpData;
                    if (jumpData2.getTrueHits() + jumpData2.getFalseHits() <= 0) continue;
                    boolean reverse = (parentExpression = (expression = (PsiExpression)expressions.get(idx++)).getParent()) instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)parentExpression).getOperationTokenType() == JavaTokenType.OROR || parentExpression instanceof PsiDoWhileStatement || parentExpression instanceof PsiAssertStatement;
                    buf.append("    ").append(expression.getText()).append("\n");
                    buf.append("    ").append("    ").append("true hits: ").append(reverse ? jumpData2.getFalseHits() : jumpData2.getTrueHits()).append("\n");
                    buf.append("    ").append("    ").append("false hits: ").append(reverse ? jumpData2.getTrueHits() : jumpData2.getFalseHits()).append("\n");
                    hits += jumpData2.getTrueHits() + jumpData2.getFalseHits();
                }
            }
            if (lineData.getSwitches() != null) {
                for (JumpData jumpData : lineData.getSwitches()) {
                    SwitchData switchData = (SwitchData)jumpData;
                    PsiExpression conditionExpression = (PsiExpression)expressions.get(idx++);
                    buf.append("    ").append(conditionExpression.getText()).append("\n");
                    int i = 0;
                    for (int key : switchData.getKeys()) {
                        int switchHits = switchData.getHits()[i++];
                        buf.append("    ").append("    ").append("case ").append(key).append(": ").append(switchHits).append("\n");
                        hits += switchHits;
                    }
                    int defaultHits = switchData.getDefaultHits();
                    boolean hasDefaultLabel = JavaCoverageEngine.hasDefaultLabel((PsiElement)conditionExpression);
                    if (!hasDefaultLabel && defaultHits <= 0) continue;
                    if (!hasDefaultLabel) {
                        defaultHits -= hits;
                    }
                    if (!hasDefaultLabel && defaultHits <= 0) continue;
                    buf.append("    ").append("    ").append("default: ").append(defaultHits).append("\n");
                    hits += defaultHits;
                }
            }
            if (lineData.getHits() > hits && hits > 0) {
                buf.append("Unknown outcome: ").append(lineData.getHits() - hits);
            }
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            return "Hits: " + lineData.getHits();
        }
        return buf.toString();
    }

    @Override
    @Nullable
    public String getTestMethodName(@NotNull PsiElement element, @NotNull AbstractTestProxy testProxy) {
        String qualifiedName;
        PsiMethod method;
        PsiClass aClass;
        if (element == null) {
            JavaCoverageEngine.$$$reportNull$$$0(35);
        }
        if (testProxy == null) {
            JavaCoverageEngine.$$$reportNull$$$0(36);
        }
        if (element instanceof PsiMethod && (aClass = (method = (PsiMethod)element).getContainingClass()) != null && (qualifiedName = aClass.getQualifiedName()) != null) {
            return qualifiedName + "." + method.getName();
        }
        return testProxy.toString();
    }

    @Override
    @NotNull
    public List<PsiElement> findTestsByNames(@NotNull String[] testNames, @NotNull Project project) {
        if (testNames == null) {
            JavaCoverageEngine.$$$reportNull$$$0(37);
        }
        if (project == null) {
            JavaCoverageEngine.$$$reportNull$$$0(38);
        }
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)project);
        block0: for (String testName : testNames) {
            PsiClass psiClass = facade.findClass(StringUtil.getPackageName((String)testName, (char)'_').replaceAll("\\_", "\\."), projectScope);
            int lastIdx = testName.lastIndexOf("_");
            if (psiClass != null) {
                JavaCoverageEngine.collectTestsByName(elements, testName, psiClass, lastIdx);
                continue;
            }
            String className = testName;
            while (lastIdx > 0) {
                className = className.substring(0, lastIdx);
                psiClass = facade.findClass(StringUtil.getPackageName((String)className, (char)'_').replaceAll("\\_", "\\."), projectScope);
                lastIdx = className.lastIndexOf("_");
                if (psiClass == null) continue;
                JavaCoverageEngine.collectTestsByName(elements, testName, psiClass, lastIdx);
                continue block0;
            }
        }
        ArrayList<PsiElement> arrayList = elements;
        if (arrayList == null) {
            JavaCoverageEngine.$$$reportNull$$$0(39);
        }
        return arrayList;
    }

    private static void collectTestsByName(List<PsiElement> elements, String testName, PsiClass psiClass, int lastIdx) {
        PsiMethod[] testsByName = psiClass.findMethodsByName(testName.substring(lastIdx + 1), true);
        if (testsByName.length == 1) {
            elements.add((PsiElement)testsByName[0]);
        }
    }

    private static boolean hasDefaultLabel(PsiElement conditionExpression) {
        PsiElement bodyElement;
        boolean hasDefault = false;
        PsiSwitchStatement switchStatement = (PsiSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)conditionExpression, PsiSwitchStatement.class);
        PsiCodeBlock body = ((PsiSwitchStatementImpl)conditionExpression.getParent()).getBody();
        if (body != null && (bodyElement = body.getFirstBodyElement()) != null) {
            PsiSwitchLabelStatement label = (PsiSwitchLabelStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)bodyElement, PsiSwitchLabelStatement.class);
            while (label != null) {
                if (label.getEnclosingSwitchStatement() == switchStatement) {
                    hasDefault |= label.isDefaultCase();
                }
                label = (PsiSwitchLabelStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)label, PsiSwitchLabelStatement.class);
            }
        }
        return hasDefault;
    }

    protected JavaCoverageSuite createSuite(CoverageRunner acceptedCovRunner, String name, CoverageFileProvider coverageDataFileProvider, String[] filters, String[] excludePatterns, long lastCoverageTimeStamp, boolean coverageByTestEnabled, boolean tracingEnabled, boolean trackTestFolders, Project project) {
        return new JavaCoverageSuite(name, coverageDataFileProvider, filters, excludePatterns, lastCoverageTimeStamp, coverageByTestEnabled, tracingEnabled, trackTestFolders, acceptedCovRunner, this, project);
    }

    @NotNull
    protected static String getPackageName(PsiFile sourceFile) {
        String string = (String)ReadAction.compute(() -> ((PsiClassOwner)sourceFile).getPackageName());
        if (string == null) {
            JavaCoverageEngine.$$$reportNull$$$0(40);
        }
        return string;
    }

    protected static void generateJavaReport(final @NotNull Project project, final File tempFile, final CoverageSuitesBundle currentSuite) {
        if (project == null) {
            JavaCoverageEngine.$$$reportNull$$$0(41);
        }
        final ExportToHTMLSettings settings = ExportToHTMLSettings.getInstance((Project)project);
        final ProjectData projectData = currentSuite.getCoverageData();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Generating coverage report ..."){
            final Exception[] myExceptions;
            {
                super(arg0, arg1);
                this.myExceptions = new Exception[1];
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                try {
                    new SaveHook(tempFile, true, (ClassFinder)new IdeaClassFinder(project, currentSuite)).save(projectData);
                    HTMLReportBuilder builder = ReportBuilderFactory.createHTMLReportBuilder();
                    builder.setReportDir(new File(settings.OUTPUT_DIRECTORY));
                    SourceCodeProvider sourceCodeProvider = new SourceCodeProvider(){

                        public String getSourceCode(@NotNull String classname) throws IOException {
                            if (classname == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return (String)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> {
                                if (project == null) {
                                    1.$$$reportNull$$$0(1);
                                }
                                if (classname == null) {
                                    1.$$$reportNull$$$0(2);
                                }
                                if (project.isDisposed()) {
                                    return "";
                                }
                                PsiClass psiClass = ClassUtil.findPsiClassByJVMName((PsiManager)PsiManager.getInstance((Project)project), (String)classname);
                                return psiClass != null ? psiClass.getNavigationElement().getContainingFile().getText() : "";
                            });
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            Object[] objectArray3 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "classname";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "project";
                                    break;
                                }
                            }
                            objectArray2[1] = "com/intellij/coverage/JavaCoverageEngine$2$1";
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "getSourceCode";
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "lambda$getSourceCode$0";
                                    break;
                                }
                            }
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    };
                    builder.generateReport((CoverageData)new IDEACoverageData(projectData, sourceCodeProvider){

                        @NotNull
                        public Collection<ClassInfo> getClasses() {
                            Collection classes = super.getClasses();
                            if (!currentSuite.isTrackTestFolders()) {
                                JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
                                GlobalSearchScope productionScope = GlobalSearchScopesCore.projectProductionScope((Project)project);
                                Iterator iterator = classes.iterator();
                                while (iterator.hasNext()) {
                                    ClassInfo aClass = (ClassInfo)iterator.next();
                                    PsiClass psiClass = (PsiClass)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> {
                                        if (project == null) {
                                            2.$$$reportNull$$$0(1);
                                        }
                                        if (project.isDisposed()) {
                                            return null;
                                        }
                                        return psiFacade.findClass(aClass.getFQName(), productionScope);
                                    });
                                    if (psiClass != null) continue;
                                    iterator.remove();
                                }
                            }
                            Collection collection = classes;
                            if (collection == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            return collection;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            RuntimeException runtimeException;
                            Object[] objectArray;
                            Object[] objectArray2;
                            int n2;
                            String string;
                            switch (n) {
                                default: {
                                    string = "@NotNull method %s.%s must not return null";
                                    break;
                                }
                                case 1: {
                                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    n2 = 2;
                                    break;
                                }
                                case 1: {
                                    n2 = 3;
                                    break;
                                }
                            }
                            Object[] objectArray3 = new Object[n2];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "com/intellij/coverage/JavaCoverageEngine$2$2";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "project";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "getClasses";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "com/intellij/coverage/JavaCoverageEngine$2$2";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray;
                                    objectArray[2] = "lambda$getClasses$0";
                                    break;
                                }
                            }
                            String string2 = String.format(string, objectArray);
                            switch (n) {
                                default: {
                                    runtimeException = new IllegalStateException(string2);
                                    break;
                                }
                                case 1: {
                                    runtimeException = new IllegalArgumentException(string2);
                                    break;
                                }
                            }
                            throw runtimeException;
                        }
                    });
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
                catch (ReportGenerationFailedException e) {
                    this.myExceptions[0] = e;
                }
            }

            public void onSuccess() {
                if (this.myExceptions[0] != null) {
                    Messages.showErrorDialog((Project)project, (String)this.myExceptions[0].getMessage(), (String)CommonBundle.getErrorTitle());
                    return;
                }
                if (settings.OPEN_IN_BROWSER) {
                    BrowserUtil.browse((File)new File(settings.OUTPUT_DIRECTORY, "index.html"));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/coverage/JavaCoverageEngine$2", "run"));
            }
        });
    }

    @Override
    public boolean isReportGenerationAvailable(@NotNull Project project, @NotNull DataContext dataContext, @NotNull CoverageSuitesBundle currentSuite) {
        Sdk projectSdk;
        if (project == null) {
            JavaCoverageEngine.$$$reportNull$$$0(42);
        }
        if (dataContext == null) {
            JavaCoverageEngine.$$$reportNull$$$0(43);
        }
        if (currentSuite == null) {
            JavaCoverageEngine.$$$reportNull$$$0(44);
        }
        return (projectSdk = ProjectRootManager.getInstance((Project)project).getProjectSdk()) != null;
    }

    @Override
    public final void generateReport(@NotNull Project project, @NotNull DataContext dataContext, @NotNull CoverageSuitesBundle currentSuite) {
        if (project == null) {
            JavaCoverageEngine.$$$reportNull$$$0(45);
        }
        if (dataContext == null) {
            JavaCoverageEngine.$$$reportNull$$$0(46);
        }
        if (currentSuite == null) {
            JavaCoverageEngine.$$$reportNull$$$0(47);
        }
        try {
            File tempFile = FileUtil.createTempFile((String)"temp", (String)"");
            tempFile.deleteOnExit();
            JavaCoverageEngine.generateJavaReport(project, tempFile, currentSuite);
        }
        catch (IOException e1) {
            LOG.error((Throwable)e1);
        }
    }

    @Override
    public String getPresentableText() {
        return "Java Coverage";
    }

    @Override
    public boolean isGeneratedCode(Project project, String qualifiedName, Object lineData) {
        if (JavaCoverageOptionsProvider.getInstance(project).isGeneratedConstructor(qualifiedName, ((LineData)lineData).getMethodSignature())) {
            return true;
        }
        return super.isGeneratedCode(project, qualifiedName, lineData);
    }

    @Override
    public CoverageViewExtension createCoverageViewExtension(Project project, CoverageSuitesBundle suiteBundle, CoverageViewManager.StateBean stateBean) {
        return new JavaCoverageViewExtension((JavaCoverageAnnotator)this.getCoverageAnnotator(project), project, suiteBundle, stateBean);
    }

    public boolean isSourceMapNeeded(RunConfigurationBase configuration) {
        for (JavaCoverageEngineExtension extension : (JavaCoverageEngineExtension[])Extensions.getExtensions(JavaCoverageEngineExtension.EP_NAME)) {
            if (!extension.isSourceMapNeeded(configuration)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ String lambda$getQualifiedNames$6(PsiClass aClass) throws RuntimeException {
        return aClass.getQualifiedName();
    }

    private static /* synthetic */ Boolean lambda$getQualifiedNames$5(JavaCoverageEngineExtension nameExtension, @NotNull PsiFile sourceFile, PsiClass[] classes, Set qNames) throws RuntimeException {
        if (sourceFile == null) {
            JavaCoverageEngine.$$$reportNull$$$0(49);
        }
        return nameExtension.suggestQualifiedName(sourceFile, classes, qNames);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/JavaCoverageEngine";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "covRunner";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageDataFileProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageRunner";
                break;
            }
            case 10: 
            case 11: 
            case 34: 
            case 52: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 12: 
            case 14: 
            case 17: 
            case 21: 
            case 29: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suite";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chooseSuiteAction";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFile";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFile";
                break;
            }
            case 20: 
            case 23: 
            case 25: 
            case 49: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 28: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcFile";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testProxy";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testNames";
                break;
            }
            case 38: 
            case 41: 
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 44: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentSuite";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createCoverageEnabledConfiguration";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/JavaCoverageEngine";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoverageAnnotator";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedNames";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getCorrespondingOutputFiles";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "findTestsByNames";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createCoverageSuite";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyCoverageSuite";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "coverageEditorHighlightingApplicableTo";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "acceptedByFilters";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "recompileProjectAndRerunAction";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "collectSrcLinesForUntouchedFile";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "includeUntouchedFileInCoverage";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedNames";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getCorrespondingOutputFiles";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "generateBriefReport";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getTestMethodName";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "findTestsByNames";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "generateJavaReport";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isReportGenerationAvailable";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "generateReport";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getCorrespondingOutputFiles$7";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getQualifiedNames$5";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getQualifiedNames$4";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "lambda$recompileProjectAndRerunAction$2";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "lambda$acceptedByFilters$1";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "lambda$coverageEditorHighlightingApplicableTo$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

