/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.j2ee.web.resin.resin.configuration;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.NullableLazyValue;
import java.io.File;
import java.io.IOException;
import org.intellij.j2ee.web.resin.resin.configuration.ResinGeneratedConfig;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;

public class ResinConfigImport {
    private static final Logger LOG = Logger.getInstance(ResinConfigImport.class);
    private final Element myRoot;
    private NullableLazyValue<Document> myImportDoc = new NullableLazyValue<Document>(){

        protected Document compute() {
            String path = ResinConfigImport.this.myRoot.getAttributeValue("path");
            try {
                return JDOMUtil.loadDocument((File)new File(path));
            }
            catch (JDOMException e) {
                LOG.debug((Throwable)e);
                return null;
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
                return null;
            }
        }
    };
    private ResinGeneratedConfig myCopy;
    private ExecutionException myCopyException;

    public ResinConfigImport(Element root) {
        this.myRoot = root;
    }

    public Document getImportDoc() {
        return (Document)this.myImportDoc.getValue();
    }

    public void copy() {
        if (this.myCopy == null && this.myCopyException == null) {
            try {
                this.myCopy = new ResinGeneratedConfig(this.getImportDoc(), "resin-import");
                this.myRoot.setAttribute("path", this.myCopy.getFile().getAbsolutePath());
            }
            catch (ExecutionException e) {
                this.myCopyException = e;
            }
        }
    }

    public void save() throws ExecutionException {
        if (this.myCopyException != null) {
            throw this.myCopyException;
        }
        if (this.myCopy != null) {
            this.myCopy.save();
        }
    }
}

