/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.params;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocCommentOwner;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrParametersOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForInClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrTraditionalForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.GrVariableBaseImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrParameterStub;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.ClosureParameterEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrVariableEnhancer;

public class GrParameterImpl
extends GrVariableBaseImpl<GrParameterStub>
implements GrParameter {
    public GrParameterImpl(@NotNull ASTNode node) {
        if (node == null) {
            GrParameterImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public GrParameterImpl(GrParameterStub stub) {
        super(stub, GroovyElementTypes.PARAMETER);
    }

    @Override
    public void accept(GroovyElementVisitor visitor2) {
        visitor2.visitParameter(this);
    }

    public String toString() {
        return "Parameter";
    }

    @Override
    @Nullable
    public PsiType getTypeGroovy() {
        PsiType declaredType = this.getDeclaredType();
        if (declaredType != null) {
            return declaredType;
        }
        if (this.isVarArgs()) {
            PsiClassType type = TypesUtil.getJavaLangObject(this);
            return new PsiEllipsisType((PsiType)type);
        }
        PsiElement parent = this.getParent();
        if (parent instanceof GrForInClause) {
            GrExpression iteratedExpression = ((GrForInClause)parent).getIteratedExpression();
            if (iteratedExpression == null) {
                return null;
            }
            PsiType result = ClosureParameterEnhancer.findTypeForIteration(iteratedExpression, (PsiElement)this);
            if (result != null) {
                return result;
            }
        } else {
            if (parent instanceof GrTraditionalForClause) {
                return super.getTypeGroovy();
            }
            if (parent instanceof GrCatchClause) {
                return TypesUtil.createTypeByFQClassName("java.lang.Exception", this);
            }
        }
        return GrVariableEnhancer.getEnhancedType(this);
    }

    @Override
    public PsiType getDeclaredType() {
        PsiType type = super.getDeclaredType();
        if (this.isVarArgs()) {
            if (type == null) {
                type = TypesUtil.getJavaLangObject(this);
            }
            return new PsiEllipsisType(type);
        }
        return type;
    }

    @Override
    @NotNull
    public PsiType getType() {
        PsiType type = super.getType();
        if (this.isMainMethodFirstUntypedParameter()) {
            PsiArrayType psiArrayType = TypesUtil.createTypeByFQClassName("java.lang.String", this).createArrayType();
            if (psiArrayType == null) {
                GrParameterImpl.$$$reportNull$$$0(1);
            }
            return psiArrayType;
        }
        PsiType psiType = type;
        if (psiType == null) {
            GrParameterImpl.$$$reportNull$$$0(2);
        }
        return psiType;
    }

    private boolean isMainMethodFirstUntypedParameter() {
        if (this.getTypeElementGroovy() != null) {
            return false;
        }
        if (!(this.getParent() instanceof GrParameterList)) {
            return false;
        }
        if (this.isOptional()) {
            return false;
        }
        GrParameterList parameterList = (GrParameterList)this.getParent();
        if (!(parameterList.getParent() instanceof GrMethod)) {
            return false;
        }
        GrMethod method = (GrMethod)parameterList.getParent();
        return PsiImplUtil.isMainMethod(method);
    }

    @Override
    public void setType(@Nullable PsiType type) {
        GrTypeElement newTypeElement;
        GrTypeElement typeElement = this.getTypeElementGroovy();
        if (type == null) {
            if (typeElement != null) {
                typeElement.delete();
            }
            return;
        }
        try {
            newTypeElement = GroovyPsiElementFactory.getInstance(this.getProject()).createTypeElement(type);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return;
        }
        if (typeElement == null) {
            GrModifierList modifierList = this.getModifierList();
            newTypeElement = (GrTypeElement)this.addAfter(newTypeElement, modifierList);
        } else {
            newTypeElement = (GrTypeElement)typeElement.replace(newTypeElement);
        }
        JavaCodeStyleManager.getInstance((Project)this.getProject()).shortenClassReferences((PsiElement)newTypeElement);
    }

    @Override
    public boolean isOptional() {
        GrParameterStub stub = (GrParameterStub)this.getStub();
        if (stub != null) {
            return GrParameterStub.hasInitializer(stub.getFlags());
        }
        return this.getInitializerGroovy() != null;
    }

    @Override
    @Nullable
    public PsiElement getEllipsisDots() {
        return this.findChildByType(GroovyTokenTypes.mTRIPLE_DOT);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        GrDocCommentOwner owner;
        GrDocComment comment;
        if (!this.isPhysical()) {
            PsiFile file = this.getContainingFile();
            PsiElement context = file.getContext();
            if (context != null) {
                LocalSearchScope localSearchScope = new LocalSearchScope(context);
                if (localSearchScope == null) {
                    GrParameterImpl.$$$reportNull$$$0(3);
                }
                return localSearchScope;
            }
            SearchScope searchScope = super.getUseScope();
            if (searchScope == null) {
                GrParameterImpl.$$$reportNull$$$0(4);
            }
            return searchScope;
        }
        PsiElement scope = this.getDeclarationScope();
        if (scope instanceof GrDocCommentOwner && (comment = (owner = (GrDocCommentOwner)scope).getDocComment()) != null) {
            LocalSearchScope localSearchScope = new LocalSearchScope(new PsiElement[]{scope, comment});
            if (localSearchScope == null) {
                GrParameterImpl.$$$reportNull$$$0(5);
            }
            return localSearchScope;
        }
        LocalSearchScope localSearchScope = new LocalSearchScope(scope);
        if (localSearchScope == null) {
            GrParameterImpl.$$$reportNull$$$0(6);
        }
        return localSearchScope;
    }

    @Override
    @NotNull
    public GrModifierList getModifierList() {
        GrModifierList grModifierList = (GrModifierList)this.getRequiredStubOrPsiChild(GroovyElementTypes.MODIFIERS);
        if (grModifierList == null) {
            GrParameterImpl.$$$reportNull$$$0(7);
        }
        return grModifierList;
    }

    @NotNull
    public PsiElement getDeclarationScope() {
        GrParametersOwner owner = (GrParametersOwner)PsiTreeUtil.getParentOfType((PsiElement)this, GrParametersOwner.class);
        assert (owner != null);
        if (owner instanceof GrForClause) {
            PsiElement psiElement = owner.getParent();
            if (psiElement == null) {
                GrParameterImpl.$$$reportNull$$$0(8);
            }
            return psiElement;
        }
        GrParametersOwner grParametersOwner = owner;
        if (grParametersOwner == null) {
            GrParameterImpl.$$$reportNull$$$0(9);
        }
        return grParametersOwner;
    }

    public boolean isVarArgs() {
        GrParameterStub stub = (GrParameterStub)this.getStub();
        if (stub != null) {
            return GrParameterStub.isVarRags(stub.getFlags());
        }
        PsiElement dots = this.getEllipsisDots();
        return dots != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/params/GrParameterImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/params/GrParameterImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifierList";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

