/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.convertToStatic;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.refactoring.convertToStatic.ConvertToStaticProcessor;

public class ConvertToStaticHandler
implements RefactoringActionHandler {
    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            ConvertToStaticHandler.$$$reportNull$$$0(0);
        }
        ConvertToStaticHandler.invokeInner(project, new PsiElement[]{file});
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            ConvertToStaticHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            ConvertToStaticHandler.$$$reportNull$$$0(2);
        }
        ConvertToStaticHandler.invokeInner(project, elements);
    }

    private static void invokeInner(Project project, PsiElement[] elements) {
        Set<GroovyFile> files = ConvertToStaticHandler.collectFilesForProcessing(elements);
        new ConvertToStaticProcessor(project, files.toArray(new GroovyFile[files.size()])).run();
    }

    public static Set<GroovyFile> collectFilesForProcessing(@NotNull PsiElement[] elements) {
        if (elements == null) {
            ConvertToStaticHandler.$$$reportNull$$$0(3);
        }
        HashSet files = ContainerUtil.newHashSet();
        for (PsiElement element : elements) {
            PsiDirectory directory;
            Module module;
            PsiFile containingFile = element.getContainingFile();
            if (containingFile instanceof GroovyFile) {
                files.add((GroovyFile)containingFile);
            }
            if (!(element instanceof PsiDirectory) || (module = ModuleUtilCore.findModuleForFile((VirtualFile)(directory = (PsiDirectory)element).getVirtualFile(), (Project)element.getProject())) == null) continue;
            ModuleFileIndex index = ModuleRootManager.getInstance((Module)module).getFileIndex();
            index.iterateContentUnderDirectory(directory.getVirtualFile(), file -> {
                PsiFile psiFile;
                if (!file.isDirectory() && index.isInSourceContent(file) && GroovyFileType.GROOVY_FILE_TYPE == file.getFileType() && (psiFile = element.getManager().findFile(file)) instanceof GroovyFile) {
                    files.add((GroovyFile)psiFile);
                }
                return true;
            });
        }
        return files;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/convertToStatic/ConvertToStaticHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "collectFilesForProcessing";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

