/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.values;

import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.SpringValueHolderDefinition;
import com.intellij.util.xml.GenericDomValue;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PlaceholderUtils {
    @NonNls
    public static final String PLACEHOLDER_CONFIGURER_CLASS = "org.springframework.beans.factory.config.PlaceholderConfigurerSupport";
    @NonNls
    public static final String DEFAULT_PLACEHOLDER_PREFIX = "${";
    @NonNls
    public static final String DEFAULT_PLACEHOLDER_SUFFIX = "}";
    @NonNls
    public static final String PLACEHOLDER_PREFIX_PROPERTY_NAME = "placeholderPrefix";
    @NonNls
    public static final String PLACEHOLDER_SUFFIX_PROPERTY_NAME = "placeholderSuffix";

    public static PlaceholderUtils getInstance() {
        return (PlaceholderUtils)ServiceManager.getService(PlaceholderUtils.class);
    }

    public abstract Set<PropertiesFile> getResources(Collection<? extends SpringBeanPointer> var1);

    @NotNull
    public abstract Set<PropertiesFile> getPropertiesFile(Pair<String, PsiElement> var1);

    public abstract List<Pair<String, PsiElement>> getLocations(CommonSpringBean var1);

    public abstract boolean containsDefaultPlaceholderDefinitions(@NotNull GenericDomValue var1);

    public abstract boolean isRawTextPlaceholder(GenericDomValue var1);

    public abstract boolean isPlaceholder(GenericDomValue var1);

    public abstract boolean isPlaceholder(GenericDomValue var1, String var2);

    public abstract boolean isPlaceholder(String var1, List<SpringBeanPointer> var2);

    public abstract boolean isDefaultPlaceholder(@Nullable String var1);

    public abstract Pair<String, String> getPlaceholderPrefixAndSuffix(DomSpringBean var1);

    @NotNull
    public abstract Pair<String, String> getPlaceholderPrefixAndSuffixInner(@Nullable SpringBeanPointer var1);

    @NotNull
    public abstract Pair<String, String> getPlaceholderPrefixAndSuffixInner(DomSpringBean var1);

    @NotNull
    public abstract PsiReference[] createPlaceholderPropertiesReferences(GenericDomValue var1);

    @NotNull
    public abstract PsiReference[] createPlaceholderPropertiesReferences(PsiElement var1);

    @Nullable
    public abstract String resolvePlaceholders(@NotNull GenericDomValue var1);

    @NotNull
    public abstract Collection<String> getValueVariants(@NotNull SpringValueHolderDefinition var1);

    @NotNull
    public abstract Collection<String> getValueVariants(GenericDomValue var1);
}

