/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.radComponents;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.uiDesigner.ModuleProvider;
import com.intellij.uiDesigner.StringDescriptorManager;
import com.intellij.uiDesigner.XmlWriter;
import com.intellij.uiDesigner.compiler.Utils;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.Util;
import com.intellij.uiDesigner.designSurface.EventProcessor;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.designSurface.InsertComponentProcessor;
import com.intellij.uiDesigner.lw.ComponentVisitor;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.IContainer;
import com.intellij.uiDesigner.lw.IProperty;
import com.intellij.uiDesigner.lw.LwComponent;
import com.intellij.uiDesigner.lw.LwIntrospectedProperty;
import com.intellij.uiDesigner.lw.StringDescriptor;
import com.intellij.uiDesigner.palette.ComponentItem;
import com.intellij.uiDesigner.palette.Palette;
import com.intellij.uiDesigner.propertyInspector.IntrospectedProperty;
import com.intellij.uiDesigner.propertyInspector.Property;
import com.intellij.uiDesigner.propertyInspector.properties.ClientPropertiesProperty;
import com.intellij.uiDesigner.propertyInspector.properties.ClientPropertyProperty;
import com.intellij.uiDesigner.propertyInspector.properties.IntroStringProperty;
import com.intellij.uiDesigner.radComponents.LayoutManagerRegistry;
import com.intellij.uiDesigner.radComponents.RadAtomicComponent;
import com.intellij.uiDesigner.radComponents.RadComponentFactory;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.radComponents.RadHSpacer;
import com.intellij.uiDesigner.radComponents.RadLayoutManager;
import com.intellij.uiDesigner.radComponents.RadTabbedPane;
import com.intellij.uiDesigner.radComponents.RadVSpacer;
import com.intellij.uiDesigner.snapShooter.SnapshotContext;
import com.intellij.util.ArrayUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.DefaultButtonModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RadComponent
implements IComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.radComponents.RadComponent");
    public static final RadComponent[] EMPTY_ARRAY = new RadComponent[0];
    @NonNls
    public static final String CLIENT_PROP_RAD_COMPONENT = "radComponent";
    @NonNls
    public static final String CLIENT_PROP_LOAD_TIME_LOCALE = "LoadTimeLocaleKey";
    @NonNls
    public static final String PROP_SELECTED = "selected";
    @NonNls
    public static final String PROP_CONSTRAINTS = "constraints";
    @NotNull
    private final String myId;
    private String myBinding;
    private boolean myCustomCreate;
    private boolean myLoadingProperties;
    private final ModuleProvider myModule;
    @NotNull
    private final Class myClass;
    @NotNull
    private final JComponent myDelegee;
    private RadContainer myParent;
    private boolean mySelected;
    @NotNull
    private final GridConstraints myConstraints;
    private Object myCustomLayoutConstraints;
    private final PropertyChangeSupport myChangeSupport;
    private final HashSet<String> myModifiedPropertyNames;
    private Palette myPalette;
    private boolean myHasDragger;
    private boolean myResizing;
    private boolean myDragging;
    private boolean myDragBorder;
    private boolean myDefaultBinding;

    public RadComponent(ModuleProvider module, @NotNull Class aClass, @NotNull String id) {
        Constructor constructor;
        if (aClass == null) {
            RadComponent.$$$reportNull$$$0(0);
        }
        if (id == null) {
            RadComponent.$$$reportNull$$$0(1);
        }
        this.myCustomCreate = false;
        this.myLoadingProperties = false;
        this.myModule = module;
        this.myClass = aClass;
        this.myId = id;
        this.myChangeSupport = new PropertyChangeSupport(this);
        this.myConstraints = new GridConstraints();
        this.myModifiedPropertyNames = new HashSet();
        try {
            constructor = this.myClass.getConstructor(ArrayUtil.EMPTY_CLASS_ARRAY);
        }
        catch (NoSuchMethodException e) {
            try {
                constructor = Utils.suggestReplacementClass((Class)this.myClass).getConstructor(ArrayUtil.EMPTY_CLASS_ARRAY);
            }
            catch (NoSuchMethodException e1) {
                throw new RuntimeException(e1);
            }
            this.setCustomCreate(true);
        }
        constructor.setAccessible(true);
        try {
            this.myDelegee = (JComponent)constructor.newInstance(ArrayUtil.EMPTY_OBJECT_ARRAY);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.myDelegee.putClientProperty(CLIENT_PROP_RAD_COMPONENT, this);
    }

    public RadComponent(ModuleProvider module, @NotNull Class aClass, @NotNull String id, Palette palette) {
        if (aClass == null) {
            RadComponent.$$$reportNull$$$0(2);
        }
        if (id == null) {
            RadComponent.$$$reportNull$$$0(3);
        }
        this(module, aClass, id);
        this.myPalette = palette;
    }

    public final Module getModule() {
        return this.myModule == null ? null : this.myModule.getModule();
    }

    public final Project getProject() {
        return this.myModule == null ? null : this.myModule.getProject();
    }

    public boolean isLoadingProperties() {
        return this.myLoadingProperties;
    }

    public Palette getPalette() {
        if (this.myPalette == null) {
            return Palette.getInstance(this.getProject());
        }
        return this.myPalette;
    }

    public void setPalette(Palette palette) {
        this.myPalette = palette;
    }

    public void init(GuiEditor editor, @NotNull ComponentItem item) {
        if (item == null) {
            RadComponent.$$$reportNull$$$0(4);
        }
        this.initDefaultProperties(item);
    }

    public void initDefaultProperties(@NotNull ComponentItem item) {
        IntrospectedProperty[] properties;
        if (item == null) {
            RadComponent.$$$reportNull$$$0(5);
        }
        for (IntrospectedProperty property : properties = this.getPalette().getIntrospectedProperties(this)) {
            Object initialValue = item.getInitialValue(property);
            if (initialValue == null) continue;
            try {
                property.setValue(this, initialValue);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.myConstraints.restore(item.getDefaultConstraints());
    }

    @NotNull
    public final String getId() {
        String string = this.myId;
        if (string == null) {
            RadComponent.$$$reportNull$$$0(6);
        }
        return string;
    }

    public final String getBinding() {
        return this.myBinding;
    }

    public final void setBinding(String binding) {
        this.myBinding = binding;
    }

    public boolean isCustomCreate() {
        return this.myCustomCreate;
    }

    public void setCustomCreate(boolean customCreate) {
        this.myCustomCreate = customCreate;
    }

    public boolean isCustomCreateRequired() {
        return !this.getDelegee().getClass().equals(this.getComponentClass());
    }

    @NotNull
    public final JComponent getDelegee() {
        JComponent jComponent = this.myDelegee;
        if (jComponent == null) {
            RadComponent.$$$reportNull$$$0(7);
        }
        return jComponent;
    }

    @Nullable
    public Property getInplaceProperty(int x, int y) {
        return this.getDefaultInplaceProperty();
    }

    @Nullable
    public Property getDefaultInplaceProperty() {
        return this.getPalette().getInplaceProperty(this);
    }

    @Nullable
    public Rectangle getDefaultInplaceEditorBounds() {
        return null;
    }

    @Nullable
    public Rectangle getInplaceEditorBounds(@NotNull Property property, int x, int y) {
        if (property == null) {
            RadComponent.$$$reportNull$$$0(8);
        }
        return null;
    }

    @NotNull
    public final Class getComponentClass() {
        Class clazz = this.myClass;
        if (clazz == null) {
            RadComponent.$$$reportNull$$$0(9);
        }
        return clazz;
    }

    @NotNull
    public String getComponentClassName() {
        String string = this.myClass.getName();
        if (string == null) {
            RadComponent.$$$reportNull$$$0(10);
        }
        return string;
    }

    public final Object getCustomLayoutConstraints() {
        return this.myCustomLayoutConstraints;
    }

    public final void setCustomLayoutConstraints(Object customConstraints) {
        this.myCustomLayoutConstraints = customConstraints;
    }

    public void changeCustomLayoutConstraints(Object constraints) {
        this.setCustomLayoutConstraints(constraints);
        JComponent parent = this.getParent().getDelegee();
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            if (parent.getComponent(i) != this.getDelegee()) continue;
            parent.remove(i);
            parent.add(this.getDelegee(), constraints, i);
            break;
        }
    }

    public final boolean hasDragger() {
        return this.myHasDragger;
    }

    public final void setDragger(boolean hasDragger) {
        this.myHasDragger = hasDragger;
    }

    public boolean isResizing() {
        return this.myResizing;
    }

    public void setResizing(boolean resizing) {
        this.myResizing = resizing;
    }

    public boolean isDragging() {
        return this.myDragging;
    }

    public void setDragging(boolean dragging) {
        this.myDragging = dragging;
        RadContainer parent = this.getParent();
        if (parent != null) {
            parent.getLayoutManager().setChildDragging(this, dragging);
        }
    }

    public void setDragBorder(boolean dragging) {
        this.myDragging = dragging;
        this.myDragBorder = dragging;
    }

    public boolean isDragBorder() {
        return this.myDragBorder;
    }

    public boolean isDefaultBinding() {
        return this.myDefaultBinding;
    }

    public void setDefaultBinding(boolean defaultBinding) {
        this.myDefaultBinding = defaultBinding;
    }

    public final void addPropertyChangeListener(PropertyChangeListener l) {
        PropertyChangeListener[] propertyChangeListeners;
        for (PropertyChangeListener listener : propertyChangeListeners = this.myChangeSupport.getPropertyChangeListeners()) {
            assert (listener != l);
        }
        this.myChangeSupport.addPropertyChangeListener(l);
    }

    public final void removePropertyChangeListener(PropertyChangeListener l) {
        this.myChangeSupport.removePropertyChangeListener(l);
    }

    protected final void firePropertyChanged(@NotNull String propertyName, Object oldValue, Object newValue) {
        if (propertyName == null) {
            RadComponent.$$$reportNull$$$0(11);
        }
        this.myChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    @NotNull
    public final GridConstraints getConstraints() {
        GridConstraints gridConstraints = this.myConstraints;
        if (gridConstraints == null) {
            RadComponent.$$$reportNull$$$0(12);
        }
        return gridConstraints;
    }

    public final RadContainer getParent() {
        return this.myParent;
    }

    public final void setParent(RadContainer parent) {
        this.myParent = parent;
    }

    public boolean isSelected() {
        return this.mySelected;
    }

    public void setSelected(boolean selected) {
        if (this.mySelected != selected) {
            this.mySelected = selected;
            this.firePropertyChanged(PROP_SELECTED, !this.mySelected, this.mySelected);
            GuiEditor.repaintLayeredPane(this);
        }
    }

    public final Object getClientProperty(@NotNull Object key) {
        if (key == null) {
            RadComponent.$$$reportNull$$$0(13);
        }
        return this.myDelegee.getClientProperty(key);
    }

    public final void putClientProperty(@NotNull Object key, Object value) {
        if (key == null) {
            RadComponent.$$$reportNull$$$0(14);
        }
        this.myDelegee.putClientProperty(key, value);
    }

    public final int getX() {
        return this.myDelegee.getX();
    }

    public final int getY() {
        return this.myDelegee.getY();
    }

    public final void setLocation(Point location) {
        this.myDelegee.setLocation(location);
    }

    public final void shift(int dx, int dy) {
        this.myDelegee.setLocation(this.myDelegee.getX() + dx, this.myDelegee.getY() + dy);
    }

    public final int getWidth() {
        return this.myDelegee.getWidth();
    }

    public final int getHeight() {
        return this.myDelegee.getHeight();
    }

    public final Dimension getSize() {
        return this.myDelegee.getSize();
    }

    public final void setSize(Dimension size) {
        this.myDelegee.setSize(size);
    }

    public final Rectangle getBounds() {
        return this.myDelegee.getBounds();
    }

    public final void setBounds(Rectangle bounds) {
        this.myDelegee.setBounds(bounds);
    }

    public final Dimension getMinimumSize() {
        return Util.getMinimumSize((Component)this.myDelegee, (GridConstraints)this.myConstraints, (boolean)false);
    }

    public final Dimension getPreferredSize() {
        return Util.getPreferredSize((Component)this.myDelegee, (GridConstraints)this.myConstraints, (boolean)false);
    }

    public void refresh() {
    }

    public final void revalidate() {
        RadContainer container;
        RadComponent theContainer = null;
        RadContainer radContainer = container = this instanceof RadContainer ? (RadContainer)this : this.getParent();
        while (container != null) {
            RadContainer parent = container.getParent();
            if (parent != null && parent.isXY()) {
                Dimension size = container.getSize();
                Dimension minimumSize = container.getMinimumSize();
                if (size.width < minimumSize.width || size.height < minimumSize.height) {
                    theContainer = container;
                }
            }
            container = container.getParent();
        }
        if (theContainer != null) {
            Dimension minimumSize = theContainer.getMinimumSize();
            minimumSize.width = Math.max(minimumSize.width, theContainer.getWidth());
            minimumSize.height = Math.max(minimumSize.height, theContainer.getHeight());
            theContainer.getDelegee().setSize(minimumSize);
        }
        this.myDelegee.revalidate();
    }

    public final boolean isMarkedAsModified(Property property) {
        return this.myModifiedPropertyNames.contains(property.getName());
    }

    public final void markPropertyAsModified(Property property) {
        this.myModifiedPropertyNames.add(property.getName());
    }

    public final void removeModifiedProperty(Property property) {
        this.myModifiedPropertyNames.remove(property.getName());
    }

    public RadComponent getComponentToDrag(Point pnt) {
        return this;
    }

    public void processMouseEvent(MouseEvent event) {
    }

    @Nullable
    public EventProcessor getEventProcessor(MouseEvent event) {
        return null;
    }

    public abstract void write(XmlWriter var1);

    protected final void writeId(XmlWriter writer) {
        writer.addAttribute("id", this.getId());
    }

    protected final void writeClass(XmlWriter writer) {
        writer.addAttribute("class", this.getComponentClass().getName());
    }

    protected final void writeClassIfDifferent(XmlWriter writer, String defaultClassName) {
        if (!this.getComponentClassName().equals(defaultClassName)) {
            writer.addAttribute("class", this.getComponentClass().getName());
        }
    }

    protected final void writeBinding(XmlWriter writer) {
        if (this.getBinding() != null) {
            writer.addAttribute("binding", this.getBinding());
        }
        if (this.isCustomCreate()) {
            writer.addAttribute("custom-create", Boolean.TRUE.toString());
        }
        if (this.isDefaultBinding()) {
            writer.addAttribute("default-binding", Boolean.TRUE.toString());
        }
    }

    protected void writeConstraints(XmlWriter writer) {
        writer.startElement(PROP_CONSTRAINTS);
        try {
            if (this.getParent() != null) {
                this.getParent().getLayoutManager().writeChildConstraints(writer, this);
            }
        }
        finally {
            writer.endElement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void writeProperties(XmlWriter writer) {
        writer.startElement("properties");
        try {
            IntrospectedProperty[] introspectedProperties;
            for (IntrospectedProperty property : introspectedProperties = this.getPalette().getIntrospectedProperties(this)) {
                Object value;
                if (!this.isMarkedAsModified(property) || (value = property.getValue(this)) == null) continue;
                writer.startElement(property.getName());
                try {
                    property.write(value, writer);
                }
                finally {
                    writer.endElement();
                }
            }
        }
        finally {
            writer.endElement();
        }
        this.writeClientProperties(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeClientProperties(XmlWriter writer) {
        if (this.myModule == null) {
            return;
        }
        boolean haveClientProperties = false;
        try {
            ClientPropertiesProperty cpp = ClientPropertiesProperty.getInstance(this.getProject());
            for (Property prop : cpp.getChildren(this)) {
                ClientPropertyProperty clientProp = (ClientPropertyProperty)prop;
                Object value = this.getDelegee().getClientProperty(clientProp.getName());
                if (value == null) continue;
                if (!haveClientProperties) {
                    writer.startElement("clientProperties");
                    haveClientProperties = true;
                }
                writer.startElement(clientProp.getName());
                writer.addAttribute("class", value.getClass().getName());
                writer.addAttribute("value", value.toString());
                writer.endElement();
            }
        }
        finally {
            if (haveClientProperties) {
                writer.endElement();
            }
        }
    }

    public void fireConstraintsChanged(GridConstraints oldConstraints) {
        this.firePropertyChanged(PROP_CONSTRAINTS, oldConstraints, this.myConstraints);
    }

    public IProperty[] getModifiedProperties() {
        IntrospectedProperty[] props = this.getPalette().getIntrospectedProperties(this);
        ArrayList<IntrospectedProperty> result = new ArrayList<IntrospectedProperty>();
        for (IntrospectedProperty prop : props) {
            if (!this.isMarkedAsModified(prop)) continue;
            result.add(prop);
        }
        return result.toArray(new IProperty[result.size()]);
    }

    public IContainer getParentContainer() {
        return this.myParent;
    }

    public boolean hasIntrospectedProperties() {
        return true;
    }

    public boolean accept(ComponentVisitor visitor) {
        return visitor.visit((IComponent)this);
    }

    public boolean areChildrenExclusive() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadLwProperty(LwComponent lwComponent, LwIntrospectedProperty lwProperty, IntrospectedProperty property) {
        this.myLoadingProperties = true;
        try {
            try {
                Object value = lwComponent.getPropertyValue(lwProperty);
                property.setValue(this, value);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        finally {
            this.myLoadingProperties = false;
        }
    }

    public void doneLoadingFromLw() {
    }

    @Nullable
    public static RadComponent createSnapshotComponent(SnapshotContext context, JComponent component) {
        DefaultButtonModel model;
        AbstractButton btn;
        IntrospectedProperty[] properties;
        RadComponent result;
        String id = context.newId();
        Class<?> componentClass = component.getClass();
        if (componentClass.isAnonymousClass()) {
            componentClass = componentClass.getSuperclass();
        }
        if (component instanceof JPanel && !RadComponent.isCompositeComponent(component)) {
            RadContainer container = new RadContainer(componentClass, id, context.getPalette());
            IntrospectedProperty[] manager = LayoutManagerRegistry.createFromLayout(component.getLayout());
            if (manager == null) {
                return null;
            }
            container.setLayoutManager((RadLayoutManager)manager);
            result = container;
        } else if (component instanceof Box.Filler) {
            Box.Filler filler = (Box.Filler)component;
            if (filler.getMaximumSize().height == Short.MAX_VALUE) {
                result = new RadVSpacer(null, id);
                result.getConstraints().setVSizePolicy(6);
            } else {
                result = new RadHSpacer(null, id);
                result.getConstraints().setHSizePolicy(6);
            }
        } else {
            RadComponentFactory factory = InsertComponentProcessor.getRadComponentFactory(componentClass);
            result = factory == null ? new RadAtomicComponent(componentClass, id, context.getPalette()) : factory.newInstance(componentClass, id, context.getPalette());
        }
        context.registerComponent(component, result);
        result.importSnapshotComponent(context, component);
        for (IntrospectedProperty prop : properties = context.getPalette().getIntrospectedProperties(component.getClass(), result.getDelegee().getClass())) {
            if (component instanceof AbstractButton) {
                AbstractButton btn2 = (AbstractButton)component;
                if (prop.getName().equals("label") && btn2.getLabel().equals(btn2.getText()) || prop.getName().equals("actionCommand") && btn2.getActionCommand().equals(btn2.getText())) continue;
            }
            prop.importSnapshotValue(context, component, result);
        }
        if (component instanceof AbstractButton && (btn = (AbstractButton)component).getModel() instanceof DefaultButtonModel && (model = (DefaultButtonModel)btn.getModel()).getGroup() != null) {
            context.registerButtonGroup(model.getGroup());
        }
        return result;
    }

    private static boolean isCompositeComponent(JComponent component) {
        JComponent instance;
        if (component.getComponentCount() == 0) {
            return false;
        }
        try {
            instance = (JComponent)component.getClass().newInstance();
        }
        catch (Exception ex) {
            return false;
        }
        return instance.getComponentCount() == component.getComponentCount();
    }

    protected void importSnapshotComponent(SnapshotContext context, JComponent component) {
    }

    @Nullable
    public String getComponentTitle() {
        RadContainer container;
        StringDescriptor descriptor;
        IntrospectedProperty[] props;
        Palette palette = Palette.getInstance(this.getProject());
        for (IntrospectedProperty prop : props = palette.getIntrospectedProperties(this)) {
            StringDescriptor value;
            if (!prop.getName().equals("text") || !(prop instanceof IntroStringProperty) || (value = (StringDescriptor)prop.getValue(this)) == null) continue;
            return "\"" + value.getResolvedValue() + "\"";
        }
        if (this instanceof RadContainer && (descriptor = (container = (RadContainer)this).getBorderTitle()) != null) {
            if (descriptor.getResolvedValue() == null) {
                descriptor.setResolvedValue(StringDescriptorManager.getInstance(this.getModule()).resolve(this, descriptor));
            }
            return "\"" + descriptor.getResolvedValue() + "\"";
        }
        if (this.getParent() instanceof RadTabbedPane) {
            RadTabbedPane parentTabbedPane = (RadTabbedPane)this.getParent();
            descriptor = parentTabbedPane.getChildTitle(this);
            if (descriptor != null) {
                if (descriptor.getResolvedValue() == null) {
                    descriptor.setResolvedValue(StringDescriptorManager.getInstance(this.getModule()).resolve(this, descriptor));
                }
                return "\"" + descriptor.getResolvedValue() + "\"";
            }
            parentTabbedPane.getChildTitle(this);
        }
        return null;
    }

    public String getDisplayName() {
        StringBuilder titleBuilder = new StringBuilder();
        if (this.getBinding() != null) {
            titleBuilder.append(this.getBinding());
        } else {
            String className = this.getComponentClassName();
            int pos = className.lastIndexOf(46);
            if (pos < 0) {
                titleBuilder.append(className);
            } else {
                titleBuilder.append(className.substring(pos + 1).replace('$', '.'));
            }
            String title = this.getComponentTitle();
            if (title != null) {
                titleBuilder.append(" ").append(title);
            }
        }
        return titleBuilder.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uiDesigner/radComponents/RadComponent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uiDesigner/radComponents/RadComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegee";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentClass";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentClassName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstraints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "initDefaultProperties";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getInplaceEditorBounds";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "firePropertyChanged";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getClientProperty";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "putClientProperty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

