/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.quirksmode;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssFileType;
import com.intellij.util.ProcessingContext;
import com.jetbrains.quirksmode.BrowserSet;
import com.jetbrains.quirksmode.CssHtmlPatternUtil;
import com.jetbrains.quirksmode.HtmlFilePattern;
import com.jetbrains.quirksmode.ProblemDetector;
import com.jetbrains.quirksmode.QuirksModeRegistrar;
import com.jetbrains.quirksmode.QuirksModeSettingsPanel;
import com.jetbrains.quirksmode.SupportedBrowsersBean;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuirksModeInspectionTool
extends LocalInspectionTool {
    private static final Key<ProcessingContext> CONTEXT_KEY = Key.create((String)"quirks.context");
    private static final List<ProblemDetector> ourDetectors = new ArrayList<ProblemDetector>();
    private final SupportedBrowsersBean mySupportedBrowsersBean = new SupportedBrowsersBean();

    @Nullable
    public JComponent createOptionsPanel() {
        return new QuirksModeSettingsPanel(this.mySupportedBrowsersBean);
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            QuirksModeInspectionTool.$$$reportNull$$$0(0);
        }
        this.mySupportedBrowsersBean.readSettings(node);
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            QuirksModeInspectionTool.$$$reportNull$$$0(1);
        }
        this.mySupportedBrowsersBean.writeSettings(node);
    }

    SupportedBrowsersBean getSupportedBrowsersBean() {
        return this.mySupportedBrowsersBean;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly, final @NotNull LocalInspectionToolSession session) {
        PsiFile file;
        Language type;
        if (holder == null) {
            QuirksModeInspectionTool.$$$reportNull$$$0(2);
        }
        if (session == null) {
            QuirksModeInspectionTool.$$$reportNull$$$0(3);
        }
        if ((type = (file = holder.getFile()).getLanguage()) != StdFileTypes.HTML.getLanguage() && type != StdFileTypes.XHTML.getLanguage() && type != StdFileTypes.JSP.getLanguage() && type != StdFileTypes.JSPX.getLanguage() && type != CssFileType.INSTANCE.getLanguage()) {
            PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly, session);
            if (psiElementVisitor == null) {
                QuirksModeInspectionTool.$$$reportNull$$$0(4);
            }
            return psiElementVisitor;
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                BrowserSet browserSet;
                ProcessingContext matchingContext = (ProcessingContext)session.getUserData(CONTEXT_KEY);
                if (matchingContext == null) {
                    matchingContext = new ProcessingContext();
                    PsiFile file = element.getContainingFile();
                    CssHtmlPatternUtil.buildCaches((PsiElement)file, matchingContext.getSharedContext());
                    browserSet = QuirksModeInspectionTool.this.getSupportedBrowsersBean().getBrowserSet();
                    matchingContext.getSharedContext().put(HtmlFilePattern.ACTIVE_BROWSERS_KEY, (Object)browserSet);
                    session.putUserData(CONTEXT_KEY, (Object)matchingContext);
                } else {
                    browserSet = (BrowserSet)matchingContext.getSharedContext().get(HtmlFilePattern.ACTIVE_BROWSERS_KEY);
                }
                ArrayList<ProblemDetector> activeDetectors = new ArrayList<ProblemDetector>();
                for (ProblemDetector detector : ourDetectors) {
                    if (!detector.isActive(browserSet)) continue;
                    activeDetectors.add(detector);
                }
                for (ProblemDetector detector : activeDetectors) {
                    if (!detector.getPattern().accepts((Object)element, matchingContext)) continue;
                    detector.createDescriptors(element, holder, browserSet, isOnTheFly);
                }
            }
        };
        if (psiElementVisitor == null) {
            QuirksModeInspectionTool.$$$reportNull$$$0(5);
        }
        return psiElementVisitor;
    }

    static void register(@NotNull ProblemDetector detector) {
        if (detector == null) {
            QuirksModeInspectionTool.$$$reportNull$$$0(6);
        }
        ourDetectors.add(detector);
    }

    static {
        QuirksModeRegistrar.register();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/quirksmode/QuirksModeInspectionTool";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/quirksmode/QuirksModeInspectionTool";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

