/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.internal.daemon;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.lang.UrlClassLoader;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.tooling.internal.consumer.ConnectorServices;
import org.gradle.tooling.internal.consumer.connection.ConsumerConnection;
import org.gradle.tooling.internal.consumer.loader.CachingToolingImplementationLoader;
import org.gradle.tooling.internal.consumer.loader.SynchronizedToolingImplementationLoader;
import org.gradle.tooling.internal.consumer.loader.ToolingImplementationLoader;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.plugins.gradle.internal.daemon.DaemonState;
import org.jetbrains.plugins.gradle.internal.daemon.DaemonStatusAction;
import org.jetbrains.plugins.gradle.internal.daemon.DaemonStopAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ApiStatus.Experimental
public class GradleDaemonServices
implements GroovyObject {
    private static final Logger LOG;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public GradleDaemonServices() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static void stopDaemons() {
        Map<ClassPath, ConsumerConnection> connections = GradleDaemonServices.getConnections();
        ConsumerConnection conn = null;
        Iterator<ConsumerConnection> iterator = connections.values().iterator();
        while (iterator.hasNext()) {
            conn = (ConsumerConnection)ScriptBytecodeAdapter.castToType((Object)iterator.next(), ConsumerConnection.class);
            GradleDaemonServices.runAction(conn, DaemonStopAction.class, null);
        }
    }

    public static void stopDaemons(List<DaemonState> daemons) {
        Reference tokens = new Reference(new ArrayList());
        public class _stopDaemons_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference tokens;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _stopDaemons_closure1(Object _outerInstance, Object _thisObject, Reference tokens) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.tokens = reference = tokens;
            }

            public Object doCall(Object it) {
                if (DefaultTypeTransformation.booleanUnbox((Object)((DaemonState)it).getToken())) {
                    return ((ArrayList)this.tokens.get()).add(((DaemonState)it).getToken());
                }
                return null;
            }

            public List getTokens() {
                return (List)ScriptBytecodeAdapter.castToType((Object)this.tokens.get(), List.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _stopDaemons_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(daemons, (Closure)new _stopDaemons_closure1(GradleDaemonServices.class, GradleDaemonServices.class, tokens));
        Map<ClassPath, ConsumerConnection> connections = GradleDaemonServices.getConnections();
        ConsumerConnection conn = null;
        Iterator<ConsumerConnection> iterator = connections.values().iterator();
        while (iterator.hasNext()) {
            conn = (ConsumerConnection)ScriptBytecodeAdapter.castToType((Object)iterator.next(), ConsumerConnection.class);
            GradleDaemonServices.runAction(conn, DaemonStopAction.class, (ArrayList)tokens.get());
        }
    }

    public static List<DaemonState> getDaemonsStatus() {
        ArrayList<DaemonState> result = new ArrayList<DaemonState>();
        Map<ClassPath, ConsumerConnection> connections = GradleDaemonServices.getConnections();
        ConsumerConnection conn = null;
        Iterator<ConsumerConnection> iterator = connections.values().iterator();
        while (iterator.hasNext()) {
            conn = (ConsumerConnection)ScriptBytecodeAdapter.castToType((Object)iterator.next(), ConsumerConnection.class);
            List daemonStates = (List)ScriptBytecodeAdapter.asType((Object)GradleDaemonServices.runAction(conn, DaemonStatusAction.class, null), List.class);
            if (!DefaultTypeTransformation.booleanUnbox((Object)daemonStates)) continue;
            result.addAll(daemonStates);
        }
        return result;
    }

    private static Object runAction(Object daemonClientFactory, ConsumerConnection connection, Class actionClass, Object arg) {
        UrlClassLoader daemonClientClassLoader = UrlClassLoader.build().urls(new URL[]{new File(PathManager.getJarPathForClass((Class)actionClass)).toURI().toURL()}).parent(daemonClientFactory.getClass().getClassLoader()).allowLock(false).get();
        byte[] myRawArgData = GradleDaemonServices.getSerialized(arg);
        byte[] myRawResultData = null;
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)daemonClientClassLoader);
            Class clazz = daemonClientClassLoader.loadClass(actionClass.getName());
            Object _arg = GradleDaemonServices.getObject(myRawArgData);
            Method method = GradleDaemonServices.findMethod(clazz, daemonClientFactory, _arg);
            Object result = arg == null ? method.invoke(DefaultGroovyMethods.newInstance((Class)clazz), daemonClientFactory) : method.invoke(DefaultGroovyMethods.newInstance((Class)clazz), daemonClientFactory, _arg);
            if (result instanceof Serializable) {
                byte[] byArray;
                myRawResultData = byArray = GradleDaemonServices.getSerialized(result);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        if (myRawResultData != null) {
            return GradleDaemonServices.getObject(myRawResultData);
        }
        return null;
    }

    private static Method findMethod(Class<?> clazz, Object daemonClientFactory, Object arg) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)arg)) {
            return clazz.getMethod("run", daemonClientFactory.getClass());
        }
        Method method = null;
        try {
            Method method2;
            method = method2 = clazz.getMethod("run", daemonClientFactory.getClass(), arg.getClass());
        }
        catch (Exception ignore) {
        }
        if (method == null) {
            Class<?>[] interfaces = arg.getClass().getInterfaces();
            Class<?> cl = null;
            Class<?>[] classArray = interfaces;
            if (interfaces != null) {
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Method method3;
                    cl = classArray[n2];
                    ++n2;
                    method = method3 = clazz.getMethod("run", daemonClientFactory.getClass(), cl);
                    try {
                        break;
                    }
                    catch (Exception ignore) {
                    }
                }
            }
        }
        return method;
    }

    private static byte[] getSerialized(Object obj) {
        if (obj instanceof Serializable) {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ObjectOutputStream oOut = new ObjectOutputStream(bOut);
            try {
                oOut.writeObject(obj);
                byte[] byArray = bOut.toByteArray();
                return byArray;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                oOut.close();
            }
        }
        return (byte[])ScriptBytecodeAdapter.castToType(null, byte[].class);
    }

    private static Object getObject(byte ... bytes) {
        if (bytes != null) {
            ObjectInputStream objectInputStream;
            ObjectInputStream oIn = null;
            oIn = objectInputStream = new ObjectInputStream(new ByteArrayInputStream(bytes));
            Object object = oIn.readObject();
            StreamUtil.closeStream((Closeable)oIn);
            try {
                try {
                    return object;
                }
                catch (Exception ignore) {
                    StreamUtil.closeStream(oIn);
                }
            }
            catch (Throwable throwable) {
                StreamUtil.closeStream(oIn);
                throw throwable;
            }
        }
        return null;
    }

    private static Map<ClassPath, ConsumerConnection> getConnections() {
        CallSite[] callSiteArray = GradleDaemonServices.$getCallSiteArray();
        Object registry = callSiteArray[0].callGetProperty(ConnectorServices.class);
        SynchronizedToolingImplementationLoader loader = (SynchronizedToolingImplementationLoader)ScriptBytecodeAdapter.asType((Object)callSiteArray[1].call(registry, ToolingImplementationLoader.class), SynchronizedToolingImplementationLoader.class);
        CachingToolingImplementationLoader delegate = (CachingToolingImplementationLoader)ScriptBytecodeAdapter.asType((Object)callSiteArray[2].callGetProperty((Object)loader), CachingToolingImplementationLoader.class);
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].callGetProperty((Object)delegate), Map.class);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object runAction(ConsumerConnection connection, Object actionClass, Object arg) {
        CallSite[] callSiteArray = GradleDaemonServices.$getCallSiteArray();
        try {
            Object daemonClientFactory = callSiteArray[4].callGetProperty(callSiteArray[5].callGetProperty(callSiteArray[6].callGetProperty(callSiteArray[7].callGetProperty((Object)connection))));
            return callSiteArray[8].callStatic(GradleDaemonServices.class, daemonClientFactory, (Object)connection, actionClass, arg);
        }
        catch (Throwable t) {
            callSiteArray[9].call((Object)LOG, callSiteArray[10].call((Object)"Unable to send daemon message for ", callSiteArray[11].call((Object)connection)));
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[12].call((Object)LOG))) return callSiteArray[14].call((Object)LOG, callSiteArray[15].call(ExceptionUtil.class, callSiteArray[16].call(ExceptionUtil.class, (Object)t), (Object)"Unable to send daemon message"));
            Object object = callSiteArray[13].call((Object)LOG, (Object)t);
            return object;
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != GradleDaemonServices.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        LOG = logger = Logger.getInstance(GradleDaemonServices.class);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "singletonRegistry";
        stringArray[1] = "get";
        stringArray[2] = "delegate";
        stringArray[3] = "connections";
        stringArray[4] = "daemonClientFactory";
        stringArray[5] = "connection";
        stringArray[6] = "delegate";
        stringArray[7] = "delegate";
        stringArray[8] = "runAction";
        stringArray[9] = "warn";
        stringArray[10] = "plus";
        stringArray[11] = "getDisplayName";
        stringArray[12] = "isDebugEnabled";
        stringArray[13] = "debug";
        stringArray[14] = "warn";
        stringArray[15] = "getNonEmptyMessage";
        stringArray[16] = "getRootCause";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[17];
        GradleDaemonServices.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(GradleDaemonServices.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = GradleDaemonServices.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

