/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.settings;

import com.intellij.diagram.DiagramCategory;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramScopeManager;
import com.intellij.diagram.extras.DiagramExtras;
import com.intellij.diagram.settings.DiagramConfigElement;
import com.intellij.diagram.settings.DiagramConfigGroup;
import com.intellij.diagram.settings.DiagramLayout;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

@State(name="UmlConfiguration", storages={@Storage(value="uml.xml")})
public class DiagramConfiguration
implements PersistentStateComponent<DiagramConfiguration>,
Cloneable {
    public String defaultScope = "All";
    public boolean fitContentAfterLayout = false;
    public DiagramLayout layout = DiagramLayout.HIERARCHIC_GROUP;
    public boolean relayoutOnNewElements = true;
    @MapAnnotation(keyAttributeName="id", valueAttributeName="categories")
    public Map<String, String> categories = new HashMap<String, String>();

    public static DiagramConfiguration getInstance() {
        return (DiagramConfiguration)ServiceManager.getService(DiagramConfiguration.class);
    }

    public static DiagramConfiguration getConfiguration() {
        return DiagramConfiguration.getInstance();
    }

    public DiagramConfiguration getState() {
        return this;
    }

    public void loadState(DiagramConfiguration state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    public boolean isEnabledByDefault(DiagramProvider provider, String catName) {
        String cats = this.categories.get(provider.getID());
        boolean enabledByDefault = DiagramConfiguration.getDefaultValue(provider, catName);
        if (cats == null) {
            return enabledByDefault;
        }
        return Arrays.asList(cats.split(";")).contains(catName) ? !enabledByDefault : enabledByDefault;
    }

    private static boolean getDefaultValue(DiagramProvider provider, String catName) {
        for (DiagramCategory category : provider.getNodeContentManager().getContentCategories()) {
            if (!category.getName().equals(catName)) continue;
            return category.isEnabledByDefault();
        }
        DiagramExtras extras = provider.getExtras();
        for (DiagramConfigGroup group : extras.getAdditionalDiagramSettings()) {
            for (DiagramConfigElement element : group.getElements()) {
                if (!element.getName().equals(catName)) continue;
                return element.isChecked();
            }
        }
        throw new IllegalArgumentException("There is no element '" + catName + "' in UML provider " + provider.getID());
    }

    public NamedScope getDefaultScope(DiagramScopeManager manager) {
        NamedScope scope;
        if (this.defaultScope != null && (scope = manager.fromName(this.defaultScope)) != null) {
            return scope;
        }
        return manager.getCurrentScope();
    }

    public DiagramConfiguration clone() throws CloneNotSupportedException {
        return (DiagramConfiguration)super.clone();
    }
}

