/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.editorActions;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.velocity.editorActions.EditorUtil;
import com.intellij.velocity.psi.VtlCompositeElementTypes;
import com.intellij.velocity.psi.VtlElementTypes;
import com.intellij.velocity.psi.VtlLanguage;
import com.intellij.velocity.psi.files.VtlFileViewProvider;
import com.intellij.velocity.psi.reference.VtlReferenceExpression;
import org.jetbrains.annotations.NotNull;

public class VelocityTypedHandler
extends TypedHandlerDelegate {
    private static final ElementPattern<VtlReferenceExpression> MACRO_NAME_WITH_BODY = PlatformPatterns.psiElement(VtlReferenceExpression.class).withParent((ElementPattern)PlatformPatterns.psiElement(PsiErrorElement.class).withText((ElementPattern)StandardPatterns.string().startsWith("#@")));

    public TypedHandlerDelegate.Result checkAutoPopup(char charTyped, Project project, Editor editor, PsiFile file) {
        if (!(file.getViewProvider() instanceof VtlFileViewProvider)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        int offset = editor.getCaretModel().getOffset();
        if (charTyped == '#' && (offset == 0 || editor.getDocument().getCharsSequence().charAt(offset - 1) != '#')) {
            AutoPopupController.getInstance((Project)project).scheduleAutoPopup(editor, CompletionType.BASIC, f -> VelocityTypedHandler.isInsideTemplateText(offset, f));
            return TypedHandlerDelegate.Result.STOP;
        }
        return super.checkAutoPopup(charTyped, project, editor, file);
    }

    public static boolean isInsideTemplateText(int offset, PsiFile f) {
        return PsiUtilCore.getElementType((PsiElement)f.getViewProvider().findElementAt(offset, (Language)VtlLanguage.INSTANCE)) == VtlElementTypes.TEMPLATE_TEXT;
    }

    public TypedHandlerDelegate.Result beforeCharTyped(char c, Project project, Editor editor, PsiFile file, FileType fileType) {
        if (EditorUtil.isNotVtlFile(file, editor)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        Document document = editor.getDocument();
        if (c == '(') {
            int offset = editor.getCaretModel().getOffset();
            char charAtOffset = EditorUtil.getCharAt(document, offset);
            if (charAtOffset == '(') {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"(", (boolean)true, (int)1);
                return TypedHandlerDelegate.Result.STOP;
            }
            if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET || charAtOffset == ')') {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            VelocityTypedHandler.closeDirective(editor, file, offset);
            return TypedHandlerDelegate.Result.STOP;
        }
        if (c == '}') {
            int offset = editor.getCaretModel().getOffset();
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            if (EditorUtil.getCharAt(document, offset) == '}') {
                EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
                return TypedHandlerDelegate.Result.STOP;
            }
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    public static void closeDirective(Editor editor, PsiFile file, int offset) {
        String toType;
        Document document = editor.getDocument();
        document.insertString(offset, (CharSequence)"()");
        editor.getCaretModel().moveToOffset(offset + 1);
        Project project = file.getProject();
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        PsiElement token = file.findElementAt(offset - 1);
        if (token == null) {
            return;
        }
        String tokenText = token.getText().trim();
        if ("#foreach".equals(tokenText) || "#if".equals(tokenText) || "#macro".equals(tokenText)) {
            toType = "\n#end";
        } else if ("#{foreach}".equals(tokenText) || "#{if}".equals(tokenText) || "#{macro}".equals(tokenText)) {
            toType = "\n#{end}";
        } else if (MACRO_NAME_WITH_BODY.accepts((Object)token.getParent())) {
            toType = " #end";
        } else {
            return;
        }
        document.insertString(offset + 2, (CharSequence)toType);
        if (toType.contains("\n")) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            CodeStyleManager.getInstance((Project)project).adjustLineIndent(file, new TextRange(offset + 3, offset + 2 + toType.length()));
        }
    }

    public TypedHandlerDelegate.Result charTyped(char c, Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            VelocityTypedHandler.$$$reportNull$$$0(0);
        }
        if (file == null) {
            VelocityTypedHandler.$$$reportNull$$$0(1);
        }
        if (EditorUtil.isNotVtlFile(file, editor)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        Document document = editor.getDocument();
        if (c == '{') {
            int offset = editor.getCaretModel().getOffset();
            documentManager.commitDocument(document);
            PsiElement element = file.findElementAt(offset - 1);
            if (element != null) {
                CharSequence text;
                if (element.getLanguage() == StdLanguages.TEXT) {
                    text = document.getCharsSequence();
                    if (offset >= 2 && text.charAt(offset - 2) == '$' && (offset >= text.length() || text.charAt(offset) != '}')) {
                        document.insertString(offset, (CharSequence)"}");
                        return TypedHandlerDelegate.Result.STOP;
                    }
                }
                if ("${".equals(text = element.getText().trim()) || "$!{".equals(text) || "#{".equals(text)) {
                    char charAtOffset = EditorUtil.getCharAt(document, offset);
                    String textToInsert = charAtOffset == '{' ? "}$" : "}";
                    PsiElement parent = element.getParent();
                    if (EditorUtil.getElementType(parent) == VtlCompositeElementTypes.INTERPOLATION) {
                        if (parent.getText().endsWith("}")) {
                            return TypedHandlerDelegate.Result.STOP;
                        }
                        offset = parent.getTextOffset() + parent.getTextLength();
                    }
                    document.insertString(offset, (CharSequence)textToInsert);
                    return TypedHandlerDelegate.Result.STOP;
                }
            }
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "com/intellij/velocity/editorActions/VelocityTypedHandler";
        objectArray[2] = "charTyped";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

