/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.build;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.execution.configurations.CommandLineTokenizer;
import com.intellij.flex.FlexCommonUtils;
import com.intellij.lang.javascript.JSConditionalCompilationDefinitionsProvider;
import com.intellij.lang.javascript.flex.FlexModuleType;
import com.intellij.lang.javascript.flex.FlexUtils;
import com.intellij.lang.javascript.flex.projectStructure.FlexProjectLevelCompilerOptionsHolder;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfigurationManager;
import com.intellij.lang.javascript.flex.projectStructure.model.ModuleOrProjectCompilerOptions;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import gnu.trove.THashMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jdom.Element;
import org.jdom.JDOMException;

public class JSConditionalCompilationDefinitionsProviderImpl
implements JSConditionalCompilationDefinitionsProvider {
    private static final String[] CONDITIONAL_COMPILATION_DEFINITION_OPTION_ALIASES = new String[]{"define", "compiler.define"};
    private final Map<VirtualFile, Long> configFileToTimestamp = new THashMap();
    private final Map<VirtualFile, Collection<Pair<String, String>>> configFileToConditionalCompilerDefinitions = new THashMap();

    public boolean containsConstant(Module module, String namespace, String constantName) {
        if (module != null && ModuleType.get((Module)module) instanceof FlexModuleType && !StringUtil.isEmpty((String)namespace) && !StringUtil.isEmpty((String)constantName)) {
            boolean searchForPrefix = constantName.contains(CompletionUtil.DUMMY_IDENTIFIER_TRIMMED);
            String searchedName = namespace + "::" + (searchForPrefix ? "" : constantName);
            Ref result = new Ref((Object)false);
            this.processConditionalCompilationDefinitions(module, (Processor<Pair<String, String>>)((Processor)nameAndValue -> {
                if (searchForPrefix && ((String)nameAndValue.first).startsWith(searchedName) || !searchForPrefix && ((String)nameAndValue.first).equals(searchedName)) {
                    result.set((Object)true);
                    return false;
                }
                return true;
            }));
            return (Boolean)result.get();
        }
        return false;
    }

    public Collection<String> getConstantNamesForNamespace(Module module, String namespace) {
        ArrayList<String> result = new ArrayList<String>();
        if (module != null && ModuleType.get((Module)module) instanceof FlexModuleType && !StringUtil.isEmpty((String)namespace)) {
            String beginning = namespace + "::";
            this.processConditionalCompilationDefinitions(module, (Processor<Pair<String, String>>)((Processor)nameAndValue -> {
                if (((String)nameAndValue.first).startsWith(beginning)) {
                    result.add(((String)nameAndValue.first).substring(beginning.length()));
                }
                return true;
            }));
        }
        return result;
    }

    public Collection<String> getAllConstants(Module module) {
        ArrayList<String> result = new ArrayList<String>();
        if (module != null && ModuleType.get((Module)module) instanceof FlexModuleType) {
            this.processConditionalCompilationDefinitions(module, (Processor<Pair<String, String>>)((Processor)nameAndValue -> {
                result.add((String)nameAndValue.first);
                return true;
            }));
        }
        return result;
    }

    private void processConditionalCompilationDefinitions(Module module, Processor<Pair<String, String>> processor) {
        FlexBuildConfigurationManager manager = FlexBuildConfigurationManager.getInstance(module);
        FlexBuildConfiguration bc = manager.getActiveConfiguration();
        ModuleOrProjectCompilerOptions moduleLevelOptions = manager.getModuleLevelCompilerOptions();
        ModuleOrProjectCompilerOptions projectLevelOptions = FlexProjectLevelCompilerOptionsHolder.getInstance(module.getProject()).getProjectLevelCompilerOptions();
        if (!FlexUtils.processCompilerOption(module, bc, "compiler.define", processor)) {
            return;
        }
        if (!JSConditionalCompilationDefinitionsProviderImpl.processDefinitionsFromCompilerOptions(projectLevelOptions.getAdditionalOptions(), processor)) {
            return;
        }
        if (!JSConditionalCompilationDefinitionsProviderImpl.processDefinitionsFromCompilerOptions(moduleLevelOptions.getAdditionalOptions(), processor)) {
            return;
        }
        if (!JSConditionalCompilationDefinitionsProviderImpl.processDefinitionsFromCompilerOptions(bc.getCompilerOptions().getAdditionalOptions(), processor)) {
            return;
        }
        for (Pair<String, String> nameAndValue : this.getDefinitionsFromConfigFile(bc.getCompilerOptions().getAdditionalConfigFilePath())) {
            if (processor.process(nameAndValue)) continue;
            return;
        }
    }

    private Collection<Pair<String, String>> getDefinitionsFromConfigFile(String configFilePath) {
        if (StringUtil.isEmptyOrSpaces((String)configFilePath)) {
            return Collections.emptyList();
        }
        VirtualFile configFile = LocalFileSystem.getInstance().findFileByPath(configFilePath);
        if (configFile == null || configFile.isDirectory()) {
            return Collections.emptyList();
        }
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        Document cachedDocument = documentManager.getCachedDocument(configFile);
        Long currentTimestamp = cachedDocument != null ? cachedDocument.getModificationStamp() : configFile.getModificationCount();
        Long cachedTimestamp = this.configFileToTimestamp.get(configFile);
        if (cachedTimestamp == null || !cachedTimestamp.equals(currentTimestamp)) {
            this.configFileToTimestamp.remove(configFile);
            this.configFileToConditionalCompilerDefinitions.remove(configFile);
            try {
                Element rootElement = cachedDocument == null ? JDOMUtil.load((InputStream)configFile.getInputStream()) : JDOMUtil.load((CharSequence)cachedDocument.getCharsSequence());
                ArrayList<Pair<String, String>> result = new ArrayList<Pair<String, String>>();
                if (rootElement.getName().equals("flex-config")) {
                    for (Element compilerElement : rootElement.getChildren("compiler", rootElement.getNamespace())) {
                        for (Element defineElement : compilerElement.getChildren("define", rootElement.getNamespace())) {
                            String name = defineElement.getChildText("name", rootElement.getNamespace());
                            String value = defineElement.getChildText("value", rootElement.getNamespace());
                            if (StringUtil.isEmpty((String)name) || value == null) continue;
                            result.add((Pair<String, String>)Pair.create((Object)name, (Object)value));
                        }
                    }
                }
                this.configFileToTimestamp.put(configFile, currentTimestamp);
                this.configFileToConditionalCompilerDefinitions.put(configFile, result);
                return result;
            }
            catch (JDOMException jDOMException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return Collections.emptyList();
        }
        return this.configFileToConditionalCompilerDefinitions.get(configFile);
    }

    private static boolean processDefinitionsFromCompilerOptions(String compilerOptions, Processor<Pair<String, String>> processor) {
        if (StringUtil.isEmpty((String)compilerOptions)) {
            return true;
        }
        CommandLineTokenizer stringTokenizer = new CommandLineTokenizer(compilerOptions);
        while (stringTokenizer.hasMoreTokens()) {
            String token = stringTokenizer.nextToken();
            for (String option : CONDITIONAL_COMPILATION_DEFINITION_OPTION_ALIASES) {
                if (token.startsWith("-" + option + "=") || token.startsWith("-" + option + "+=")) {
                    String optionValue = token.substring(token.indexOf("=") + 1);
                    int commaIndex = optionValue.indexOf(44);
                    if (commaIndex <= 0 || processor.process((Object)Pair.create((Object)optionValue.substring(0, commaIndex), (Object)optionValue.substring(commaIndex + 1)))) continue;
                    return false;
                }
                if (!token.equals("-" + option) || stringTokenizer.countTokens() < 2) continue;
                String name = stringTokenizer.peekNextToken();
                stringTokenizer.nextToken();
                String value = stringTokenizer.peekNextToken();
                if (!FlexCommonUtils.canBeCompilerOptionValue((String)value)) continue;
                stringTokenizer.nextToken();
                if (processor.process((Object)Pair.create((Object)name, (Object)value))) continue;
                return false;
            }
        }
        return true;
    }
}

