/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.importer;

import com.intellij.lang.javascript.JSFlexAdapter;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.ECMAL4LanguageDialect;
import com.intellij.lang.javascript.flex.importer.Abc;
import com.intellij.lang.javascript.flex.importer.AbstractDumpProcessor;
import com.intellij.lang.javascript.flex.importer.MemberInfo;
import com.intellij.lang.javascript.flex.importer.MetaData;
import com.intellij.lang.javascript.flex.importer.MethodInfo;
import com.intellij.lang.javascript.flex.importer.Multiname;
import com.intellij.lang.javascript.flex.importer.SlotInfo;
import com.intellij.lang.javascript.flex.importer.Traits;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AS3InterfaceDumper
extends AbstractDumpProcessor {
    private int memberCount;
    private boolean isInterface;
    private boolean myDumpTypeRef;
    private static Lexer ourLexer = new JSFlexAdapter(ECMAL4LanguageDialect.DIALECT_OPTION_HOLDER);
    @NonNls
    private static final Set<String> doNotNeedQoting = new THashSet(Arrays.asList("null", "NaN", "undefined", "true", "false", "Infinity", "-Infinity"));

    AS3InterfaceDumper() {
    }

    @Override
    public void dumpStat(@NotNull String stat) {
        if (stat == null) {
            AS3InterfaceDumper.$$$reportNull$$$0(0);
        }
    }

    @Override
    public void dumpToplevelAnonymousMethod(@NotNull Abc abc, @NotNull MethodInfo m) {
        if (abc == null) {
            AS3InterfaceDumper.$$$reportNull$$$0(1);
        }
        if (m == null) {
            AS3InterfaceDumper.$$$reportNull$$$0(2);
        }
    }

    @Override
    public void dumpTopLevelTraits(Abc abc, @NotNull Traits t, String indent) {
        if (t == null) {
            AS3InterfaceDumper.$$$reportNull$$$0(3);
        }
        t.dump(abc, indent, "", this);
    }

    @Override
    public boolean doDumpMember(@NotNull MemberInfo memberInfo) {
        if (memberInfo == null) {
            AS3InterfaceDumper.$$$reportNull$$$0(4);
        }
        if (memberInfo.name == null) {
            return false;
        }
        if (memberInfo.name.name != null) {
            if (memberInfo.name.name.indexOf("$cinit") >= 0) {
                return false;
            }
            if (!StringUtil.isJavaIdentifier((String)memberInfo.name.name)) {
                return false;
            }
            if (!JSTokenTypes.IDENTIFIER_TOKENS_SET.contains(AS3InterfaceDumper.identifierType(memberInfo.name.name))) {
                return false;
            }
            if (this.isInterface) {
                return memberInfo.parentTraits.init != memberInfo;
            }
        }
        return true;
    }

    public static synchronized IElementType identifierType(String name) {
        ourLexer.start((CharSequence)name);
        if (ourLexer.getTokenEnd() != name.length()) {
            return null;
        }
        return ourLexer.getTokenType();
    }

    @Override
    public void appendMethodSeparator() {
        this.append(++this.memberCount % 5 == 0 ? "\n" : "");
    }

    @Override
    public void appendFieldSeparator() {
        this.appendMethodSeparator();
    }

    @Override
    public String getAbcInSwfIndent() {
        return "";
    }

    @Override
    public void processValue(Multiname typeName, Object valueObject) {
        this.append(" = ");
        this.append(AS3InterfaceDumper.getValueRepr(valueObject));
    }

    protected static String getValueRepr(Object valueObject) {
        if (valueObject == null) {
            return null;
        }
        String value = valueObject.toString();
        if (AS3InterfaceDumper.needsQuoting(value)) {
            char ch;
            boolean doQoute = true;
            if (value.indexOf(46) != -1) {
                try {
                    Double.parseDouble(value);
                    doQoute = false;
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (value.length() > 0 && (Character.isDigit(ch = value.charAt(0)) || ch == '-' && value.length() > 1 && Character.isDigit(value.charAt(1)))) {
                try {
                    Integer.parseInt(value);
                    doQoute = false;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (doQoute) {
                value = "\"" + AS3InterfaceDumper.quote(value) + "\"";
            }
        }
        return value;
    }

    private static boolean needsQuoting(String value) {
        return !doNotNeedQoting.contains(value);
    }

    @Override
    public boolean doDumpMetaData(@NotNull MetaData md) {
        if (md == null) {
            AS3InterfaceDumper.$$$reportNull$$$0(5);
        }
        return md.name.indexOf("__") == -1;
    }

    @Override
    public void processParameter(@NotNull String name, @Nullable Multiname type, String parentName, @Nullable Multiname value, boolean rest) {
        if (name == null) {
            AS3InterfaceDumper.$$$reportNull$$$0(6);
        }
        if (rest) {
            this.append("... ");
            this.append(name);
        } else {
            this.append(name);
            this.append(":");
            this.dumpTypeRef(type, parentName, true);
            if (value != null) {
                this.processValue(type, value);
            }
        }
    }

    @Override
    protected void dumpTypeRef(Multiname name, String parentName, boolean referenceNameRequested) {
        this.myDumpTypeRef = true;
        super.dumpTypeRef(name, parentName, referenceNameRequested);
        this.myDumpTypeRef = false;
    }

    @Override
    public boolean doStarTypeDumpInExtends() {
        return false;
    }

    @Override
    public boolean doStarMetaAttrNameDump() {
        return false;
    }

    @Override
    public void setProcessingInterface(boolean anInterface) {
        this.isInterface = anInterface;
    }

    @Override
    public void hasError(@NotNull String error) {
        if (error == null) {
            AS3InterfaceDumper.$$$reportNull$$$0(7);
        }
        this.sb.append("/*" + error + "*/");
    }

    @Override
    public void processMultinameAsPackageName(Multiname name, String parentName) {
        this.append(this.getMultinameAsPackageName(name, parentName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getTypeRef(Multiname name, String parentName) {
        try {
            this.myDumpTypeRef = true;
            String string = this.getMultinameAsPackageName(name, parentName);
            return string;
        }
        finally {
            this.myDumpTypeRef = false;
        }
    }

    protected String getMultinameAsPackageName(Multiname name, String parentName) {
        if (name.nsset == null || name.nsset.length == 1 && name.nsset[0].equals("")) {
            return name.name;
        }
        String validNsName = name.getValidNsName(this.classNameTable);
        int prefLength = "::".length();
        if (Multiname.hasNamespace(validNsName) || parentName != null && parentName.regionMatches(0, validNsName, 0, validNsName.length()) && parentName.regionMatches(validNsName.length(), "::", 0, prefLength) && parentName.regionMatches(validNsName.length() + prefLength, name.name, 0, name.name.length()) && parentName.length() == validNsName.length() + prefLength + name.name.length()) {
            return name.name;
        }
        if (parentName != null && !this.myDumpTypeRef && AS3InterfaceDumper.willDumpNsName(name, parentName, false, false, AS3InterfaceDumper.isTopLevelObject(parentName), validNsName)) {
            return name.name;
        }
        return validNsName + "." + name.name;
    }

    @Override
    protected String appendModifiers(MemberInfo member, String attr) {
        String s = attr;
        s = s + "native ";
        String nsName = member.name.getNsName(member);
        if (nsName != null && nsName.length() > 0) {
            s = s + nsName + " ";
        }
        if (member.isFinal) {
            s = s + "final ";
        }
        if (member.isOverride) {
            s = s + "override ";
        }
        return s;
    }

    private static boolean isTopLevelObject(String parentName) {
        return parentName != null ? parentName.startsWith("script") : false;
    }

    private static boolean willDumpNsName(Multiname name, String parentName, boolean memberInParentNs, boolean constructor, boolean topLevelObject, String nsName) {
        return name != null && name.hasNotEmptyNs() && parentName != null && (!constructor && !topLevelObject && !memberInParentNs || nsName.indexOf("private") != -1);
    }

    @Override
    public void processFunction(MethodInfo methodInfo, boolean referenceNameRequested, Abc abc, String indent, String attr) {
        super.processFunction(methodInfo, referenceNameRequested, abc, indent, attr);
        this.append(";\n");
    }

    @Override
    public void processVariable(SlotInfo info, String indent, String attr) {
        super.processVariable(info, indent, attr);
        this.append(";\n");
    }

    @Override
    protected boolean dumpRestParameter() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stat";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "abc";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "md";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/flex/importer/AS3InterfaceDumper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "dumpStat";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "dumpToplevelAnonymousMethod";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "dumpTopLevelTraits";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doDumpMember";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "doDumpMetaData";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "processParameter";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "hasError";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

