/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.library;

import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.library.JSPredefinedLibraryProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionScriptLibraryProvider
extends JSPredefinedLibraryProvider {
    private static final Logger LOG = Logger.getInstance(ActionScriptLibraryProvider.class);
    private static final Map<String, Ref<VirtualFile>> ourLibFileCache = ContainerUtil.newConcurrentMap();
    private static final String[] ourActionScriptLibraries = new String[]{"ECMAScript.js2", "E4X.js2"};

    @Nullable
    private static VirtualFile getPredefinedLibFile(@NotNull String libFileName) {
        Ref<VirtualFile> fileRef;
        if (libFileName == null) {
            ActionScriptLibraryProvider.$$$reportNull$$$0(0);
        }
        if ((fileRef = ActionScriptLibraryProvider.getCachedFileRef(libFileName)) != null) {
            return (VirtualFile)fileRef.get();
        }
        VirtualFile file = ActionScriptLibraryProvider.findFileByURL(libFileName);
        return JSLibraryUtil.cacheFile((String)libFileName, (VirtualFile)file, ourLibFileCache);
    }

    private static VirtualFile findFileByURL(String libFileName) {
        URL libFileUrl = ActionScriptLibraryProvider.class.getResource(libFileName);
        if (libFileUrl == null) {
            LOG.error("Cannot find " + libFileName + ", the installation is possibly broken.");
            return null;
        }
        VirtualFile file = VfsUtil.findFileByURL((URL)libFileUrl);
        if (file != null && file.isValid()) {
            return file;
        }
        LOG.warn("Cannot find virtual file " + libFileName + " by url " + libFileUrl.toExternalForm());
        return null;
    }

    @Nullable
    private static Ref<VirtualFile> getCachedFileRef(@NotNull String fileName) {
        Ref<VirtualFile> ref;
        VirtualFile file;
        if (fileName == null) {
            ActionScriptLibraryProvider.$$$reportNull$$$0(1);
        }
        VirtualFile virtualFile = file = (ref = ourLibFileCache.get(fileName)) != null ? (VirtualFile)ref.get() : null;
        if (file != null && !file.isValid()) {
            ourLibFileCache.remove(fileName);
            ref = null;
        }
        return ref;
    }

    @NotNull
    public static Set<VirtualFile> getActionScriptPredefinedLibraryFiles() {
        java.util.HashSet files = ContainerUtil.newHashSet((int)ourActionScriptLibraries.length);
        for (String fileName : ourActionScriptLibraries) {
            ContainerUtil.addIfNotNull((Collection)files, (Object)ActionScriptLibraryProvider.getPredefinedLibFile(fileName));
        }
        java.util.HashSet hashSet = files;
        if (hashSet == null) {
            ActionScriptLibraryProvider.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    @NotNull
    public Set<VirtualFile> getRequiredLibraryFilesToIndex() {
        HashSet libFiles = new HashSet();
        libFiles.addAll(ActionScriptLibraryProvider.getActionScriptPredefinedLibraryFiles());
        HashSet hashSet = libFiles;
        if (hashSet == null) {
            ActionScriptLibraryProvider.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libFileName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flex/library/ActionScriptLibraryProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flex/library/ActionScriptLibraryProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionScriptPredefinedLibraryFiles";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredLibraryFilesToIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPredefinedLibFile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCachedFileRef";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

