/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.presentation;

import com.intellij.diagnostic.LogMessageEx;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.SelectableTreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.javascript.flex.FlexApplicationComponent;
import com.intellij.lang.javascript.ActionScriptFileType;
import com.intellij.lang.javascript.flex.presentation.SwfPackageElementNode;
import com.intellij.lang.javascript.flex.presentation.SwfQualifiedNamedElementNode;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSQualifiedElementIndex;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SwfProjectViewStructureProvider
implements SelectableTreeStructureProvider,
DumbAware {
    private static final Logger LOG = Logger.getInstance((String)SwfProjectViewStructureProvider.class.getName());
    private static final int MAX_TOTAL_SWFS_SIZE_IN_FOLDER_TO_SHOW_STRUCTURE = 0x500000;
    private static final Comparator<JSQualifiedNamedElement> QNAME_COMPARATOR = (o1, o2) -> {
        String qName = o1.getQualifiedName();
        String qName2 = o2.getQualifiedName();
        if (qName == null || qName2 == null) {
            return qName == null && qName2 == null ? 0 : (qName != null ? 1 : -1);
        }
        String[] tokens1 = qName.split("\\.");
        String[] tokens2 = qName2.split("\\.");
        for (int i = 0; i < tokens1.length && i < tokens2.length; ++i) {
            int result = tokens1[i].compareTo(tokens2[i]);
            if (result == 0) continue;
            if (i == tokens1.length - 1 && i != tokens2.length - 1) {
                return -1;
            }
            if (i != tokens1.length - 1 && i == tokens2.length - 1) {
                return 1;
            }
            return result;
        }
        return 0;
    };

    public PsiElement getTopLevelElement(PsiElement element) {
        JSQualifiedNamedElement parent = (JSQualifiedNamedElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{JSClass.class, JSFunction.class, JSVariable.class, JSNamespaceDeclaration.class});
        if (parent != null) {
            PsiElement fromLibrary;
            VirtualFile vFile;
            PsiFile file = parent.getContainingFile();
            if (file != null && (ActionScriptFileType.INSTANCE == file.getFileType() || FlexApplicationComponent.MXML == file.getFileType()) && (vFile = file.getVirtualFile()) != null && ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex().isInLibrarySource(vFile) && (fromLibrary = SwfProjectViewStructureProvider.findDecompiledElement(parent)) != null) {
                return fromLibrary;
            }
            return parent;
        }
        return null;
    }

    static boolean nodeContainsFile(ProjectViewNode node, VirtualFile file) {
        AbstractTreeNode parent = node.getParent();
        while (parent instanceof SwfPackageElementNode) {
            parent = parent.getParent();
        }
        return ((PsiFileNode)parent).contains(file);
    }

    @Nullable
    private static PsiElement findDecompiledElement(JSQualifiedNamedElement element) {
        String qName;
        if (DumbService.isDumb((Project)element.getProject())) {
            return null;
        }
        JSClass mainElement = JSUtils.getMemberContainingClass((PsiElement)element);
        if (mainElement == null) {
            mainElement = element;
        }
        if ((qName = mainElement.getQualifiedName()) == null) {
            return null;
        }
        VirtualFile elementVFile = mainElement.getContainingFile().getVirtualFile();
        if (elementVFile == null) {
            return null;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)mainElement.getProject()).getFileIndex();
        GlobalSearchScope searchScope = JSResolveUtil.getResolveScope((PsiElement)mainElement);
        Collection candidates = StubIndex.getElements((StubIndexKey)JSQualifiedElementIndex.KEY, (Object)qName.hashCode(), (Project)mainElement.getProject(), (GlobalSearchScope)searchScope, JSQualifiedNamedElement.class);
        List sourceFileEntries = projectFileIndex.getOrderEntriesForFile(elementVFile);
        for (JSQualifiedNamedElement candidate : candidates) {
            List candidateEntries;
            VirtualFile vFile;
            if (candidate == mainElement || !qName.equals(candidate.getQualifiedName()) || (vFile = candidate.getContainingFile().getVirtualFile()) == null || projectFileIndex.getClassRootForFile(vFile) == null || !ContainerUtil.intersects((Collection)sourceFileEntries, (Collection)(candidateEntries = projectFileIndex.getOrderEntriesForFile(vFile)))) continue;
            if (element == mainElement) {
                return candidate;
            }
            LOG.assertTrue(candidate instanceof JSClass, (Object)candidate);
            if (element instanceof JSVariable) {
                return ((JSClass)candidate).findFieldByName(element.getName());
            }
            LOG.assertTrue(element instanceof JSFunction, (Object)element);
            return ((JSClass)candidate).findFunctionByNameAndKind(element.getName(), ((JSFunction)element).getKind());
        }
        return null;
    }

    @NotNull
    public Collection<AbstractTreeNode> modify(@NotNull AbstractTreeNode parent, @NotNull Collection<AbstractTreeNode> children, ViewSettings settings) {
        if (parent == null) {
            SwfProjectViewStructureProvider.$$$reportNull$$$0(0);
        }
        if (children == null) {
            SwfProjectViewStructureProvider.$$$reportNull$$$0(1);
        }
        if (!(parent instanceof PsiFileNode)) {
            Collection<AbstractTreeNode> collection = children;
            if (collection == null) {
                SwfProjectViewStructureProvider.$$$reportNull$$$0(2);
            }
            return collection;
        }
        PsiFile psiFile = (PsiFile)((PsiFileNode)parent).getValue();
        if (!(psiFile instanceof PsiCompiledFile) || !(psiFile instanceof JSFile)) {
            Collection<AbstractTreeNode> collection = children;
            if (collection == null) {
                SwfProjectViewStructureProvider.$$$reportNull$$$0(3);
            }
            return collection;
        }
        VirtualFile vFile = psiFile.getVirtualFile();
        if (vFile == null || vFile.getFileType() != FlexApplicationComponent.SWF_FILE_TYPE) {
            Collection<AbstractTreeNode> collection = children;
            if (collection == null) {
                SwfProjectViewStructureProvider.$$$reportNull$$$0(4);
            }
            return collection;
        }
        if (SwfProjectViewStructureProvider.isTooManySWFs(vFile.getParent())) {
            Collection<AbstractTreeNode> collection = children;
            if (collection == null) {
                SwfProjectViewStructureProvider.$$$reportNull$$$0(5);
            }
            return collection;
        }
        ArrayList<JSQualifiedNamedElement> elements = new ArrayList<JSQualifiedNamedElement>();
        for (JSSourceElement e : ((JSFile)psiFile).getStatements()) {
            if (e instanceof JSQualifiedNamedElement) {
                String qName = ((JSQualifiedNamedElement)e).getQualifiedName();
                if (qName == null) {
                    Attachment attachment = e.getParent() != null ? new Attachment("Parent element.txt", e.getParent().getText()) : new Attachment("Element text.txt", e.getText());
                    LOG.error((Object)LogMessageEx.createEvent((String)("Null qname: '" + e.getClass().getName() + "'"), (String)DebugUtil.currentStackTrace(), (Attachment[])new Attachment[]{attachment}));
                    continue;
                }
                elements.add((JSQualifiedNamedElement)e);
                continue;
            }
            if (!(e instanceof JSVarStatement)) continue;
            Collections.addAll(elements, ((JSVarStatement)e).getVariables());
        }
        Collections.sort(elements, QNAME_COMPARATOR);
        Collection<AbstractTreeNode> collection = SwfProjectViewStructureProvider.getChildrenForPackage("", elements, 0, elements.size(), psiFile.getProject(), ((PsiFileNode)parent).getSettings());
        if (collection == null) {
            SwfProjectViewStructureProvider.$$$reportNull$$$0(6);
        }
        return collection;
    }

    private static boolean isTooManySWFs(VirtualFile folder) {
        int size = 0;
        for (VirtualFile file : folder.getChildren()) {
            if (file.getFileType() != FlexApplicationComponent.SWF_FILE_TYPE || (size = (int)((long)size + file.getLength())) <= 0x500000) continue;
            return true;
        }
        return false;
    }

    static Collection<AbstractTreeNode> getChildrenForPackage(String aPackage, List<JSQualifiedNamedElement> elements, int from, int to, Project project, ViewSettings settings) {
        ArrayList<SwfPackageElementNode> packages = new ArrayList<SwfPackageElementNode>();
        ArrayList<SwfQualifiedNamedElementNode> classes = new ArrayList<SwfQualifiedNamedElementNode>();
        int subpackageStart = -1;
        String currentSubpackage = null;
        for (int i = from; i < to; ++i) {
            String subpackage;
            JSQualifiedNamedElement element = elements.get(i);
            String qName = element.getQualifiedName();
            assert (aPackage.isEmpty() || qName.startsWith(aPackage + ".")) : qName + " does not start with " + aPackage;
            if (StringUtil.getPackageName((String)qName).equals(aPackage)) {
                classes.add(new SwfQualifiedNamedElementNode(project, element, settings));
                continue;
            }
            int endIndex = qName.indexOf(46, aPackage.length() + 1);
            if (endIndex <= 0) {
                Attachment attachment = element.getParent() != null ? new Attachment("Parent element.txt", element.getParent().getText()) : new Attachment("Element text.txt", element.getText());
                LOG.error((Object)LogMessageEx.createEvent((String)("package=[" + aPackage + "], qName=[" + qName + "]"), (String)DebugUtil.currentStackTrace(), (Attachment[])new Attachment[]{attachment}));
                continue;
            }
            String string = subpackage = settings.isFlattenPackages() ? StringUtil.getPackageName((String)qName) : qName.substring(0, endIndex);
            if (currentSubpackage == null) {
                subpackageStart = i;
            } else if (!currentSubpackage.equals(subpackage)) {
                packages.add(SwfProjectViewStructureProvider.createSubpackageNode(elements, project, settings, subpackageStart, i, currentSubpackage));
                subpackageStart = i;
            }
            currentSubpackage = subpackage;
        }
        if (currentSubpackage != null) {
            packages.add(SwfProjectViewStructureProvider.createSubpackageNode(elements, project, settings, subpackageStart, to, currentSubpackage));
        }
        return ContainerUtil.concat(packages, classes);
    }

    private static SwfPackageElementNode createSubpackageNode(List<JSQualifiedNamedElement> elements, Project project, ViewSettings settings, int from, int to, String qName) {
        String subQname;
        if (settings.isFlattenPackages()) {
            return new SwfPackageElementNode(project, qName, qName, settings, elements, from, to);
        }
        if (settings.isHideEmptyMiddlePackages() && (subQname = SwfProjectViewStructureProvider.getEmptyMiddlePackageQname(elements, from, to, qName)) != null) {
            String displayText = qName.contains(".") ? subQname.substring(StringUtil.getPackageName((String)qName).length() + 1) : subQname;
            return new SwfPackageElementNode(project, subQname, displayText, settings, elements, from, to);
        }
        return new SwfPackageElementNode(project, qName, StringUtil.getShortName((String)qName), settings, elements, from, to);
    }

    @Nullable
    private static String getEmptyMiddlePackageQname(List<JSQualifiedNamedElement> elements, int from, int to, String packageName) {
        if (from == to) {
            return null;
        }
        String currentSubpackage = null;
        for (int i = from; i < to; ++i) {
            String qName = elements.get(i).getQualifiedName();
            int index = qName.indexOf(46, packageName.length() + 1);
            if (index == -1) {
                return null;
            }
            String subpackage = qName.substring(0, index);
            if (currentSubpackage == null) {
                currentSubpackage = subpackage;
                continue;
            }
            if (currentSubpackage.equals(subpackage)) continue;
            return null;
        }
        String deeperSubpackage = SwfProjectViewStructureProvider.getEmptyMiddlePackageQname(elements, from, to, currentSubpackage);
        return deeperSubpackage != null ? deeperSubpackage : currentSubpackage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flex/presentation/SwfProjectViewStructureProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flex/presentation/SwfProjectViewStructureProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "modify";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "modify";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

