/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure;

import com.intellij.flex.FlexCommonUtils;
import com.intellij.flex.model.bc.LinkageType;
import com.intellij.flex.model.bc.OutputType;
import com.intellij.lang.javascript.flex.FlexModuleType;
import com.intellij.lang.javascript.flex.library.FlexLibraryType;
import com.intellij.lang.javascript.flex.projectStructure.model.BuildConfigurationEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.DependencyEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfigurationManager;
import com.intellij.lang.javascript.flex.projectStructure.options.BCUtils;
import com.intellij.lang.javascript.flex.projectStructure.options.FlexProjectRootsUtil;
import com.intellij.lang.javascript.flex.sdk.FlexSdkType2;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import com.intellij.openapi.roots.OrderEnumeratorSettings;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexOrderEnumerationHandler
extends OrderEnumerationHandler {
    public static Key<FlexBuildConfiguration> FORCE_BC = Key.create((String)(FlexOrderEnumerationHandler.class.getName() + ".forceBc"));
    @Nullable
    private final Map<Module, ModuleData> myActiveConfigurations;
    private final Module myRootModule;

    public FlexOrderEnumerationHandler(@NotNull Module module) {
        if (module == null) {
            FlexOrderEnumerationHandler.$$$reportNull$$$0(0);
        }
        this.myRootModule = module;
        this.myActiveConfigurations = new HashMap<Module, ModuleData>();
        FlexOrderEnumerationHandler.processModuleWithBuildConfiguration(module, null, this.myActiveConfigurations, new HashSet<FlexBuildConfiguration>(), true);
    }

    private static void processModuleWithBuildConfiguration(@NotNull Module module, @Nullable FlexBuildConfiguration bc, Map<Module, ModuleData> modules2activeConfigurations, Set<FlexBuildConfiguration> processedConfigurations, boolean productionDependency) {
        boolean isRootModule;
        if (module == null) {
            FlexOrderEnumerationHandler.$$$reportNull$$$0(1);
        }
        if (ModuleType.get((Module)module) != FlexModuleType.getInstance()) {
            return;
        }
        boolean bl = isRootModule = bc == null;
        if (isRootModule) {
            bc = FlexOrderEnumerationHandler.getActiveConfiguration(module);
        }
        if (bc == null || !processedConfigurations.add(bc)) {
            return;
        }
        ModuleData moduleData = modules2activeConfigurations.get(module);
        if (moduleData == null) {
            moduleData = new ModuleData();
            modules2activeConfigurations.put(module, moduleData);
        }
        moduleData.addBc(bc, productionDependency);
        for (DependencyEntry entry : bc.getDependencies().getEntries()) {
            Module dependencyModule;
            FlexBuildConfiguration dependencyBc;
            LinkageType linkageType;
            if (!(entry instanceof BuildConfigurationEntry) || (linkageType = entry.getDependencyType().getLinkageType()) == LinkageType.LoadInRuntime || (dependencyBc = ((BuildConfigurationEntry)entry).findBuildConfiguration()) == null || !FlexCommonUtils.checkDependencyType((OutputType)bc.getOutputType(), (OutputType)dependencyBc.getOutputType(), (LinkageType)linkageType) || !isRootModule && !BCUtils.isTransitiveDependency(linkageType) || (dependencyModule = ((BuildConfigurationEntry)entry).findModule()) == null || dependencyModule == module) continue;
            FlexOrderEnumerationHandler.processModuleWithBuildConfiguration(dependencyModule, dependencyBc, modules2activeConfigurations, processedConfigurations, entry.getDependencyType().getLinkageType() != LinkageType.Test);
        }
    }

    private static FlexBuildConfiguration getActiveConfiguration(Module module) {
        FlexBuildConfiguration forced = (FlexBuildConfiguration)FORCE_BC.get((UserDataHolder)module);
        return forced != null ? forced : FlexBuildConfigurationManager.getInstance(module).getActiveConfiguration();
    }

    @NotNull
    public OrderEnumerationHandler.AddDependencyType shouldAddDependency(@NotNull OrderEntry orderEntry, @NotNull OrderEnumeratorSettings settings) {
        ModuleData moduleData;
        Module module;
        if (orderEntry == null) {
            FlexOrderEnumerationHandler.$$$reportNull$$$0(2);
        }
        if (settings == null) {
            FlexOrderEnumerationHandler.$$$reportNull$$$0(3);
        }
        if (ModuleType.get((Module)(module = orderEntry.getOwnerModule())) != FlexModuleType.getInstance()) {
            OrderEnumerationHandler.AddDependencyType addDependencyType = super.shouldAddDependency(orderEntry, settings);
            if (addDependencyType == null) {
                FlexOrderEnumerationHandler.$$$reportNull$$$0(4);
            }
            return addDependencyType;
        }
        if (orderEntry instanceof ModuleSourceOrderEntry) {
            OrderEnumerationHandler.AddDependencyType addDependencyType = OrderEnumerationHandler.AddDependencyType.DEFAULT;
            if (addDependencyType == null) {
                FlexOrderEnumerationHandler.$$$reportNull$$$0(5);
            }
            return addDependencyType;
        }
        if (orderEntry instanceof JdkOrderEntry) {
            if (module != this.myRootModule) {
                OrderEnumerationHandler.AddDependencyType addDependencyType = OrderEnumerationHandler.AddDependencyType.DO_NOT_ADD;
                if (addDependencyType == null) {
                    FlexOrderEnumerationHandler.$$$reportNull$$$0(6);
                }
                return addDependencyType;
            }
            if (this.myActiveConfigurations == null) {
                OrderEnumerationHandler.AddDependencyType addDependencyType = OrderEnumerationHandler.AddDependencyType.DEFAULT;
                if (addDependencyType == null) {
                    FlexOrderEnumerationHandler.$$$reportNull$$$0(7);
                }
                return addDependencyType;
            }
            ModuleData moduleData2 = this.myActiveConfigurations.get(module);
            for (FlexBuildConfiguration bc : moduleData2.bcs) {
                if (bc.getSdk() == null) continue;
                OrderEnumerationHandler.AddDependencyType addDependencyType = OrderEnumerationHandler.AddDependencyType.DEFAULT;
                if (addDependencyType == null) {
                    FlexOrderEnumerationHandler.$$$reportNull$$$0(8);
                }
                return addDependencyType;
            }
            OrderEnumerationHandler.AddDependencyType addDependencyType = OrderEnumerationHandler.AddDependencyType.DO_NOT_ADD;
            if (addDependencyType == null) {
                FlexOrderEnumerationHandler.$$$reportNull$$$0(9);
            }
            return addDependencyType;
        }
        Collection<Object> accessibleConfigurations = this.myActiveConfigurations != null ? ((moduleData = this.myActiveConfigurations.get(module)) != null ? moduleData.bcs : Collections.emptyList()) : Arrays.asList(FlexBuildConfigurationManager.getInstance(module).getBuildConfigurations());
        if (orderEntry instanceof LibraryOrderEntry) {
            LibraryEx library = (LibraryEx)((LibraryOrderEntry)orderEntry).getLibrary();
            if (library == null) {
                OrderEnumerationHandler.AddDependencyType addDependencyType = OrderEnumerationHandler.AddDependencyType.DEFAULT;
                if (addDependencyType == null) {
                    FlexOrderEnumerationHandler.$$$reportNull$$$0(10);
                }
                return addDependencyType;
            }
            if (library.getKind() == FlexLibraryType.FLEX_LIBRARY) {
                OrderEnumerationHandler.AddDependencyType addDependencyType = FlexProjectRootsUtil.dependOnLibrary(accessibleConfigurations, (Library)library, module != this.myRootModule, settings.isProductionOnly()) ? OrderEnumerationHandler.AddDependencyType.DEFAULT : OrderEnumerationHandler.AddDependencyType.DO_NOT_ADD;
                if (addDependencyType == null) {
                    FlexOrderEnumerationHandler.$$$reportNull$$$0(11);
                }
                return addDependencyType;
            }
            OrderEnumerationHandler.AddDependencyType addDependencyType = OrderEnumerationHandler.AddDependencyType.DO_NOT_ADD;
            if (addDependencyType == null) {
                FlexOrderEnumerationHandler.$$$reportNull$$$0(12);
            }
            return addDependencyType;
        }
        if (orderEntry instanceof ModuleOrderEntry) {
            Module dependencyModule = ((ModuleOrderEntry)orderEntry).getModule();
            if (dependencyModule == null) {
                OrderEnumerationHandler.AddDependencyType addDependencyType = OrderEnumerationHandler.AddDependencyType.DO_NOT_ADD;
                if (addDependencyType == null) {
                    FlexOrderEnumerationHandler.$$$reportNull$$$0(13);
                }
                return addDependencyType;
            }
            if (this.myActiveConfigurations != null) {
                ModuleData moduleData3 = this.myActiveConfigurations.get(dependencyModule);
                OrderEnumerationHandler.AddDependencyType addDependencyType = moduleData3 != null && (moduleData3.accessibleInProduction || !settings.isProductionOnly()) ? OrderEnumerationHandler.AddDependencyType.DEFAULT : OrderEnumerationHandler.AddDependencyType.DO_NOT_ADD;
                if (addDependencyType == null) {
                    FlexOrderEnumerationHandler.$$$reportNull$$$0(14);
                }
                return addDependencyType;
            }
            OrderEnumerationHandler.AddDependencyType addDependencyType = OrderEnumerationHandler.AddDependencyType.DEFAULT;
            if (addDependencyType == null) {
                FlexOrderEnumerationHandler.$$$reportNull$$$0(15);
            }
            return addDependencyType;
        }
        OrderEnumerationHandler.AddDependencyType addDependencyType = OrderEnumerationHandler.AddDependencyType.DEFAULT;
        if (addDependencyType == null) {
            FlexOrderEnumerationHandler.$$$reportNull$$$0(16);
        }
        return addDependencyType;
    }

    public boolean addCustomRootsForLibrary(@NotNull OrderEntry forOrderEntry, @NotNull OrderRootType type, @NotNull Collection<String> urls) {
        if (forOrderEntry == null) {
            FlexOrderEnumerationHandler.$$$reportNull$$$0(17);
        }
        if (type == null) {
            FlexOrderEnumerationHandler.$$$reportNull$$$0(18);
        }
        if (urls == null) {
            FlexOrderEnumerationHandler.$$$reportNull$$$0(19);
        }
        if (!(forOrderEntry instanceof JdkOrderEntry)) {
            return false;
        }
        if (this.myActiveConfigurations == null) {
            return false;
        }
        Module forModule = forOrderEntry.getOwnerModule();
        FlexBuildConfiguration bc = FlexOrderEnumerationHandler.getActiveConfiguration(forModule);
        Sdk sdk = bc.getSdk();
        if (sdk == null || sdk.getSdkType() != FlexSdkType2.getInstance()) {
            return false;
        }
        Object[] allUrls = sdk.getRootProvider().getUrls(type);
        if (type != OrderRootType.CLASSES) {
            urls.addAll(Arrays.asList(allUrls));
            return true;
        }
        List<String> themePaths = BCUtils.getThemes(forModule, bc);
        List allAccessibleUrls = ContainerUtil.filter((Object[])allUrls, s -> BCUtils.getSdkEntryLinkageType(s = VirtualFileManager.extractPath((String)StringUtil.trimEnd((String)s, (String)"!/")), bc) != null || themePaths.contains(s));
        urls.addAll(new HashSet(allAccessibleUrls));
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntry";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flex/projectStructure/FlexOrderEnumerationHandler";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forOrderEntry";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flex/projectStructure/FlexOrderEnumerationHandler";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "shouldAddDependency";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processModuleWithBuildConfiguration";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddDependency";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addCustomRootsForLibrary";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ModuleData {
        private Set<FlexBuildConfiguration> bcs = new HashSet<FlexBuildConfiguration>();
        private boolean accessibleInProduction = false;

        private ModuleData() {
        }

        public void addBc(FlexBuildConfiguration bc, boolean production) {
            this.bcs.add(bc);
            this.accessibleInProduction |= production;
        }
    }

    public static class FactoryImpl
    extends OrderEnumerationHandler.Factory {
        public boolean isApplicable(@NotNull Module module) {
            if (module == null) {
                FactoryImpl.$$$reportNull$$$0(0);
            }
            return ModuleType.get((Module)module) == FlexModuleType.getInstance();
        }

        public OrderEnumerationHandler createHandler(@NotNull Module module) {
            if (module == null) {
                FactoryImpl.$$$reportNull$$$0(1);
            }
            return new FlexOrderEnumerationHandler(module);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "module";
            objectArray2[1] = "com/intellij/lang/javascript/flex/projectStructure/FlexOrderEnumerationHandler$FactoryImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isApplicable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createHandler";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

