/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.appengine.facet;

import com.intellij.appengine.sdk.AppEngineSdk;
import com.intellij.appengine.sdk.AppEngineSdkManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.ComboboxWithBrowseButton;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class AppEngineSdkEditor {
    private ComboboxWithBrowseButton myPathEditor = new ComboboxWithBrowseButton((JComboBox)new ComboBox(100));

    public AppEngineSdkEditor(@Nullable Project project) {
        this.myPathEditor.addActionListener((ActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener("Google App Engine SDK", "Specify Google App Engine Java SDK home", (ComponentWithBrowseButton)this.myPathEditor, project, FileChooserDescriptorFactory.createSingleFolderDescriptor(), TextComponentAccessor.STRING_COMBOBOX_WHOLE_TEXT));
        JComboBox comboBox = this.myPathEditor.getComboBox();
        comboBox.setEditable(true);
        comboBox.removeAllItems();
        for (AppEngineSdk appEngineSdk : AppEngineSdkManager.getInstance().getValidSdks()) {
            comboBox.addItem(FileUtil.toSystemDependentName((String)appEngineSdk.getSdkHomePath()));
        }
    }

    public JPanel getMainComponent() {
        return this.myPathEditor;
    }

    public String getPath() {
        return FileUtil.toSystemIndependentName((String)((String)this.myPathEditor.getComboBox().getEditor().getItem()));
    }

    public void setPath(String path) {
        this.myPathEditor.getComboBox().setSelectedItem(FileUtil.toSystemDependentName((String)path));
    }

    public void setDefaultPath() {
        JComboBox comboBox = this.myPathEditor.getComboBox();
        if (comboBox.getItemCount() > 0) {
            comboBox.setSelectedIndex(0);
        }
    }

    public JComboBox getComboBox() {
        return this.myPathEditor.getComboBox();
    }
}

