/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jetty.server;

import com.intellij.javaee.oss.jetty.common.PathResolver;
import com.intellij.javaee.oss.jetty.server.JettyConfigFile;
import com.intellij.javaee.oss.jetty.server.JettyConfigFilesEditor;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public abstract class JettyConfigFilesCollector {
    private final Map<String, JettyConfigFile> myPath2configFiles;
    private final String myHome;
    private final String myWorkDir;

    public JettyConfigFilesCollector(String home, String workDir, @Nullable List<JettyConfigFile> configFiles, String allowedExtension) {
        this.myHome = home;
        this.myWorkDir = workDir;
        this.myPath2configFiles = new LinkedHashMap<String, JettyConfigFile>();
        if (configFiles != null) {
            for (JettyConfigFile configFile : configFiles) {
                if (!configFile.getPath().endsWith(allowedExtension)) continue;
                this.myPath2configFiles.put(configFile.getPath(), configFile);
            }
        }
    }

    public void scanDir() {
        File[] configFiles = this.doScanDir();
        if (configFiles == null) {
            return;
        }
        PathResolver pathResolver = new PathResolver(new File(this.getHome()));
        for (File etcConfigFile : configFiles) {
            this.getOrCreateConfigFile(pathResolver.path2Relative(etcConfigFile));
        }
    }

    protected JettyConfigFile getOrCreateConfigFile(String path) {
        JettyConfigFile result = this.myPath2configFiles.get(path);
        if (result == null) {
            result = new JettyConfigFile(path);
            this.myPath2configFiles.put(path, result);
        }
        return result;
    }

    public void updateEditor(JettyConfigFilesEditor configFilesEditor) {
        configFilesEditor.setHome(new File(this.myHome));
        configFilesEditor.setFiles(this.myPath2configFiles.values());
    }

    public void addPaths(List<String> configFilePaths) {
        for (String path : configFilePaths) {
            this.getOrCreateConfigFile(path);
        }
    }

    protected String getHome() {
        return this.myHome;
    }

    protected String getWorkDir() {
        return this.myWorkDir;
    }

    protected abstract File[] doScanDir();

    public abstract void scanIni();
}

