/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.gradle.project.ProjectImportUtil;
import com.android.tools.idea.gradle.project.importing.GradleProjectImporter;
import com.android.tools.idea.gradle.util.Projects;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.ide.actions.OpenProjectFileChooserDescriptor;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.fileChooser.impl.FileChooserUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.welcomeScreen.NewWelcomeScreen;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.projectImport.ProjectAttachProcessor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidOpenFileAction
extends DumbAwareAction {
    public AndroidOpenFileAction() {
        this("Open...");
    }

    public AndroidOpenFileAction(@NotNull String text) {
        if (text == null) {
            AndroidOpenFileAction.$$$reportNull$$$0(0);
        }
        super(text);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AndroidOpenFileAction.$$$reportNull$$$0(1);
        }
        if (NewWelcomeScreen.isNewWelcomeScreen((AnActionEvent)e)) {
            e.getPresentation().setIcon(AllIcons.Welcome.OpenProject);
        }
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        boolean showFiles = project != null || PlatformProjectOpenProcessor.getInstanceIfItExists() != null;
        OpenProjectFileChooserDescriptor descriptor = showFiles ? new ProjectOrFileChooserDescriptor() : new ProjectOnlyFileChooserDescriptor();
        descriptor.putUserData(PathChooserDialog.PREFER_LAST_OVER_EXPLICIT, (Object)showFiles);
        VirtualFile explicitPreferredDirectory = project != null && !project.isDefault() ? project.getBaseDir() : VfsUtil.getUserHomeDir();
        FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)project, (VirtualFile)explicitPreferredDirectory, arg_0 -> AndroidOpenFileAction.lambda$actionPerformed$0((FileChooserDescriptor)descriptor, project, arg_0));
    }

    private static void doOpenFile(@Nullable Project project, @NotNull List<VirtualFile> result) {
        if (result == null) {
            AndroidOpenFileAction.$$$reportNull$$$0(2);
        }
        for (VirtualFile file : result) {
            if (file.isDirectory()) {
                if (project != null && !project.isDefault() && file.equals(project.getBaseDir())) {
                    ProjectUtil.focusProjectWindow((Project)project, (boolean)false);
                    return;
                }
                if (ProjectAttachProcessor.canAttachToProject()) {
                    Project openedProject = PlatformProjectOpenProcessor.doOpenProject((VirtualFile)file, (Project)project, (boolean)false, (int)-1, null, (boolean)false);
                    FileChooserUtil.setLastOpenedFile((Project)openedProject, (VirtualFile)file);
                } else {
                    AndroidOpenFileAction.openOrImportProject(file, project);
                }
                return;
            }
            if ((project == null || !file.equals(project.getProjectFile())) && OpenProjectFileChooserDescriptor.isProjectFile((VirtualFile)file) && AndroidOpenFileAction.openOrImportProject(file, project)) {
                return;
            }
            FileType type = FileTypeChooser.getKnownFileTypeOrAssociate((VirtualFile)file, (Project)project);
            if (type == null) {
                return;
            }
            if (project != null) {
                OpenFileAction.openFile((VirtualFile)file, (Project)project);
                continue;
            }
            PlatformProjectOpenProcessor processor = PlatformProjectOpenProcessor.getInstanceIfItExists();
            if (processor == null) continue;
            processor.doOpenProject(file, null, false);
        }
    }

    private static boolean openOrImportProject(@NotNull VirtualFile file, @Nullable Project project) {
        VirtualFile target;
        if (file == null) {
            AndroidOpenFileAction.$$$reportNull$$$0(3);
        }
        if (Projects.canImportAsGradleProject(file) && (target = ProjectImportUtil.findImportTarget(file)) != null) {
            Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
            if (openProjects.length > 0) {
                int exitCode = ProjectUtil.confirmOpenNewProject((boolean)false);
                if (exitCode == 1) {
                    Project toClose;
                    Project project2 = toClose = project != null && !project.isDefault() ? project : openProjects[openProjects.length - 1];
                    if (!ProjectUtil.closeAndDispose((Project)toClose)) {
                        return false;
                    }
                } else if (exitCode != 0) {
                    return false;
                }
            }
            GradleProjectImporter gradleImporter = GradleProjectImporter.getInstance();
            gradleImporter.openProject(file);
            return true;
        }
        Project opened = ProjectUtil.openOrImport((String)file.getPath(), (Project)project, (boolean)false);
        if (opened != null) {
            FileChooserUtil.setLastOpenedFile((Project)opened, (VirtualFile)file);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void lambda$actionPerformed$0(FileChooserDescriptor descriptor, Project project, List files) {
        for (VirtualFile file : files) {
            if (descriptor.isFileSelectable(file)) continue;
            String message = IdeBundle.message((String)"error.dir.contains.no.project", (Object[])new Object[]{file.getPresentableUrl()});
            Messages.showInfoMessage((Project)project, (String)message, (String)IdeBundle.message((String)"title.cannot.open.project", (Object[])new Object[0]));
            return;
        }
        AndroidOpenFileAction.doOpenFile(project, files);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/actions/AndroidOpenFileAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doOpenFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "openOrImportProject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ProjectOrFileChooserDescriptor
    extends OpenProjectFileChooserDescriptor {
        private final FileChooserDescriptor myStandardDescriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withHideIgnored(false);

        public ProjectOrFileChooserDescriptor() {
            super(true);
            this.setTitle(IdeBundle.message((String)"title.open.file.or.project", (Object[])new Object[0]));
        }

        public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
            return file.isDirectory() ? super.isFileVisible(file, showHiddenFiles) : this.myStandardDescriptor.isFileVisible(file, showHiddenFiles);
        }

        public boolean isFileSelectable(VirtualFile file) {
            return file.isDirectory() ? super.isFileSelectable(file) : this.myStandardDescriptor.isFileSelectable(file);
        }

        public boolean isChooseMultiple() {
            return true;
        }
    }

    private static class ProjectOnlyFileChooserDescriptor
    extends OpenProjectFileChooserDescriptor {
        public ProjectOnlyFileChooserDescriptor() {
            super(true);
            this.setTitle(IdeBundle.message((String)"title.open.project", (Object[])new Object[0]));
        }
    }
}

