/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer;

import com.android.tools.idea.XmlBuilder;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.devrel.gmscore.tools.apk.arsc.BinaryResourceFile;
import com.google.devrel.gmscore.tools.apk.arsc.BinaryResourceValue;
import com.google.devrel.gmscore.tools.apk.arsc.Chunk;
import com.google.devrel.gmscore.tools.apk.arsc.StringPoolChunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlAttribute;
import com.google.devrel.gmscore.tools.apk.arsc.XmlChunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlEndElementChunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlNamespaceEndChunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlNamespaceStartChunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlResourceMapChunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlStartElementChunk;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinaryXmlParser {
    @NotNull
    public static byte[] decodeXml(@NotNull String fileName, @NotNull byte[] bytes) {
        BinaryResourceFile file;
        List chunks;
        if (fileName == null) {
            BinaryXmlParser.$$$reportNull$$$0(0);
        }
        if (bytes == null) {
            BinaryXmlParser.$$$reportNull$$$0(1);
        }
        if ((chunks = (file = new BinaryResourceFile(bytes)).getChunks()).size() != 1) {
            Logger.getInstance(BinaryXmlParser.class).warn("Expected 1, but got " + chunks.size() + " chunks while parsing " + fileName);
            if (bytes == null) {
                BinaryXmlParser.$$$reportNull$$$0(2);
            }
            return bytes;
        }
        if (!(chunks.get(0) instanceof XmlChunk)) {
            Logger.getInstance(BinaryXmlParser.class).warn("First chunk in " + fileName + " is not an XmlChunk: " + ((Chunk)chunks.get(0)).getClass().getCanonicalName());
            if (bytes == null) {
                BinaryXmlParser.$$$reportNull$$$0(3);
            }
            return bytes;
        }
        XmlPrinter printer = new XmlPrinter();
        XmlChunk xmlChunk = (XmlChunk)chunks.get(0);
        BinaryXmlParser.visitChunks(xmlChunk.getChunks(), printer);
        String reconstructedXml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n" + printer.getReconstructedXml();
        byte[] byArray = reconstructedXml.getBytes(Charsets.UTF_8);
        if (byArray == null) {
            BinaryXmlParser.$$$reportNull$$$0(4);
        }
        return byArray;
    }

    private static void visitChunks(@NotNull Map<Integer, Chunk> chunks, @NotNull XmlChunkHandler handler) {
        if (chunks == null) {
            BinaryXmlParser.$$$reportNull$$$0(5);
        }
        if (handler == null) {
            BinaryXmlParser.$$$reportNull$$$0(6);
        }
        List<Chunk> contentChunks = BinaryXmlParser.sortByOffset(chunks);
        for (Chunk chunk : contentChunks) {
            if (chunk instanceof StringPoolChunk) {
                handler.stringPool((StringPoolChunk)chunk);
                continue;
            }
            if (chunk instanceof XmlResourceMapChunk) {
                handler.xmlResourceMap((XmlResourceMapChunk)chunk);
                continue;
            }
            if (chunk instanceof XmlNamespaceStartChunk) {
                handler.startNamespace((XmlNamespaceStartChunk)chunk);
                continue;
            }
            if (chunk instanceof XmlNamespaceEndChunk) {
                handler.endNamespace((XmlNamespaceEndChunk)chunk);
                continue;
            }
            if (chunk instanceof XmlStartElementChunk) {
                handler.startElement((XmlStartElementChunk)chunk);
                continue;
            }
            if (chunk instanceof XmlEndElementChunk) {
                handler.endElement((XmlEndElementChunk)chunk);
                continue;
            }
            Logger.getInstance(BinaryXmlParser.class).warn("XmlNode of type " + chunk.getClass().getCanonicalName() + " not handled.");
        }
    }

    @NotNull
    private static List<Chunk> sortByOffset(Map<Integer, Chunk> contentChunks) {
        ArrayList offsets = Lists.newArrayList(contentChunks.keySet());
        Collections.sort(offsets);
        ArrayList<Chunk> chunks = new ArrayList<Chunk>(offsets.size());
        for (Integer offset : offsets) {
            chunks.add(contentChunks.get(offset));
        }
        ArrayList<Chunk> arrayList = chunks;
        if (arrayList == null) {
            BinaryXmlParser.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    public static String formatValue(@NotNull BinaryResourceValue resValue, @Nullable StringPoolChunk stringPool) {
        if (resValue == null) {
            BinaryXmlParser.$$$reportNull$$$0(8);
        }
        int data = resValue.data();
        switch (resValue.type()) {
            case NULL: {
                return "null";
            }
            case DYNAMIC_REFERENCE: {
                return String.format(Locale.US, "@dref/0x%1$08x", data);
            }
            case REFERENCE: {
                return String.format(Locale.US, "@ref/0x%1$08x", data);
            }
            case ATTRIBUTE: {
                return String.format(Locale.US, "@attr/0x%1$x", data);
            }
            case STRING: {
                return stringPool != null && stringPool.getStringCount() < data ? stringPool.getString(data) : String.format(Locale.US, "@string/0x%1$x", data);
            }
            case DIMENSION: {
                return String.format(Locale.US, "dimension(%1$d)", data);
            }
            case FRACTION: {
                return String.format(Locale.US, "fraction(%1$d)", data);
            }
            case FLOAT: {
                return String.format(Locale.US, "%f", Float.valueOf(data));
            }
            case INT_DEC: {
                return Integer.toString(data);
            }
            case INT_HEX: {
                return "0x" + Integer.toHexString(data);
            }
            case INT_BOOLEAN: {
                return Boolean.toString(data != 0);
            }
            case INT_COLOR_ARGB8: {
                return String.format("argb8(0x%x)", data);
            }
            case INT_COLOR_RGB8: {
                return String.format("rgb8(0x%x)", data);
            }
            case INT_COLOR_ARGB4: {
                return String.format("argb4(0x%x)", data);
            }
            case INT_COLOR_RGB4: {
                return String.format("rgb4(0x%x)", data);
            }
        }
        return String.format("@res/0x%x", data);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/apk/viewer/BinaryXmlParser";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunks";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/apk/viewer/BinaryXmlParser";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "decodeXml";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "sortByOffset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "decodeXml";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "visitChunks";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "formatValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class XmlPrinter
    implements XmlChunkHandler {
        private final XmlBuilder myBuilder;
        private Map<String, String> myNamespaces = new HashMap<String, String>();
        private boolean myNamespacesAdded;
        private StringPoolChunk myStringPool;

        public XmlPrinter() {
            this.myBuilder = new XmlBuilder();
        }

        @Override
        public void stringPool(@NotNull StringPoolChunk chunk) {
            if (chunk == null) {
                XmlPrinter.$$$reportNull$$$0(0);
            }
            this.myStringPool = chunk;
        }

        @Override
        public void startNamespace(@NotNull XmlNamespaceStartChunk chunk) {
            if (chunk == null) {
                XmlPrinter.$$$reportNull$$$0(1);
            }
            this.myNamespaces.put(chunk.getUri(), chunk.getPrefix());
        }

        @Override
        public void startElement(@NotNull XmlStartElementChunk chunk) {
            if (chunk == null) {
                XmlPrinter.$$$reportNull$$$0(2);
            }
            this.myBuilder.startTag(chunk.getName());
            if (!this.myNamespacesAdded && !this.myNamespaces.isEmpty()) {
                this.myNamespacesAdded = true;
                for (Map.Entry entry : this.myNamespaces.entrySet()) {
                    this.myBuilder.attribute("xmlns", (String)entry.getValue(), (String)entry.getKey());
                }
            }
            for (XmlAttribute xmlAttribute : chunk.getAttributes()) {
                String prefix = StringUtil.notNullize((String)this.myNamespaces.get(xmlAttribute.namespace()));
                this.myBuilder.attribute(prefix, xmlAttribute.name(), this.getValue(xmlAttribute));
            }
        }

        @Override
        public void endElement(@NotNull XmlEndElementChunk chunk) {
            if (chunk == null) {
                XmlPrinter.$$$reportNull$$$0(3);
            }
            this.myBuilder.endTag(chunk.getName());
        }

        @NotNull
        public String getReconstructedXml() {
            String string = this.myBuilder.toString();
            if (string == null) {
                XmlPrinter.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        private String getValue(@NotNull XmlAttribute attribute) {
            String rawValue;
            if (attribute == null) {
                XmlPrinter.$$$reportNull$$$0(5);
            }
            if (!StringUtil.isEmpty((String)(rawValue = attribute.rawValue()))) {
                String string = rawValue;
                if (string == null) {
                    XmlPrinter.$$$reportNull$$$0(6);
                }
                return string;
            }
            BinaryResourceValue resValue = attribute.typedValue();
            String string = BinaryXmlParser.formatValue(resValue, this.myStringPool);
            if (string == null) {
                XmlPrinter.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "chunk";
                    break;
                }
                case 4: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/apk/viewer/BinaryXmlParser$XmlPrinter";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attribute";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/apk/viewer/BinaryXmlParser$XmlPrinter";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReconstructedXml";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "stringPool";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "startNamespace";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "startElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "endElement";
                    break;
                }
                case 4: 
                case 6: 
                case 7: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static interface XmlChunkHandler {
        default public void stringPool(@NotNull StringPoolChunk chunk) {
            if (chunk == null) {
                XmlChunkHandler.$$$reportNull$$$0(0);
            }
        }

        default public void xmlResourceMap(@NotNull XmlResourceMapChunk chunk) {
            if (chunk == null) {
                XmlChunkHandler.$$$reportNull$$$0(1);
            }
        }

        default public void startNamespace(@NotNull XmlNamespaceStartChunk chunk) {
            if (chunk == null) {
                XmlChunkHandler.$$$reportNull$$$0(2);
            }
        }

        default public void endNamespace(@NotNull XmlNamespaceEndChunk chunk) {
            if (chunk == null) {
                XmlChunkHandler.$$$reportNull$$$0(3);
            }
        }

        default public void startElement(@NotNull XmlStartElementChunk chunk) {
            if (chunk == null) {
                XmlChunkHandler.$$$reportNull$$$0(4);
            }
        }

        default public void endElement(@NotNull XmlEndElementChunk chunk) {
            if (chunk == null) {
                XmlChunkHandler.$$$reportNull$$$0(5);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "chunk";
            objectArray2[1] = "com/android/tools/idea/apk/viewer/BinaryXmlParser$XmlChunkHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "stringPool";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "xmlResourceMap";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "startNamespace";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "endNamespace";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "startElement";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "endElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

