/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer.dex;

import com.android.tools.idea.apk.viewer.dex.PackageTreeNode;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.dexbacked.DexBackedClassDef;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.reference.DexBackedMethodReference;
import org.jf.dexlib2.iface.reference.MethodReference;

public class DexParser {
    private final ListeningExecutorService myExecutor;
    private final Future<DexBackedDexFile> myDexFileFuture;

    public DexParser(@NotNull ListeningExecutorService executorService, @NotNull VirtualFile file) {
        if (executorService == null) {
            DexParser.$$$reportNull$$$0(0);
        }
        if (file == null) {
            DexParser.$$$reportNull$$$0(1);
        }
        this.myExecutor = executorService;
        this.myDexFileFuture = this.myExecutor.submit(() -> {
            if (file == null) {
                DexParser.$$$reportNull$$$0(14);
            }
            return DexParser.getDexFile(file);
        });
    }

    public ListenableFuture<PackageTreeNode> constructMethodRefCountTree() {
        return this.myExecutor.submit(this::constructMethodRefTree);
    }

    public ListenableFuture<DexFileStats> getDexFileStats() {
        return this.myExecutor.submit(this::getDexStats);
    }

    @NotNull
    private PackageTreeNode constructMethodRefTree() {
        DexBackedDexFile dexFile;
        try {
            dexFile = this.myDexFileFuture.get();
        }
        catch (Exception e) {
            PackageTreeNode packageTreeNode = new PackageTreeNode("Unknown", e.toString(), PackageTreeNode.NodeType.PACKAGE, null);
            if (packageTreeNode == null) {
                DexParser.$$$reportNull$$$0(2);
            }
            return packageTreeNode;
        }
        PackageTreeNode packageTreeNode = DexParser.constructMethodRefTreeForDex(dexFile);
        if (packageTreeNode == null) {
            DexParser.$$$reportNull$$$0(3);
        }
        return packageTreeNode;
    }

    @NotNull
    static PackageTreeNode constructMethodRefTreeForDex(@NotNull DexBackedDexFile dexFile) {
        if (dexFile == null) {
            DexParser.$$$reportNull$$$0(4);
        }
        PackageTreeNode root = new PackageTreeNode("", "root", PackageTreeNode.NodeType.PACKAGE, null);
        Set classesWithDefinition = dexFile.getClasses().stream().map(DexBackedClassDef::getType).collect(Collectors.toSet());
        Multimap<String, MethodReference> methodsByClassName = DexParser.getMethodsByClassName(dexFile);
        for (String className : methodsByClassName.keySet()) {
            Collection methods = methodsByClassName.get((Object)className);
            for (MethodReference ref : methods) {
                root.insert("", DebuggerUtilsEx.signatureToName((String)className), ref, classesWithDefinition.contains(className));
            }
        }
        root.sortByCount();
        PackageTreeNode packageTreeNode = root;
        if (packageTreeNode == null) {
            DexParser.$$$reportNull$$$0(5);
        }
        return packageTreeNode;
    }

    @NotNull
    private static Multimap<String, MethodReference> getMethodsByClassName(@NotNull DexBackedDexFile dexFile) {
        if (dexFile == null) {
            DexParser.$$$reportNull$$$0(6);
        }
        ArrayListMultimap methodsByClass = ArrayListMultimap.create();
        int m = dexFile.getMethodCount();
        for (int i = 0; i < m; ++i) {
            DexBackedMethodReference methodRef = new DexBackedMethodReference(dexFile, i);
            methodsByClass.put((Object)methodRef.getDefiningClass(), (Object)methodRef);
        }
        ArrayListMultimap arrayListMultimap = methodsByClass;
        if (arrayListMultimap == null) {
            DexParser.$$$reportNull$$$0(7);
        }
        return arrayListMultimap;
    }

    @NotNull
    private DexFileStats getDexStats() {
        DexBackedDexFile dexFile;
        try {
            dexFile = this.myDexFileFuture.get();
        }
        catch (Exception e) {
            DexFileStats dexFileStats = new DexFileStats(-1, -1, -1);
            if (dexFileStats == null) {
                DexParser.$$$reportNull$$$0(8);
            }
            return dexFileStats;
        }
        int definedMethodCount = 0;
        Set classes = dexFile.getClasses();
        for (DexBackedClassDef dexBackedClassDef : classes) {
            definedMethodCount += Iterables.size((Iterable)dexBackedClassDef.getMethods());
        }
        DexFileStats dexFileStats = new DexFileStats(classes.size(), definedMethodCount, dexFile.getMethodCount());
        if (dexFileStats == null) {
            DexParser.$$$reportNull$$$0(9);
        }
        return dexFileStats;
    }

    @NotNull
    private static DexBackedDexFile getDexFile(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            DexParser.$$$reportNull$$$0(10);
        }
        byte[] contents = file.contentsToByteArray();
        DexBackedDexFile dexBackedDexFile = DexParser.getDexFile(contents);
        if (dexBackedDexFile == null) {
            DexParser.$$$reportNull$$$0(11);
        }
        return dexBackedDexFile;
    }

    @NotNull
    static DexBackedDexFile getDexFile(@NotNull byte[] contents) {
        if (contents == null) {
            DexParser.$$$reportNull$$$0(12);
        }
        DexBackedDexFile dexBackedDexFile = new DexBackedDexFile(new Opcodes(15), contents);
        if (dexBackedDexFile == null) {
            DexParser.$$$reportNull$$$0(13);
        }
        return dexBackedDexFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorService";
                break;
            }
            case 1: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/apk/viewer/dex/DexParser";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dexFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/apk/viewer/dex/DexParser";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "constructMethodRefTree";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "constructMethodRefTreeForDex";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodsByClassName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDexStats";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDexFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "constructMethodRefTreeForDex";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getMethodsByClassName";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDexFile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DexFileStats {
        public final int classCount;
        public final int definedMethodCount;
        public final int referencedMethodCount;

        private DexFileStats(int classCount, int definedMethodCount, int referencedMethodCount) {
            this.classCount = classCount;
            this.definedMethodCount = definedMethodCount;
            this.referencedMethodCount = referencedMethodCount;
        }
    }
}

