/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.actions;

import com.android.tools.idea.gradle.actions.GoToApkLocationTask;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.util.Projects;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.android.facet.AndroidFacet;

public class BuildApkAction
extends DumbAwareAction {
    public BuildApkAction() {
        super("Build APK");
    }

    public void update(AnActionEvent e) {
        Project project = e.getProject();
        e.getPresentation().setEnabledAndVisible(project != null && Projects.isBuildWithGradle(project));
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        if (project != null && Projects.isBuildWithGradle(project)) {
            Module[] modules;
            GoToApkLocationTask task = null;
            for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
                String assembleTaskName;
                AndroidFacet facet = AndroidFacet.getInstance(module);
                if (facet == null || !StringUtil.isNotEmpty((String)(assembleTaskName = facet.getProperties().ASSEMBLE_TASK_NAME))) continue;
                task = new GoToApkLocationTask("Build APK", module, null);
                break;
            }
            GradleBuildInvoker gradleBuildInvoker = GradleBuildInvoker.getInstance(project);
            if (task != null) {
                gradleBuildInvoker.add(task);
            }
            gradleBuildInvoker.assemble(modules, GradleBuildInvoker.TestCompileType.NONE);
        }
    }
}

