/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.AndroidGradleNotification;
import com.android.tools.idea.gradle.project.build.invoker.GradleTasksExecutor;
import com.android.tools.idea.gradle.project.importing.NewProjectImportGradleSyncListener;
import com.android.tools.idea.gradle.project.importing.OpenMigrationToGradleUrlHyperlink;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.cleanup.PreSyncProjectCleanUp;
import com.android.tools.idea.gradle.project.sync.idea.IdeaGradleSync;
import com.android.tools.idea.gradle.project.sync.precheck.PreSyncCheckResult;
import com.android.tools.idea.gradle.project.sync.precheck.PreSyncChecks;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleSyncInvoker {
    @NotNull
    private final FileDocumentManager myFileDocumentManager;
    @NotNull
    private final IdeInfo myIdeInfo;
    @NotNull
    private final PreSyncProjectCleanUp myPreSyncProjectCleanUp;
    @NotNull
    private final PreSyncChecks myPreSyncChecks;

    @NotNull
    public static GradleSyncInvoker getInstance() {
        GradleSyncInvoker gradleSyncInvoker = (GradleSyncInvoker)ServiceManager.getService(GradleSyncInvoker.class);
        if (gradleSyncInvoker == null) {
            GradleSyncInvoker.$$$reportNull$$$0(0);
        }
        return gradleSyncInvoker;
    }

    public GradleSyncInvoker(@NotNull FileDocumentManager fileDocumentManager, @NotNull IdeInfo ideInfo) {
        if (fileDocumentManager == null) {
            GradleSyncInvoker.$$$reportNull$$$0(1);
        }
        if (ideInfo == null) {
            GradleSyncInvoker.$$$reportNull$$$0(2);
        }
        this(fileDocumentManager, ideInfo, new PreSyncProjectCleanUp(), new PreSyncChecks());
    }

    @VisibleForTesting
    GradleSyncInvoker(@NotNull FileDocumentManager fileDocumentManager, @NotNull IdeInfo ideInfo, @NotNull PreSyncProjectCleanUp preSyncProjectCleanUp, @NotNull PreSyncChecks preSyncChecks) {
        if (fileDocumentManager == null) {
            GradleSyncInvoker.$$$reportNull$$$0(3);
        }
        if (ideInfo == null) {
            GradleSyncInvoker.$$$reportNull$$$0(4);
        }
        if (preSyncProjectCleanUp == null) {
            GradleSyncInvoker.$$$reportNull$$$0(5);
        }
        if (preSyncChecks == null) {
            GradleSyncInvoker.$$$reportNull$$$0(6);
        }
        this.myFileDocumentManager = fileDocumentManager;
        this.myIdeInfo = ideInfo;
        this.myPreSyncProjectCleanUp = preSyncProjectCleanUp;
        this.myPreSyncChecks = preSyncChecks;
    }

    public void requestProjectSyncAndSourceGeneration(@NotNull Project project, @Nullable GradleSyncListener listener) {
        if (project == null) {
            GradleSyncInvoker.$$$reportNull$$$0(7);
        }
        this.requestProjectSync(project, Request.DEFAULT_REQUEST, listener);
    }

    public void requestProjectSync(@NotNull Project project, @NotNull Request request, @Nullable GradleSyncListener listener) {
        if (project == null) {
            GradleSyncInvoker.$$$reportNull$$$0(8);
        }
        if (request == null) {
            GradleSyncInvoker.$$$reportNull$$$0(9);
        }
        if (GradleSyncState.getInstance(project).isSyncInProgress()) {
            return;
        }
        if (GradleSyncInvoker.isBuildInProgress(project)) {
            Projects.setSyncRequestedDuringBuild(project, true);
            return;
        }
        UIUtil.invokeAndWaitIfNeeded(() -> {
            if (project == null) {
                GradleSyncInvoker.$$$reportNull$$$0(22);
            }
            return ExternalSystemUtil.ensureToolWindowContentInitialized((Project)project, (ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID);
        });
        Runnable syncTask = () -> {
            if (project == null) {
                GradleSyncInvoker.$$$reportNull$$$0(20);
            }
            if (request == null) {
                GradleSyncInvoker.$$$reportNull$$$0(21);
            }
            try {
                if (this.prepareProject(project, request, listener)) {
                    this.sync(project, request, listener);
                }
            }
            catch (ConfigurationException e) {
                Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)e.getTitle());
            }
        };
        if (request.isRunInBackground()) {
            AppUIUtil.invokeLaterIfProjectAlive((Project)project, (Runnable)syncTask);
        } else {
            UIUtil.invokeAndWaitIfNeeded((Runnable)syncTask);
        }
    }

    private static boolean isBuildInProgress(@NotNull Project project) {
        IdeFrame frame;
        StatusBarEx statusBar;
        if (project == null) {
            GradleSyncInvoker.$$$reportNull$$$0(10);
        }
        StatusBarEx statusBarEx = statusBar = (frame = ((WindowManagerEx)WindowManager.getInstance()).findFrameFor(project)) == null ? null : (StatusBarEx)frame.getStatusBar();
        if (statusBar == null) {
            return false;
        }
        for (Pair backgroundProcess : statusBar.getBackgroundProcesses()) {
            ProgressIndicator second;
            TaskInfo task = (TaskInfo)backgroundProcess.getFirst();
            if (!(task instanceof GradleTasksExecutor) || !(second = (ProgressIndicator)backgroundProcess.getSecond()).isRunning()) continue;
            return true;
        }
        return false;
    }

    private boolean prepareProject(@NotNull Project project, @NotNull Request request, @Nullable GradleSyncListener listener) throws ConfigurationException {
        if (project == null) {
            GradleSyncInvoker.$$$reportNull$$$0(11);
        }
        if (request == null) {
            GradleSyncInvoker.$$$reportNull$$$0(12);
        }
        if (AndroidProjectInfo.getInstance(project).requiresAndroidModel() || GradleSyncInvoker.hasTopLevelGradleBuildFile(project)) {
            if (!request.isNewProject()) {
                this.myFileDocumentManager.saveAllDocuments();
            }
            return true;
        }
        AppUIUtil.invokeLaterIfProjectAlive((Project)project, () -> {
            if (project == null) {
                GradleSyncInvoker.$$$reportNull$$$0(19);
            }
            String msg = String.format("The project '%s' is not a Gradle-based project", project.getName());
            AndroidGradleNotification.getInstance(project).showBalloon("Project Sync", msg, NotificationType.ERROR, new OpenMigrationToGradleUrlHyperlink());
            if (listener != null) {
                listener.syncFailed(project, msg);
            }
        });
        return false;
    }

    private static boolean hasTopLevelGradleBuildFile(@NotNull Project project) {
        String projectFolderPath;
        if (project == null) {
            GradleSyncInvoker.$$$reportNull$$$0(13);
        }
        if ((projectFolderPath = project.getBasePath()) != null) {
            File buildFile = new File(projectFolderPath, "build.gradle");
            return buildFile.isFile();
        }
        return false;
    }

    private void sync(@NotNull Project project, @NotNull Request request, @Nullable GradleSyncListener listener) {
        PreSyncCheckResult canSync;
        if (project == null) {
            GradleSyncInvoker.$$$reportNull$$$0(14);
        }
        if (request == null) {
            GradleSyncInvoker.$$$reportNull$$$0(15);
        }
        if (this.myIdeInfo.isAndroidStudio()) {
            GradleUtil.clearStoredGradleJvmArgs(project);
        }
        if (!(canSync = this.myPreSyncChecks.canSync(project)).isSuccess()) {
            String cause = Strings.nullToEmpty((String)canSync.getFailureCause());
            GradleSyncInvoker.handlePreSyncCheckFailure(project, cause, listener);
            return;
        }
        boolean started = request.isUseCachedGradleModels() ? GradleSyncState.getInstance(project).skippedSyncStarted(!request.isNewProject()) : GradleSyncState.getInstance(project).syncStarted(!request.isNewProject());
        if (!started) {
            return;
        }
        GradleSyncInvoker.removeAndroidModels(project);
        this.myPreSyncProjectCleanUp.cleanUp(project);
        IdeaGradleSync gradleSync = new IdeaGradleSync();
        gradleSync.sync(project, request, listener);
    }

    private static void handlePreSyncCheckFailure(@NotNull Project project, @NotNull String failureCause, @Nullable GradleSyncListener syncListener) {
        GradleSyncState syncState;
        if (project == null) {
            GradleSyncInvoker.$$$reportNull$$$0(16);
        }
        if (failureCause == null) {
            GradleSyncInvoker.$$$reportNull$$$0(17);
        }
        if ((syncState = GradleSyncState.getInstance(project)).syncStarted(true)) {
            NewProjectImportGradleSyncListener.createTopLevelProjectAndOpen(project);
            syncState.syncFailed(failureCause);
            if (syncListener != null) {
                syncListener.syncFailed(project, failureCause);
            }
        }
    }

    private static void removeAndroidModels(@NotNull Project project) {
        if (project == null) {
            GradleSyncInvoker.$$$reportNull$$$0(18);
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null) continue;
            facet.setAndroidModel(null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/GradleSyncInvoker";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileDocumentManager";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preSyncProjectCleanUp";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preSyncChecks";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 12: 
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "failureCause";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/GradleSyncInvoker";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "requestProjectSyncAndSourceGeneration";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "requestProjectSync";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isBuildInProgress";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "prepareProject";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "hasTopLevelGradleBuildFile";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "sync";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "handlePreSyncCheckFailure";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "removeAndroidModels";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$prepareProject$2";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$requestProjectSync$1";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$requestProjectSync$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Request {
        private static final Request DEFAULT_REQUEST = new Request();
        private boolean myRunInBackground = true;
        private boolean myGenerateSourcesOnSuccess = true;
        private boolean myCleanProject;
        private boolean myUseCachedGradleModels;
        private boolean myNewProject;

        public boolean isRunInBackground() {
            return this.myRunInBackground;
        }

        @NotNull
        public Request setRunInBackground(boolean runInBackground) {
            this.myRunInBackground = runInBackground;
            Request request = this;
            if (request == null) {
                Request.$$$reportNull$$$0(0);
            }
            return request;
        }

        public boolean isGenerateSourcesOnSuccess() {
            return this.myGenerateSourcesOnSuccess;
        }

        @NotNull
        public Request setGenerateSourcesOnSuccess(boolean generateSourcesOnSuccess) {
            this.myGenerateSourcesOnSuccess = generateSourcesOnSuccess;
            Request request = this;
            if (request == null) {
                Request.$$$reportNull$$$0(1);
            }
            return request;
        }

        public boolean isCleanProject() {
            return this.myCleanProject;
        }

        @NotNull
        public Request setCleanProject(boolean cleanProject) {
            this.myCleanProject = cleanProject;
            Request request = this;
            if (request == null) {
                Request.$$$reportNull$$$0(2);
            }
            return request;
        }

        public boolean isUseCachedGradleModels() {
            return this.myUseCachedGradleModels;
        }

        @NotNull
        public Request setUseCachedGradleModels(boolean useCachedGradleModels) {
            this.myUseCachedGradleModels = useCachedGradleModels;
            Request request = this;
            if (request == null) {
                Request.$$$reportNull$$$0(3);
            }
            return request;
        }

        public boolean isNewProject() {
            return this.myNewProject;
        }

        @NotNull
        public Request setNewProject(boolean newProject) {
            this.myNewProject = newProject;
            Request request = this;
            if (request == null) {
                Request.$$$reportNull$$$0(4);
            }
            return request;
        }

        @NotNull
        public ProgressExecutionMode getProgressExecutionMode() {
            ProgressExecutionMode progressExecutionMode = this.isRunInBackground() ? ProgressExecutionMode.IN_BACKGROUND_ASYNC : ProgressExecutionMode.MODAL_SYNC;
            if (progressExecutionMode == null) {
                Request.$$$reportNull$$$0(5);
            }
            return progressExecutionMode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return this.myRunInBackground == request.myRunInBackground && this.myCleanProject == request.myCleanProject && this.myGenerateSourcesOnSuccess == request.myGenerateSourcesOnSuccess && this.myUseCachedGradleModels == request.myUseCachedGradleModels && this.myNewProject == request.myNewProject;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.myRunInBackground, this.myCleanProject, this.myGenerateSourcesOnSuccess, this.myUseCachedGradleModels, this.myNewProject});
        }

        public String toString() {
            return "RequestSettings{myRunInBackground=" + this.myRunInBackground + ", myCleanProject=" + this.myCleanProject + ", myGenerateSourcesOnSuccess=" + this.myGenerateSourcesOnSuccess + ", myUseCachedGradleModels=" + this.myUseCachedGradleModels + ", myNewProject=" + this.myNewProject + '}';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/android/tools/idea/gradle/project/sync/GradleSyncInvoker$Request";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setRunInBackground";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setGenerateSourcesOnSuccess";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setCleanProject";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setUseCachedGradleModels";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setNewProject";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProgressExecutionMode";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

