/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.android;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.Variant;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.setup.module.common.ContentEntriesSetup;
import com.android.tools.idea.gradle.util.FilePaths;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

class AndroidContentEntriesSetup
extends ContentEntriesSetup {
    @NotNull
    private final AndroidModuleModel myAndroidModel;
    private final boolean myHasNativeModel;

    private AndroidContentEntriesSetup(@NotNull AndroidModuleModel androidModel, @NotNull ModifiableRootModel moduleModel, boolean hasNativeModel) {
        if (androidModel == null) {
            AndroidContentEntriesSetup.$$$reportNull$$$0(0);
        }
        if (moduleModel == null) {
            AndroidContentEntriesSetup.$$$reportNull$$$0(1);
        }
        super(moduleModel);
        this.myAndroidModel = androidModel;
        this.myHasNativeModel = hasNativeModel;
    }

    @Override
    public void execute(@NotNull List<ContentEntry> contentEntries) {
        if (contentEntries == null) {
            AndroidContentEntriesSetup.$$$reportNull$$$0(2);
        }
        Variant selectedVariant = this.myAndroidModel.getSelectedVariant();
        AndroidArtifact mainArtifact = selectedVariant.getMainArtifact();
        this.addSourceFolders((BaseArtifact)mainArtifact, contentEntries, false);
        for (BaseArtifact artifact : AndroidModuleModel.getTestArtifacts(selectedVariant)) {
            this.addSourceFolders(artifact, contentEntries, true);
        }
        for (String flavorName : selectedVariant.getProductFlavors()) {
            ProductFlavorContainer flavor = this.myAndroidModel.findProductFlavor(flavorName);
            if (flavor == null) continue;
            this.addSourceFolder(flavor, contentEntries);
        }
        String buildTypeName = selectedVariant.getBuildType();
        BuildTypeContainer buildTypeContainer = this.myAndroidModel.findBuildType(buildTypeName);
        if (buildTypeContainer != null) {
            this.addSourceFolder(buildTypeContainer.getSourceProvider(), contentEntries, false);
            Collection<SourceProvider> testSourceProviders = this.myAndroidModel.getTestSourceProviders(buildTypeContainer.getExtraSourceProviders());
            for (SourceProvider testSourceProvider : testSourceProviders) {
                this.addSourceFolder(testSourceProvider, contentEntries, true);
            }
        }
        ProductFlavorContainer defaultConfig = this.getAndroidProject().getDefaultConfig();
        this.addSourceFolder(defaultConfig, contentEntries);
        this.addExcludedOutputFolders(contentEntries);
        this.addOrphans();
    }

    private void addSourceFolders(@NotNull BaseArtifact artifact, @NotNull List<ContentEntry> contentEntries, boolean isTest) {
        SourceProvider multiFlavorSourceProvider;
        if (artifact == null) {
            AndroidContentEntriesSetup.$$$reportNull$$$0(3);
        }
        if (contentEntries == null) {
            AndroidContentEntriesSetup.$$$reportNull$$$0(4);
        }
        this.addGeneratedSourceFolders(artifact, contentEntries, isTest);
        SourceProvider variantSourceProvider = artifact.getVariantSourceProvider();
        if (variantSourceProvider != null) {
            this.addSourceFolder(variantSourceProvider, contentEntries, isTest);
        }
        if ((multiFlavorSourceProvider = artifact.getMultiFlavorSourceProvider()) != null) {
            this.addSourceFolder(multiFlavorSourceProvider, contentEntries, isTest);
        }
    }

    private void addGeneratedSourceFolders(@NotNull BaseArtifact artifact, @NotNull List<ContentEntry> contentEntries, boolean isTest) {
        Collection<File> generatedSourceFolders;
        if (artifact == null) {
            AndroidContentEntriesSetup.$$$reportNull$$$0(5);
        }
        if (contentEntries == null) {
            AndroidContentEntriesSetup.$$$reportNull$$$0(6);
        }
        JpsModuleSourceRootType sourceType = AndroidContentEntriesSetup.getSourceType(isTest);
        GradleVersion modelVersion = this.myAndroidModel.getModelVersion();
        if ((artifact instanceof AndroidArtifact || modelVersion != null && modelVersion.compareIgnoringQualifiers("1.2") >= 0) && (generatedSourceFolders = GradleUtil.getGeneratedSourceFolders(artifact)) != null) {
            this.addSourceFolders(generatedSourceFolders, contentEntries, sourceType, true);
        }
        if (artifact instanceof AndroidArtifact) {
            sourceType = AndroidContentEntriesSetup.getResourceSourceType(isTest);
            AndroidArtifact androidArtifact = (AndroidArtifact)artifact;
            this.addSourceFolders(androidArtifact.getGeneratedResourceFolders(), contentEntries, sourceType, true);
        }
    }

    private void addSourceFolder(@NotNull ProductFlavorContainer flavor, @NotNull List<ContentEntry> contentEntries) {
        if (flavor == null) {
            AndroidContentEntriesSetup.$$$reportNull$$$0(7);
        }
        if (contentEntries == null) {
            AndroidContentEntriesSetup.$$$reportNull$$$0(8);
        }
        this.addSourceFolder(flavor.getSourceProvider(), contentEntries, false);
        Collection<SourceProvider> testSourceProviders = this.myAndroidModel.getTestSourceProviders(flavor.getExtraSourceProviders());
        for (SourceProvider sourceProvider : testSourceProviders) {
            this.addSourceFolder(sourceProvider, contentEntries, true);
        }
    }

    private void addSourceFolder(@NotNull SourceProvider sourceProvider, @NotNull List<ContentEntry> contentEntries, boolean isTest) {
        if (sourceProvider == null) {
            AndroidContentEntriesSetup.$$$reportNull$$$0(9);
        }
        if (contentEntries == null) {
            AndroidContentEntriesSetup.$$$reportNull$$$0(10);
        }
        JpsModuleSourceRootType sourceType = AndroidContentEntriesSetup.getResourceSourceType(isTest);
        this.addSourceFolders(sourceProvider.getResDirectories(), contentEntries, sourceType, false);
        this.addSourceFolders(sourceProvider.getResourcesDirectories(), contentEntries, sourceType, false);
        this.addSourceFolders(sourceProvider.getAssetsDirectories(), contentEntries, sourceType, false);
        sourceType = AndroidContentEntriesSetup.getSourceType(isTest);
        this.addSourceFolders(sourceProvider.getAidlDirectories(), contentEntries, sourceType, false);
        this.addSourceFolders(sourceProvider.getJavaDirectories(), contentEntries, sourceType, false);
        if (this.myHasNativeModel) {
            this.addSourceFolders(sourceProvider.getCDirectories(), contentEntries, sourceType, false);
            this.addSourceFolders(sourceProvider.getCppDirectories(), contentEntries, sourceType, false);
        }
        this.addSourceFolders(sourceProvider.getRenderscriptDirectories(), contentEntries, sourceType, false);
        if (this.myAndroidModel.getFeatures().isShadersSupported()) {
            this.addSourceFolders(sourceProvider.getShadersDirectories(), contentEntries, sourceType, false);
        }
    }

    @NotNull
    private static JpsModuleSourceRootType getResourceSourceType(boolean isTest) {
        JavaResourceRootType javaResourceRootType = isTest ? JavaResourceRootType.TEST_RESOURCE : JavaResourceRootType.RESOURCE;
        if (javaResourceRootType == null) {
            AndroidContentEntriesSetup.$$$reportNull$$$0(11);
        }
        return javaResourceRootType;
    }

    @NotNull
    private static JpsModuleSourceRootType getSourceType(boolean isTest) {
        JavaSourceRootType javaSourceRootType = isTest ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE;
        if (javaSourceRootType == null) {
            AndroidContentEntriesSetup.$$$reportNull$$$0(12);
        }
        return javaSourceRootType;
    }

    private void addSourceFolders(@NotNull Collection<File> folderPaths, @NotNull List<ContentEntry> contentEntries, @NotNull JpsModuleSourceRootType type, boolean generated) {
        if (folderPaths == null) {
            AndroidContentEntriesSetup.$$$reportNull$$$0(13);
        }
        if (contentEntries == null) {
            AndroidContentEntriesSetup.$$$reportNull$$$0(14);
        }
        if (type == null) {
            AndroidContentEntriesSetup.$$$reportNull$$$0(15);
        }
        for (File folderPath : folderPaths) {
            if (generated && !this.isGeneratedAtCorrectLocation(folderPath)) {
                this.myAndroidModel.registerExtraGeneratedSourceFolder(folderPath);
            }
            this.addSourceFolder(folderPath, contentEntries, type, generated);
        }
    }

    private boolean isGeneratedAtCorrectLocation(@NotNull File folderPath) {
        if (folderPath == null) {
            AndroidContentEntriesSetup.$$$reportNull$$$0(16);
        }
        File generatedFolderPath = new File(this.getAndroidProject().getBuildFolder(), "generated");
        return FileUtil.isAncestor((File)generatedFolderPath, (File)folderPath, (boolean)false);
    }

    private void addExcludedOutputFolders(@NotNull List<ContentEntry> contentEntries) {
        File buildFolderPath;
        ContentEntry parentContentEntry;
        if (contentEntries == null) {
            AndroidContentEntriesSetup.$$$reportNull$$$0(17);
        }
        if ((parentContentEntry = FilePaths.findParentContentEntry(buildFolderPath = this.getAndroidProject().getBuildFolder(), contentEntries)) != null) {
            List<File> excludedFolderPaths = this.myAndroidModel.getExcludedFolderPaths();
            for (File folderPath : excludedFolderPaths) {
                this.addExcludedFolder(parentContentEntry, folderPath);
            }
        }
    }

    @NotNull
    private AndroidProject getAndroidProject() {
        AndroidProject androidProject = this.myAndroidModel.getAndroidProject();
        if (androidProject == null) {
            AndroidContentEntriesSetup.$$$reportNull$$$0(18);
        }
        return androidProject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleModel";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentEntries";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flavor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceProvider";
                break;
            }
            case 11: 
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidContentEntriesSetup";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderPaths";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidContentEntriesSetup";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceSourceType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceType";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 3: 
            case 4: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addSourceFolders";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addGeneratedSourceFolders";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addSourceFolder";
                break;
            }
            case 11: 
            case 12: 
            case 18: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isGeneratedAtCorrectLocation";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addExcludedOutputFolders";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class Factory {
        Factory() {
        }

        @NotNull
        AndroidContentEntriesSetup create(@NotNull AndroidModuleModel androidModel, @NotNull ModifiableRootModel moduleModel, boolean hasNativeModel) {
            if (androidModel == null) {
                Factory.$$$reportNull$$$0(0);
            }
            if (moduleModel == null) {
                Factory.$$$reportNull$$$0(1);
            }
            AndroidContentEntriesSetup androidContentEntriesSetup = new AndroidContentEntriesSetup(androidModel, moduleModel, hasNativeModel);
            if (androidContentEntriesSetup == null) {
                Factory.$$$reportNull$$$0(2);
            }
            return androidContentEntriesSetup;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "androidModel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleModel";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidContentEntriesSetup$Factory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidContentEntriesSetup$Factory";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

