/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post.cleanup;

import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.InstallPlatformHyperlink;
import com.android.tools.idea.gradle.project.sync.messages.MessageType;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessage;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessages;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectCleanupStep;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.startup.ExternalAnnotationsSupport;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdksCleanupStep
extends ProjectCleanupStep {
    @NotNull
    private final AndroidSdks myAndroidSdks;

    public SdksCleanupStep(@NotNull AndroidSdks androidSdks) {
        if (androidSdks == null) {
            SdksCleanupStep.$$$reportNull$$$0(0);
        }
        this.myAndroidSdks = androidSdks;
    }

    @Override
    public void cleanUpProject(@NotNull Project project, @NotNull IdeModifiableModelsProvider ideModifiableModelsProvider, @Nullable com.intellij.openapi.progress.ProgressIndicator indicator) {
        if (project == null) {
            SdksCleanupStep.$$$reportNull$$$0(1);
        }
        if (ideModifiableModelsProvider == null) {
            SdksCleanupStep.$$$reportNull$$$0(2);
        }
        HashSet invalidAndroidSdks = Sets.newHashSet();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            this.cleanUpSdk(module, invalidAndroidSdks);
        }
        if (!invalidAndroidSdks.isEmpty()) {
            this.reinstallMissingPlatforms(invalidAndroidSdks, project);
        }
    }

    public void cleanUpSdk(@NotNull Module module, @NotNull Collection<Sdk> invalidAndroidSdks) {
        AndroidFacet androidFacet;
        if (module == null) {
            SdksCleanupStep.$$$reportNull$$$0(3);
        }
        if (invalidAndroidSdks == null) {
            SdksCleanupStep.$$$reportNull$$$0(4);
        }
        if ((androidFacet = AndroidFacet.getInstance(module)) == null || androidFacet.getAndroidModel() == null) {
            return;
        }
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        if (sdk != null && !invalidAndroidSdks.contains(sdk) && (this.isMissingAndroidLibrary(sdk) || this.shouldRemoveAnnotationsJar(sdk))) {
            AndroidSdkAdditionalData additionalData = this.myAndroidSdks.getAndroidSdkAdditionalData(sdk);
            AndroidSdkData sdkData = AndroidSdkData.getSdkData(sdk);
            if (additionalData != null && sdkData != null) {
                IAndroidTarget target = additionalData.getBuildTarget(sdkData);
                if (target == null) {
                    AndroidSdkHandler sdkHandler = sdkData.getSdkHandler();
                    StudioLoggerProgressIndicator logger = new StudioLoggerProgressIndicator(this.getClass());
                    sdkHandler.getSdkManager((ProgressIndicator)logger).loadSynchronously(0L, (ProgressIndicator)logger, null, null);
                    target = sdkHandler.getAndroidTargetManager((ProgressIndicator)logger).getTargetFromHashString(additionalData.getBuildTargetHashString(), (ProgressIndicator)logger);
                }
                if (target != null) {
                    SdkModificator sdkModificator = sdk.getSdkModificator();
                    sdkModificator.removeAllRoots();
                    for (OrderRoot orderRoot : this.myAndroidSdks.getLibraryRootsForTarget(target, sdk, true)) {
                        sdkModificator.addRoot(orderRoot.getFile(), orderRoot.getType());
                    }
                    ExternalAnnotationsSupport.attachJdkAnnotations(sdkModificator);
                    sdkModificator.commitChanges();
                }
            }
            if (this.isMissingAndroidLibrary(sdk)) {
                invalidAndroidSdks.add(sdk);
            }
        }
    }

    private boolean isMissingAndroidLibrary(@NotNull Sdk sdk) {
        if (sdk == null) {
            SdksCleanupStep.$$$reportNull$$$0(5);
        }
        if (this.myAndroidSdks.isAndroidSdk(sdk)) {
            for (VirtualFile library : sdk.getRootProvider().getFiles(OrderRootType.CLASSES)) {
                if (!library.getName().equals("android.jar") || !library.exists()) continue;
                return false;
            }
        }
        return true;
    }

    private boolean shouldRemoveAnnotationsJar(@NotNull Sdk sdk) {
        if (sdk == null) {
            SdksCleanupStep.$$$reportNull$$$0(6);
        }
        if (this.myAndroidSdks.isAndroidSdk(sdk)) {
            IAndroidTarget target;
            AndroidSdkAdditionalData additionalData = this.myAndroidSdks.getAndroidSdkAdditionalData(sdk);
            AndroidSdkData sdkData = AndroidSdkData.getSdkData(sdk);
            boolean needsAnnotationsJar = false;
            if (additionalData != null && sdkData != null && (target = additionalData.getBuildTarget(sdkData)) != null) {
                needsAnnotationsJar = this.myAndroidSdks.needsAnnotationsJarInClasspath(target);
            }
            for (VirtualFile library : sdk.getRootProvider().getFiles(OrderRootType.CLASSES)) {
                if (!library.getName().equals("annotations.jar") || !library.exists() || needsAnnotationsJar) continue;
                return true;
            }
        }
        return false;
    }

    private void reinstallMissingPlatforms(@NotNull Collection<Sdk> invalidAndroidSdks, @NotNull Project project) {
        if (invalidAndroidSdks == null) {
            SdksCleanupStep.$$$reportNull$$$0(7);
        }
        if (project == null) {
            SdksCleanupStep.$$$reportNull$$$0(8);
        }
        ArrayList versionsToInstall = Lists.newArrayList();
        ArrayList missingPlatforms = Lists.newArrayList();
        for (Sdk sdk : invalidAndroidSdks) {
            String platform;
            AndroidSdkAdditionalData additionalData = this.myAndroidSdks.getAndroidSdkAdditionalData(sdk);
            if (additionalData == null || (platform = additionalData.getBuildTargetHashString()) == null) continue;
            missingPlatforms.add("'" + platform + "'");
            AndroidVersion version = AndroidTargetHash.getPlatformVersion((String)platform);
            if (version == null) continue;
            versionsToInstall.add(version);
        }
        if (!versionsToInstall.isEmpty()) {
            String text = "Missing Android platform(s) detected: " + Joiner.on((String)", ").join((Iterable)missingPlatforms);
            SyncMessage msg = new SyncMessage("Gradle Sync Issues", MessageType.ERROR, text);
            msg.add(new InstallPlatformHyperlink(versionsToInstall));
            SyncMessages.getInstance(project).report(msg);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidSdks";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModifiableModelsProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invalidAndroidSdks";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/post/cleanup/SdksCleanupStep";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "cleanUpProject";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "cleanUpSdk";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isMissingAndroidLibrary";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldRemoveAnnotationsJar";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "reinstallMissingPlatforms";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

