/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.android.dependencies.project.treeview;

import com.android.tools.idea.gradle.structure.configurables.android.dependencies.project.treeview.Configuration;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.project.treeview.TargetAndroidModuleNode;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.project.treeview.TargetConfigurationNode;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.treeview.AbstractDependencyNode;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractBaseTreeStructure;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractPsNode;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.PsRootNode;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.SimpleNodeComparator;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsDependency;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidArtifact;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidDependency;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.model.android.PsDependencyContainer;
import com.android.tools.idea.gradle.structure.model.android.PsLibraryAndroidDependency;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.treeStructure.SimpleNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

class TargetModulesTreeStructure
extends AbstractBaseTreeStructure {
    @NotNull
    private final PsRootNode myRootNode = new PsRootNode();

    TargetModulesTreeStructure() {
    }

    @NotNull
    public Object getRootElement() {
        PsRootNode psRootNode = this.myRootNode;
        if (psRootNode == null) {
            TargetModulesTreeStructure.$$$reportNull$$$0(0);
        }
        return psRootNode;
    }

    void displayTargetModules(@NotNull List<AbstractDependencyNode<? extends PsAndroidDependency>> dependencyNodes) {
        if (dependencyNodes == null) {
            TargetModulesTreeStructure.$$$reportNull$$$0(1);
        }
        HashMap modules = Maps.newHashMap();
        HashMultimap configurationNamesByModule = HashMultimap.create();
        dependencyNodes.forEach(arg_0 -> TargetModulesTreeStructure.lambda$displayTargetModules$2(modules, (Multimap)configurationNamesByModule, arg_0));
        ArrayList children = Lists.newArrayList();
        for (Pair moduleAndVersion : modules.values()) {
            PsAndroidModule module = (PsAndroidModule)moduleAndVersion.getFirst();
            TargetAndroidModuleNode moduleNode = new TargetAndroidModuleNode((AbstractPsNode)this.myRootNode, module, (String)moduleAndVersion.getSecond());
            ArrayList configurations = Lists.newArrayList((Iterable)configurationNamesByModule.get((Object)module.getName()));
            Collections.sort(configurations);
            ArrayList nodes = Lists.newArrayList();
            configurations.forEach(configuration -> nodes.add(new TargetConfigurationNode((Configuration)configuration)));
            moduleNode.setChildren(nodes);
            children.add(moduleNode);
        }
        Collections.sort(children, new SimpleNodeComparator());
        this.myRootNode.setChildren(children);
    }

    @NotNull
    private static List<AbstractDependencyNode<? extends PsAndroidDependency>> getDeclaredDependencyNodeHierarchy(AbstractDependencyNode<?> node) {
        ArrayList nodes = Lists.newArrayList();
        if (node.isDeclared()) {
            nodes.add(node);
        }
        SimpleNode current = node;
        while (true) {
            SimpleNode parent;
            if ((parent = current.getParent()) instanceof AbstractDependencyNode && ((AbstractDependencyNode)parent).isDeclared()) {
                nodes.add((AbstractDependencyNode)parent);
            } else if (parent == null) break;
            current = parent;
        }
        ArrayList arrayList = nodes;
        if (arrayList == null) {
            TargetModulesTreeStructure.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    private static List<PsAndroidDependency> getDeclaredDependencies(AbstractDependencyNode<? extends PsAndroidDependency> node) {
        List<PsAndroidDependency> list = node.getModels().stream().filter(PsDependency::isDeclared).collect(Collectors.toList());
        if (list == null) {
            TargetModulesTreeStructure.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static /* synthetic */ void lambda$displayTargetModules$2(Map modules, Multimap configurationNamesByModule, AbstractDependencyNode node) {
        List<AbstractDependencyNode<? extends PsAndroidDependency>> declaredDependencyNodes = TargetModulesTreeStructure.getDeclaredDependencyNodeHierarchy(node);
        HashMap versionByModule = Maps.newHashMap();
        for (PsAndroidDependency dependency : node.getModels()) {
            if (!(dependency instanceof PsLibraryAndroidDependency)) continue;
            PsLibraryAndroidDependency libraryDependency = (PsLibraryAndroidDependency)dependency;
            PsArtifactDependencySpec spec = libraryDependency.getDeclaredSpec();
            if (spec == null) {
                spec = libraryDependency.getResolvedSpec();
            }
            PsAndroidModule module = dependency.getParent();
            versionByModule.put(module.getName(), spec.version);
        }
        AbstractDependencyNode<? extends PsAndroidDependency> topParentNode = declaredDependencyNodes.get(declaredDependencyNodes.size() - 1);
        for (PsAndroidDependency dependency : topParentNode.getModels()) {
            PsAndroidModule module = dependency.getParent();
            String moduleName = module.getName();
            Pair existing = (Pair)modules.get(moduleName);
            if (existing != null) continue;
            modules.put(moduleName, Pair.create((Object)module, versionByModule.get(moduleName)));
        }
        declaredDependencyNodes.forEach(declaredDependencyNode -> {
            List<PsAndroidDependency> declaredDependencies = TargetModulesTreeStructure.getDeclaredDependencies(declaredDependencyNode);
            declaredDependencies.forEach(declaredDependency -> {
                List<String> configurationNames = declaredDependency.getConfigurationNames();
                assert (!configurationNames.isEmpty());
                PsAndroidModule module = declaredDependency.getParent();
                String moduleName = module.getName();
                for (PsDependencyContainer container : declaredDependency.getContainers()) {
                    PsAndroidArtifact artifact = container.findArtifact(module, false);
                    for (String configurationName : configurationNames) {
                        if (artifact == null || !artifact.containsConfigurationName(configurationName)) continue;
                        boolean transitive = declaredDependencyNode != node;
                        Collection configurations = configurationNamesByModule.get((Object)moduleName);
                        boolean found = false;
                        for (Configuration configuration : configurations) {
                            if (!configuration.getName().equals(configurationName)) continue;
                            configuration.addType(transitive);
                            found = true;
                            break;
                        }
                        if (found) continue;
                        Icon icon = artifact.getIcon();
                        configurationNamesByModule.put((Object)moduleName, (Object)new Configuration(configurationName, icon, transitive));
                    }
                }
            });
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/configurables/android/dependencies/project/treeview/TargetModulesTreeStructure";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/configurables/android/dependencies/project/treeview/TargetModulesTreeStructure";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredDependencyNodeHierarchy";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "displayTargetModules";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

