/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.model;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.BaseConfig;
import com.android.builder.model.BuildType;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.ProductFlavor;
import com.android.manifmerger.Actions;
import com.android.manifmerger.ManifestMerger2;
import com.android.manifmerger.ManifestSystemProperty;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.XmlDocument;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.MergedManifest;
import com.android.utils.ILogger;
import com.android.utils.NullLogger;
import com.android.utils.Pair;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXParseException;

final class ManifestInfo {
    private ManifestInfo() {
    }

    @NotNull
    static MergingReport getMergedManifest(@NotNull AndroidFacet facet, final @NotNull VirtualFile primaryManifestFile, @NotNull List<VirtualFile> flavorAndBuildTypeManifests, final @NotNull List<VirtualFile> libManifests) throws ManifestMerger2.MergeFailureException {
        if (facet == null) {
            ManifestInfo.$$$reportNull$$$0(0);
        }
        if (primaryManifestFile == null) {
            ManifestInfo.$$$reportNull$$$0(1);
        }
        if (flavorAndBuildTypeManifests == null) {
            ManifestInfo.$$$reportNull$$$0(2);
        }
        if (libManifests == null) {
            ManifestInfo.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        final File mainManifestFile = VfsUtilCore.virtualToIoFile((VirtualFile)primaryManifestFile);
        ILogger logger = NullLogger.getLogger();
        ManifestMerger2.MergeType mergeType = facet.isAppProject() ? ManifestMerger2.MergeType.APPLICATION : ManifestMerger2.MergeType.LIBRARY;
        AndroidModel androidModel = facet.getAndroidModel();
        AndroidModuleModel gradleModel = AndroidModuleModel.get(facet);
        ManifestMerger2.Invoker manifestMergerInvoker = ManifestMerger2.newMerger((File)mainManifestFile, (ILogger)logger, (ManifestMerger2.MergeType)mergeType);
        manifestMergerInvoker.withFeatures(new ManifestMerger2.Invoker.Feature[]{ManifestMerger2.Invoker.Feature.SKIP_BLAME, ManifestMerger2.Invoker.Feature.SKIP_XML_STRING});
        manifestMergerInvoker.addFlavorAndBuildTypeManifests(VfsUtilCore.virtualToIoFiles(flavorAndBuildTypeManifests).toArray(new File[0]));
        ArrayList<Pair> libraryManifests = new ArrayList<Pair>();
        for (VirtualFile file : libManifests) {
            libraryManifests.add(Pair.of((Object)file.getName(), (Object)VfsUtilCore.virtualToIoFile((VirtualFile)file)));
        }
        manifestMergerInvoker.addBundleManifests(libraryManifests);
        if (androidModel != null) {
            String packageOverride;
            Integer versionCode;
            AndroidVersion targetSdkVersion;
            AndroidVersion minSdkVersion = androidModel.getMinSdkVersion();
            if (minSdkVersion != null) {
                manifestMergerInvoker.setOverride(ManifestSystemProperty.MIN_SDK_VERSION, minSdkVersion.getApiString());
            }
            if ((targetSdkVersion = androidModel.getTargetSdkVersion()) != null) {
                manifestMergerInvoker.setOverride(ManifestSystemProperty.TARGET_SDK_VERSION, targetSdkVersion.getApiString());
            }
            if ((versionCode = androidModel.getVersionCode()) != null && versionCode > 0) {
                manifestMergerInvoker.setOverride(ManifestSystemProperty.VERSION_CODE, String.valueOf(versionCode));
            }
            if (!Strings.isNullOrEmpty((String)(packageOverride = androidModel.getApplicationId()))) {
                manifestMergerInvoker.setOverride(ManifestSystemProperty.PACKAGE, packageOverride);
            }
        }
        if (gradleModel != null) {
            BuildTypeContainer buildTypeContainer = gradleModel.findBuildType(gradleModel.getSelectedVariant().getBuildType());
            assert (buildTypeContainer != null);
            BuildType buildType = buildTypeContainer.getBuildType();
            ProductFlavor mergedProductFlavor = gradleModel.getSelectedVariant().getMergedFlavor();
            HashMap placeHolders = new HashMap(mergedProductFlavor.getManifestPlaceholders());
            placeHolders.putAll(buildType.getManifestPlaceholders());
            manifestMergerInvoker.setPlaceHolderValues(placeHolders);
            Integer maxSdkVersion = mergedProductFlavor.getMaxSdkVersion();
            if (maxSdkVersion != null) {
                manifestMergerInvoker.setOverride(ManifestSystemProperty.MAX_SDK_VERSION, maxSdkVersion.toString());
            }
            String versionName = mergedProductFlavor.getVersionName();
            String flavorVersionNameSuffix = null;
            if (gradleModel.getFeatures().isProductFlavorVersionSuffixSupported()) {
                flavorVersionNameSuffix = ManifestInfo.getVersionNameSuffix((BaseConfig)mergedProductFlavor);
            }
            String versionNameSuffix = Joiner.on((String)"").skipNulls().join((Object)flavorVersionNameSuffix, (Object)ManifestInfo.getVersionNameSuffix((BaseConfig)buildType), new Object[0]);
            if (!Strings.isNullOrEmpty((String)versionName) || !Strings.isNullOrEmpty((String)versionNameSuffix)) {
                Manifest manifest;
                if (Strings.isNullOrEmpty((String)versionName) && (manifest = facet.getManifest()) != null) {
                    versionName = manifest.getXmlTag().getAttributeValue("versionName", "http://schemas.android.com/apk/res/android");
                }
                if (!Strings.isNullOrEmpty((String)versionNameSuffix)) {
                    versionName = Strings.nullToEmpty((String)versionName) + versionNameSuffix;
                }
                manifestMergerInvoker.setOverride(ManifestSystemProperty.VERSION_NAME, versionName);
            }
        }
        if (mergeType == ManifestMerger2.MergeType.APPLICATION) {
            manifestMergerInvoker.withFeatures(new ManifestMerger2.Invoker.Feature[]{ManifestMerger2.Invoker.Feature.REMOVE_TOOLS_DECLARATIONS});
        }
        final Module module = facet.getModule();
        final Project project = module.getProject();
        manifestMergerInvoker.withFileStreamProvider(new ManifestMerger2.FileStreamProvider(){

            protected InputStream getInputStream(@NotNull File file) throws FileNotFoundException {
                MergedManifest manifest;
                Document document;
                Module moduleContainingManifest;
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                VirtualFile vFile = file == mainManifestFile ? primaryManifestFile : VfsUtil.findFileByIoFile((File)file, (boolean)false);
                assert (vFile != null) : file;
                if (!libManifests.isEmpty() && (moduleContainingManifest = this.getAndroidModuleForManifest(vFile)) != null && !module.equals(moduleContainingManifest) && (document = (manifest = MergedManifest.get(moduleContainingManifest)).getDocument()) != null) {
                    String text = XmlUtils.toXml((Node)document);
                    return new ByteArrayInputStream(text.getBytes(Charsets.UTF_8));
                }
                try {
                    PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(vFile);
                    if (psiFile != null) {
                        String text = psiFile.getText();
                        return new ByteArrayInputStream(text.getBytes(Charsets.UTF_8));
                    }
                }
                catch (ProcessCanceledException processCanceledException) {
                    // empty catch block
                }
                return super.getInputStream(file);
            }

            @Nullable
            private Module getAndroidModuleForManifest(@NotNull VirtualFile vFile) {
                if (vFile == null) {
                    1.$$$reportNull$$$0(1);
                }
                for (Module m : ModuleManager.getInstance((Project)project).getModules()) {
                    AndroidFacet androidFacet = AndroidFacet.getInstance(m);
                    if (androidFacet == null) continue;
                    List<VirtualFile> manifestFiles = IdeaSourceProvider.getManifestFiles(androidFacet);
                    for (VirtualFile manifestFile : manifestFiles) {
                        if (!vFile.equals(manifestFile)) continue;
                        return m;
                    }
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "vFile";
                        break;
                    }
                }
                objectArray2[1] = "com/android/tools/idea/model/ManifestInfo$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getInputStream";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getAndroidModuleForManifest";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        MergingReport mergingReport = manifestMergerInvoker.merge();
        if (mergingReport == null) {
            ManifestInfo.$$$reportNull$$$0(4);
        }
        return mergingReport;
    }

    @Nullable
    private static String getVersionNameSuffix(@NotNull BaseConfig config) {
        if (config == null) {
            ManifestInfo.$$$reportNull$$$0(5);
        }
        try {
            return config.getVersionNameSuffix();
        }
        catch (UnsupportedMethodException e) {
            Logger.getInstance(ManifestInfo.class).warn("Method 'getVersionNameSuffix' not found", (Throwable)e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primaryManifestFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flavorAndBuildTypeManifests";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libManifests";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/model/ManifestInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/model/ManifestInfo";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMergedManifest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMergedManifest";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getVersionNameSuffix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ManifestFile {
        @NotNull
        private final AndroidFacet myFacet;
        @Nullable
        private Document myDocument;
        @Nullable
        private List<VirtualFile> myManifestFiles;
        @Nullable
        private Map<Object, Long> myLastModifiedMap;
        @Nullable
        private ImmutableList<MergingReport.Record> myLoggingRecords;
        @Nullable
        private Actions myActions;

        private ManifestFile(@NotNull AndroidFacet facet) {
            if (facet == null) {
                ManifestFile.$$$reportNull$$$0(0);
            }
            this.myFacet = facet;
        }

        @NotNull
        public static ManifestFile create(@NotNull AndroidFacet facet) {
            if (facet == null) {
                ManifestFile.$$$reportNull$$$0(1);
            }
            ManifestFile manifestFile = new ManifestFile(facet);
            if (manifestFile == null) {
                ManifestFile.$$$reportNull$$$0(2);
            }
            return manifestFile;
        }

        @Nullable
        private Document parseManifest(@NotNull VirtualFile primaryManifestFile, @NotNull List<VirtualFile> flavorAndBuildTypeManifests, @NotNull List<VirtualFile> libManifests) {
            if (primaryManifestFile == null) {
                ManifestFile.$$$reportNull$$$0(3);
            }
            if (flavorAndBuildTypeManifests == null) {
                ManifestFile.$$$reportNull$$$0(4);
            }
            if (libManifests == null) {
                ManifestFile.$$$reportNull$$$0(5);
            }
            ApplicationManager.getApplication().assertReadAccessAllowed();
            Project project = this.myFacet.getModule().getProject();
            if (project.isDisposed()) {
                return null;
            }
            try {
                MergingReport mergingReport = ManifestInfo.getMergedManifest(this.myFacet, primaryManifestFile, flavorAndBuildTypeManifests, libManifests);
                this.myLoggingRecords = mergingReport.getLoggingRecords();
                this.myActions = mergingReport.getActions();
                XmlDocument doc = mergingReport.getMergedXmlDocument(MergingReport.MergedManifestKind.MERGED);
                if (doc != null) {
                    return doc.getXml();
                }
                Logger.getInstance(ManifestInfo.class).warn("getMergedManifest failed " + mergingReport.getReportString());
            }
            catch (ManifestMerger2.MergeFailureException ex) {
                if (ex.getCause() instanceof ProcessCanceledException) {
                    return null;
                }
                if (ex.getCause() instanceof SAXParseException) {
                    return null;
                }
                Logger.getInstance(ManifestInfo.class).warn("getMergedManifest exception", (Throwable)ex);
            }
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(primaryManifestFile);
            if (psiFile != null) {
                String text = psiFile.getText();
                return XmlUtils.parseDocumentSilently((String)text, (boolean)true);
            }
            return null;
        }

        public boolean refresh() {
            HashMap<Object, Long> lastModifiedMap = new HashMap<Object, Long>();
            VirtualFile primaryManifestFile = AndroidRootUtil.getPrimaryManifestFile(this.myFacet);
            if (primaryManifestFile == null) {
                return false;
            }
            lastModifiedMap.put(primaryManifestFile, this.getFileModificationStamp(primaryManifestFile));
            Project project = this.myFacet.getModule().getProject();
            long lastGradleSyncTimestamp = GradleSyncState.getInstance(project).getSummary().getSyncTimestamp();
            lastModifiedMap.put("gradle-sync", lastGradleSyncTimestamp);
            List<VirtualFile> flavorAndBuildTypeManifests = ManifestFile.getFlavorAndBuildTypeManifests(this.myFacet);
            this.trackChanges(lastModifiedMap, flavorAndBuildTypeManifests);
            List<VirtualFile> libraryManifests = Collections.emptyList();
            if (this.myFacet.isAppProject()) {
                libraryManifests = ManifestFile.getLibManifests(this.myFacet);
                this.trackChanges(lastModifiedMap, libraryManifests);
            }
            ArrayList<VirtualFile> flavorAndBuildTypeManifestsOfLibs = new ArrayList<VirtualFile>();
            List<AndroidFacet> dependencies = AndroidUtils.getAllAndroidDependencies(this.myFacet.getModule(), true);
            for (AndroidFacet dependency : dependencies) {
                flavorAndBuildTypeManifestsOfLibs.addAll(ManifestFile.getFlavorAndBuildTypeManifests(dependency));
            }
            this.trackChanges(lastModifiedMap, flavorAndBuildTypeManifestsOfLibs);
            if (this.myDocument == null || !lastModifiedMap.equals(this.myLastModifiedMap)) {
                this.myDocument = this.parseManifest(primaryManifestFile, flavorAndBuildTypeManifests, libraryManifests);
                if (this.myDocument == null) {
                    this.myManifestFiles = null;
                    return false;
                }
                this.myManifestFiles = Lists.newArrayList();
                this.myManifestFiles.add(primaryManifestFile);
                this.myManifestFiles.addAll(flavorAndBuildTypeManifests);
                this.myManifestFiles.addAll(libraryManifests);
                this.myLastModifiedMap = lastModifiedMap;
                return true;
            }
            return false;
        }

        private void trackChanges(@NotNull Map<Object, Long> lastModifiedMap, @NotNull List<VirtualFile> files) {
            if (lastModifiedMap == null) {
                ManifestFile.$$$reportNull$$$0(6);
            }
            if (files == null) {
                ManifestFile.$$$reportNull$$$0(7);
            }
            for (VirtualFile libraryManifest : files) {
                lastModifiedMap.put(libraryManifest, this.getFileModificationStamp(libraryManifest));
            }
        }

        @NotNull
        private static List<VirtualFile> getFlavorAndBuildTypeManifests(@NotNull AndroidFacet facet) {
            if (facet == null) {
                ManifestFile.$$$reportNull$$$0(8);
            }
            ArrayList<VirtualFile> flavorAndBuildTypeManifests = new ArrayList<VirtualFile>();
            IdeaSourceProvider defaultSourceProvider = facet.getMainIdeaSourceProvider();
            for (IdeaSourceProvider provider : IdeaSourceProvider.getCurrentSourceProviders(facet)) {
                VirtualFile flavorOrBuildTypeManifest;
                if (defaultSourceProvider.equals(provider) || (flavorOrBuildTypeManifest = provider.getManifestFile()) == null) continue;
                flavorAndBuildTypeManifests.add(flavorOrBuildTypeManifest);
            }
            ArrayList<VirtualFile> arrayList = flavorAndBuildTypeManifests;
            if (arrayList == null) {
                ManifestFile.$$$reportNull$$$0(9);
            }
            return arrayList;
        }

        @NotNull
        private static List<VirtualFile> getLibManifests(@NotNull AndroidFacet facet) {
            if (facet == null) {
                ManifestFile.$$$reportNull$$$0(10);
            }
            ArrayList<VirtualFile> libraryManifests = new ArrayList<VirtualFile>();
            List<AndroidFacet> dependencies = AndroidUtils.getAllAndroidDependencies(facet.getModule(), true);
            AndroidModuleModel androidModuleModel = AndroidModuleModel.get(facet);
            if (androidModuleModel != null) {
                Collection libraries = androidModuleModel.getSelectedMainCompileDependencies().getLibraries();
                HashSet<File> set = new HashSet<File>();
                for (AndroidLibrary dependency : libraries) {
                    ManifestFile.addAarManifests(dependency, set, dependencies);
                }
                for (File file : set) {
                    VirtualFile libraryManifest = VfsUtil.findFileByIoFile((File)file, (boolean)false);
                    if (libraryManifest == null) continue;
                    libraryManifests.add(libraryManifest);
                }
            }
            for (AndroidFacet dependency : dependencies) {
                VirtualFile vFile = dependency.getMainIdeaSourceProvider().getManifestFile();
                if (vFile == null) continue;
                libraryManifests.add(vFile);
            }
            ArrayList<VirtualFile> arrayList = libraryManifests;
            if (arrayList == null) {
                ManifestFile.$$$reportNull$$$0(11);
            }
            return arrayList;
        }

        private static void addAarManifests(@NotNull AndroidLibrary lib, @NotNull Set<File> result, @NotNull List<AndroidFacet> moduleDeps) {
            String projectName;
            if (lib == null) {
                ManifestFile.$$$reportNull$$$0(12);
            }
            if (result == null) {
                ManifestFile.$$$reportNull$$$0(13);
            }
            if (moduleDeps == null) {
                ManifestFile.$$$reportNull$$$0(14);
            }
            if ((projectName = lib.getProject()) != null) {
                for (AndroidFacet f : moduleDeps) {
                    if (!projectName.equals(GradleUtil.getGradlePath(f.getModule()))) continue;
                    return;
                }
            }
            if (!result.contains(lib.getManifest())) {
                result.add(lib.getManifest());
                for (AndroidLibrary dependency : lib.getLibraryDependencies()) {
                    ManifestFile.addAarManifests(dependency, result, moduleDeps);
                }
            }
        }

        private long getFileModificationStamp(@NotNull VirtualFile file) {
            if (file == null) {
                ManifestFile.$$$reportNull$$$0(15);
            }
            try {
                PsiFile psiFile = PsiManager.getInstance((Project)this.myFacet.getModule().getProject()).findFile(file);
                return psiFile == null ? file.getModificationStamp() : psiFile.getModificationStamp();
            }
            catch (ProcessCanceledException ignore) {
                return 0L;
            }
        }

        public Document getXmlDocument() {
            return this.myDocument;
        }

        @Nullable
        public List<VirtualFile> getManifestFiles() {
            return this.myManifestFiles;
        }

        @NotNull
        public ImmutableList<MergingReport.Record> getLoggingRecords() {
            ImmutableList<MergingReport.Record> immutableList = this.myLoggingRecords == null ? ImmutableList.of() : this.myLoggingRecords;
            if (immutableList == null) {
                ManifestFile.$$$reportNull$$$0(16);
            }
            return immutableList;
        }

        @Nullable
        public Actions getActions() {
            return this.myActions;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 9: 
                case 11: 
                case 16: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 9: 
                case 11: 
                case 16: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "facet";
                    break;
                }
                case 2: 
                case 9: 
                case 11: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/model/ManifestInfo$ManifestFile";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "primaryManifestFile";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "flavorAndBuildTypeManifests";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "libManifests";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lastModifiedMap";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lib";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleDeps";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/model/ManifestInfo$ManifestFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFlavorAndBuildTypeManifests";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLibManifests";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLoggingRecords";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 2: 
                case 9: 
                case 11: 
                case 16: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "parseManifest";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "trackChanges";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getFlavorAndBuildTypeManifests";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getLibManifests";
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "addAarManifests";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "getFileModificationStamp";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 9: 
                case 11: 
                case 16: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

