/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.android.tools.idea.navigator.nodes.AndroidManifestFileNode;
import com.android.tools.idea.navigator.nodes.DirectoryGroupNode;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidSourceType;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidManifestsGroupNode
extends ProjectViewNode<AndroidFacet>
implements DirectoryGroupNode {
    private static final String MANIFESTS_NODE = "manifests";
    @NotNull
    private final Set<VirtualFile> mySources;

    protected AndroidManifestsGroupNode(@NotNull Project project, @NotNull AndroidFacet facet, @NotNull ViewSettings viewSettings, @NotNull Set<VirtualFile> sources) {
        if (project == null) {
            AndroidManifestsGroupNode.$$$reportNull$$$0(0);
        }
        if (facet == null) {
            AndroidManifestsGroupNode.$$$reportNull$$$0(1);
        }
        if (viewSettings == null) {
            AndroidManifestsGroupNode.$$$reportNull$$$0(2);
        }
        if (sources == null) {
            AndroidManifestsGroupNode.$$$reportNull$$$0(3);
        }
        super(project, (Object)facet, viewSettings);
        this.mySources = sources;
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            AndroidManifestsGroupNode.$$$reportNull$$$0(4);
        }
        return this.mySources.contains(file);
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        ArrayList children = Lists.newArrayList();
        for (VirtualFile manifest : this.mySources) {
            PsiFile psiFile;
            if (!manifest.isValid() || (psiFile = psiManager.findFile(manifest)) == null) continue;
            AndroidFacet facet = (AndroidFacet)((Object)this.getValue());
            assert (facet != null) : "Android Facet for module cannot be null";
            children.add(new AndroidManifestFileNode(this.myProject, psiFile, this.getSettings(), facet));
        }
        ArrayList arrayList = children;
        if (arrayList == null) {
            AndroidManifestsGroupNode.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    protected void update(PresentationData presentation) {
        presentation.addText(MANIFESTS_NODE, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        Icon icon = AndroidSourceType.MANIFEST.getIcon();
        if (icon != null) {
            presentation.setIcon(icon);
        }
        presentation.setPresentableText(MANIFESTS_NODE);
    }

    public boolean expandOnDoubleClick() {
        return false;
    }

    public boolean canNavigate() {
        return !this.mySources.isEmpty();
    }

    public void navigate(boolean requestFocus) {
        VirtualFile fileToOpen = this.findFileToOpen(this.mySources);
        if (fileToOpen == null) {
            return;
        }
        new OpenFileDescriptor(this.myProject, fileToOpen).navigate(requestFocus);
    }

    @Nullable
    private VirtualFile findFileToOpen(@NotNull Set<VirtualFile> files) {
        if (files == null) {
            AndroidManifestsGroupNode.$$$reportNull$$$0(6);
        }
        VirtualFile bestFile = (VirtualFile)Iterables.getFirst(files, null);
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        for (VirtualFile f : files) {
            IdeaSourceProvider sourceProvider;
            PsiFile psiFile = psiManager.findFile(f);
            if (psiFile == null || (sourceProvider = AndroidManifestFileNode.getSourceProvider((AndroidFacet)((Object)this.getValue()), psiFile)) == null || !"main".equals(sourceProvider.getName())) continue;
            bestFile = f;
        }
        return bestFile;
    }

    @Override
    @NotNull
    public PsiDirectory[] getDirectories() {
        if (PsiDirectory.EMPTY_ARRAY == null) {
            AndroidManifestsGroupNode.$$$reportNull$$$0(7);
        }
        return PsiDirectory.EMPTY_ARRAY;
    }

    @Nullable
    public Comparable getSortKey() {
        return AndroidSourceType.MANIFEST;
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return AndroidSourceType.MANIFEST;
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return MANIFESTS_NODE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sources";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/AndroidManifestsGroupNode";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/AndroidManifestsGroupNode";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findFileToOpen";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

