/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.navigator.AndroidProjectTreeBuilder;
import com.android.tools.idea.navigator.AndroidProjectViewPane;
import com.android.tools.idea.navigator.nodes.AndroidResFolderTypeNode;
import com.android.tools.idea.navigator.nodes.AndroidSourceTypeNode;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidSourceType;
import org.jetbrains.annotations.NotNull;

public class AndroidResFolderNode
extends AndroidSourceTypeNode {
    public AndroidResFolderNode(@NotNull Project project, @NotNull AndroidFacet facet, @NotNull ViewSettings viewSettings, @NotNull Set<VirtualFile> sourceRoots, @NotNull AndroidProjectViewPane projectViewPane) {
        if (project == null) {
            AndroidResFolderNode.$$$reportNull$$$0(0);
        }
        if (facet == null) {
            AndroidResFolderNode.$$$reportNull$$$0(1);
        }
        if (viewSettings == null) {
            AndroidResFolderNode.$$$reportNull$$$0(2);
        }
        if (sourceRoots == null) {
            AndroidResFolderNode.$$$reportNull$$$0(3);
        }
        if (projectViewPane == null) {
            AndroidResFolderNode.$$$reportNull$$$0(4);
        }
        super(project, facet, viewSettings, AndroidSourceType.RES, sourceRoots, projectViewPane);
    }

    @Override
    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        ArrayList resFolders = Lists.newArrayList();
        for (PsiDirectory psiDirectory : this.getSourceDirectories()) {
            resFolders.addAll(Lists.newArrayList((Object[])psiDirectory.getSubdirectories()));
        }
        HashMultimap foldersByResourceType = HashMultimap.create();
        for (PsiDirectory resFolder : resFolders) {
            ResourceFolderType type = ResourceFolderType.getFolderType((String)resFolder.getName());
            if (type == null) continue;
            foldersByResourceType.put((Object)type, (Object)resFolder);
        }
        AndroidProjectTreeBuilder androidProjectTreeBuilder = (AndroidProjectTreeBuilder)this.myProjectViewPane.getTreeBuilder();
        ArrayList children = Lists.newArrayListWithExpectedSize((int)foldersByResourceType.size());
        for (ResourceFolderType type : foldersByResourceType.keySet()) {
            Set folders = foldersByResourceType.get((Object)type);
            AndroidResFolderTypeNode androidResFolderTypeNode = new AndroidResFolderTypeNode(this.myProject, (AndroidFacet)((Object)this.getValue()), Lists.newArrayList((Iterable)folders), this.getSettings(), type, this.myProjectViewPane);
            children.add(androidResFolderTypeNode);
            for (PsiDirectory folder : folders) {
                androidProjectTreeBuilder.createMapping(folder.getVirtualFile(), (AbstractTreeNode)androidResFolderTypeNode);
            }
        }
        ArrayList arrayList = children;
        if (arrayList == null) {
            AndroidResFolderNode.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRoots";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectViewPane";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/AndroidResFolderNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/AndroidResFolderNode";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

