/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.module;

import com.android.tools.adtui.LabelWithEditLink;
import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.npw.module.AppNameToModuleNameExpression;
import com.android.tools.idea.npw.module.FormFactorApiComboBox;
import com.android.tools.idea.npw.module.NewModuleModel;
import com.android.tools.idea.npw.platform.AndroidVersionsInfo;
import com.android.tools.idea.npw.project.AndroidProjectPaths;
import com.android.tools.idea.npw.project.AndroidSourceSet;
import com.android.tools.idea.npw.project.DomainToPackageExpression;
import com.android.tools.idea.npw.project.NewProjectModel;
import com.android.tools.idea.npw.template.ChooseActivityTypeStep;
import com.android.tools.idea.npw.template.RenderTemplateModel;
import com.android.tools.idea.npw.template.TemplateHandle;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.ui.properties.BindingsManager;
import com.android.tools.idea.ui.properties.ListenerManager;
import com.android.tools.idea.ui.properties.core.BoolValueProperty;
import com.android.tools.idea.ui.properties.core.StringValueProperty;
import com.android.tools.idea.ui.properties.expressions.Expression;
import com.android.tools.idea.ui.properties.swing.SelectedItemProperty;
import com.android.tools.idea.ui.properties.swing.TextProperty;
import com.android.tools.idea.ui.validation.Validator;
import com.android.tools.idea.ui.validation.ValidatorPanel;
import com.android.tools.idea.ui.validation.validators.PathValidator;
import com.android.tools.idea.ui.wizard.StudioWizardStepPanel;
import com.android.tools.idea.ui.wizard.WizardUtils;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.model.SkippableWizardStep;
import com.android.tools.swing.util.FormScalingUtil;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfigureAndroidModuleStep
extends SkippableWizardStep<NewModuleModel> {
    @NotNull
    private final StudioWizardStepPanel myRootPanel;
    @NotNull
    private final FormFactor myFormFactor;
    private final BindingsManager myBindings;
    private final ListenerManager myListeners;
    private final int myMinSdkLevel;
    private ChooseActivityTypeStep myChooseActivityTypeStep;
    private FormFactorApiComboBox mySdkControls;
    private JTextField myModuleName;
    private JPanel myPanel;
    private JTextField myAppName;
    private LabelWithEditLink myPackageName;

    public ConfigureAndroidModuleStep(@NotNull NewModuleModel model, @NotNull FormFactor formFactor, int minSdkLevel, @NotNull String title) {
        if (model == null) {
            ConfigureAndroidModuleStep.$$$reportNull$$$0(0);
        }
        if (formFactor == null) {
            ConfigureAndroidModuleStep.$$$reportNull$$$0(1);
        }
        if (title == null) {
            ConfigureAndroidModuleStep.$$$reportNull$$$0(2);
        }
        super(model, title);
        this.$$$setupUI$$$();
        this.myBindings = new BindingsManager();
        this.myListeners = new ListenerManager();
        this.myFormFactor = formFactor;
        this.myMinSdkLevel = minSdkLevel;
        StringValueProperty companyDomain = new StringValueProperty(NewProjectModel.getInitialDomain(false));
        TextProperty packageNameText = new TextProperty(this.myPackageName);
        TextProperty moduleNameText = new TextProperty(this.myModuleName);
        DomainToPackageExpression computedPackageName = new DomainToPackageExpression(companyDomain, model.applicationName());
        BoolValueProperty isPackageNameSynced = new BoolValueProperty(true);
        this.myBindings.bind(packageNameText, computedPackageName, isPackageNameSynced);
        this.myBindings.bind(model.packageName(), packageNameText);
        this.myListeners.receive(packageNameText, value -> isPackageNameSynced.set(value.equals(computedPackageName.get())));
        Project project = ((NewModuleModel)this.getModel()).getProject().getValue();
        AppNameToModuleNameExpression computedModuleName = new AppNameToModuleNameExpression(project, model.applicationName());
        BoolValueProperty isModuleNameSynced = new BoolValueProperty(true);
        this.myBindings.bind(moduleNameText, computedModuleName, isModuleNameSynced);
        this.myBindings.bind(model.moduleName(), moduleNameText);
        this.myListeners.receive(moduleNameText, value -> isModuleNameSynced.set(value.equals(computedModuleName.get())));
        this.myBindings.bindTwoWay(new TextProperty(this.myAppName), model.applicationName());
        ValidatorPanel validatorPanel = new ValidatorPanel(this, this.myPanel);
        validatorPanel.registerValidator(model.applicationName(), value -> {
            if (model == null) {
                ConfigureAndroidModuleStep.$$$reportNull$$$0(7);
            }
            if (value.isEmpty()) {
                return new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("android.wizard.validate.empty.application.name", new Object[0]));
            }
            if (!((Boolean)model.isLibrary().get()).booleanValue() && !Character.isUpperCase(value.charAt(0))) {
                return new Validator.Result(Validator.Severity.INFO, AndroidBundle.message("android.wizard.validate.lowercase.application.name", new Object[0]));
            }
            return Validator.Result.OK;
        });
        Expression<File> locationFile = model.moduleName().transform(str -> new File(project.getBasePath(), (String)str));
        validatorPanel.registerValidator(locationFile, PathValidator.createDefault("module location"));
        validatorPanel.registerValidator(model.packageName(), value -> Validator.Result.fromNullableMessage(WizardUtils.validatePackageName(value)));
        this.myRootPanel = new StudioWizardStepPanel(validatorPanel, AndroidBundle.message("android.wizard.module.config.title", new Object[0]));
        FormScalingUtil.scaleComponentTree(this.getClass(), this.myRootPanel);
    }

    @Override
    protected void onWizardStarting(@NotNull ModelWizard.Facade wizard) {
        if (wizard == null) {
            ConfigureAndroidModuleStep.$$$reportNull$$$0(3);
        }
        this.myListeners.listen(((NewModuleModel)this.getModel()).isLibrary(), sender -> {
            if (wizard == null) {
                ConfigureAndroidModuleStep.$$$reportNull$$$0(6);
            }
            this.myChooseActivityTypeStep.setShouldShow((Boolean)((NewModuleModel)this.getModel()).isLibrary().get() == false);
            wizard.updateNavigationProperties();
        });
    }

    @Override
    @NotNull
    protected Collection<? extends ModelWizardStep> createDependentSteps() {
        List<TemplateHandle> templateList = TemplateManager.getInstance().getTemplateList(this.myFormFactor);
        AndroidSourceSet dummySourceSet = new AndroidSourceSet("main", new AndroidProjectPaths(new File("")));
        RenderTemplateModel renderModel = new RenderTemplateModel(((NewModuleModel)this.getModel()).getProject(), ((NewModuleModel)this.getModel()).packageName(), templateList.get(0), dummySourceSet, AndroidBundle.message("android.wizard.activity.add", new Object[0]));
        this.myListeners.listenAll(((NewModuleModel)this.getModel()).getProject(), ((NewModuleModel)this.getModel()).moduleName()).withAndFire(() -> {
            String moduleName = (String)((NewModuleModel)this.getModel()).moduleName().get();
            Project project = ((NewModuleModel)this.getModel()).getProject().getValue();
            renderModel.getSourceSet().set(new AndroidSourceSet("main", new AndroidProjectPaths(new File(project.getBasePath(), moduleName))));
        });
        this.myBindings.bind(renderModel.androidSdkInfo(), new SelectedItemProperty(this.mySdkControls));
        this.myChooseActivityTypeStep = new ChooseActivityTypeStep((NewModuleModel)this.getModel(), renderModel, templateList, Lists.newArrayList());
        ArrayList arrayList = Lists.newArrayList((Object[])new ChooseActivityTypeStep[]{this.myChooseActivityTypeStep});
        if (arrayList == null) {
            ConfigureAndroidModuleStep.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Override
    protected void onEntering() {
        AndroidVersionsInfo androidVersionsInfo = new AndroidVersionsInfo();
        androidVersionsInfo.load();
        androidVersionsInfo.loadTargetVersions(this.myFormFactor, this.myMinSdkLevel, items -> this.mySdkControls.init(this.myFormFactor, items));
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        StudioWizardStepPanel studioWizardStepPanel = this.myRootPanel;
        if (studioWizardStepPanel == null) {
            ConfigureAndroidModuleStep.$$$reportNull$$$0(5);
        }
        return studioWizardStepPanel;
    }

    @Override
    @Nullable
    protected JComponent getPreferredFocusComponent() {
        return this.myAppName;
    }

    private void createUIComponents() {
        this.mySdkControls = new FormFactorApiComboBox();
    }

    @Override
    public void dispose() {
        this.myBindings.releaseAll();
        this.myListeners.releaseAll();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formFactor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizard";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/module/ConfigureAndroidModuleStep";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/module/ConfigureAndroidModuleStep";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDependentSteps";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onWizardStarting";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$onWizardStarting$5";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        LabelWithEditLink labelWithEditLink;
        JTextField jTextField2;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 5, 0, 0), -1, -1, false, false));
        this.myAppName = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(0, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Application/Library name:");
        jLabel.setDisplayedMnemonic('A');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Package name:");
        jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 2, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myPackageName = labelWithEditLink = new LabelWithEditLink();
        jPanel.add((Component)labelWithEditLink, new GridConstraints(2, 1, 1, 2, 0, 1, 3, 3, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Module name:");
        jLabel3.setDisplayedMnemonic('M');
        jLabel3.setDisplayedMnemonicIndex(0);
        ((Component)jLabel3).setVisible(true);
        jPanel.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myModuleName = jTextField = new JTextField();
        ((Component)jTextField).setVisible(true);
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Minimum SDK");
        jPanel.add((Component)jLabel4, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        FormFactorApiComboBox formFactorApiComboBox = this.mySdkControls;
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        formFactorApiComboBox.setModel(defaultComboBoxModel);
        jPanel.add((Component)formFactorApiComboBox, new GridConstraints(3, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        jLabel.setLabelFor(jTextField2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

