/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.util;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.model.MergedManifest;
import com.android.tools.idea.run.activity.ActivityLocatorUtils;
import com.android.tools.lint.detector.api.LintUtils;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LaunchUtils {
    private static final Pattern idKeyPattern = Pattern.compile("--user\\s+([0-9]+)");

    public static boolean canDebugAppOnDevice(@NotNull AndroidFacet facet, @NotNull IDevice device) {
        if (facet == null) {
            LaunchUtils.$$$reportNull$$$0(0);
        }
        if (device == null) {
            LaunchUtils.$$$reportNull$$$0(1);
        }
        if (device.isEmulator()) {
            return true;
        }
        Boolean isDebuggable = AndroidModuleInfo.get(facet).isDebuggable();
        if (isDebuggable == null || isDebuggable.booleanValue()) {
            return true;
        }
        String buildType = device.getProperty("ro.build.type");
        return "userdebug".equals(buildType) || "eng".equals(buildType);
    }

    public static boolean isWatchFaceApp(@NotNull AndroidFacet facet) {
        if (facet == null) {
            LaunchUtils.$$$reportNull$$$0(2);
        }
        if (AndroidFacet.getInstance(facet.getModule()) == null) {
            Logger.getInstance(LaunchUtils.class).warn("calling isWatchFaceApp when facet is not ready yet");
            return false;
        }
        MergedManifest info = MergedManifest.get(facet);
        if (!info.getActivities().isEmpty()) {
            return false;
        }
        List<Element> services = info.getServices();
        if (services.size() != 1) {
            return false;
        }
        Element service = services.get(0);
        List filters = LintUtils.getChildren((Node)service);
        return filters.size() == 1 && ActivityLocatorUtils.containsAction((Element)filters.get(0), "android.service.wallpaper.WallpaperService") && ActivityLocatorUtils.containsCategory((Element)filters.get(0), "com.google.android.wearable.watchface.category.WATCH_FACE");
    }

    public static boolean isWatchFeatureRequired(@NotNull AndroidFacet facet) {
        MergedManifest mergedManifest;
        Element feature;
        if (facet == null) {
            LaunchUtils.$$$reportNull$$$0(3);
        }
        return (feature = (mergedManifest = MergedManifest.get(facet)).findUsedFeature("android.hardware.type.watch")) != null && LaunchUtils.isRequired(feature);
    }

    private static boolean isRequired(@NotNull Element feature) {
        Attr requiredNode;
        if (feature == null) {
            LaunchUtils.$$$reportNull$$$0(4);
        }
        if ((requiredNode = feature.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "required")) == null) {
            return true;
        }
        return "true".equals(requiredNode.getValue());
    }

    public static void showNotification(final @NotNull Project project, final @NotNull Executor executor, final @NotNull String sessionName, final @NotNull String message, final @NotNull NotificationType type) {
        if (project == null) {
            LaunchUtils.$$$reportNull$$$0(5);
        }
        if (executor == null) {
            LaunchUtils.$$$reportNull$$$0(6);
        }
        if (sessionName == null) {
            LaunchUtils.$$$reportNull$$$0(7);
        }
        if (message == null) {
            LaunchUtils.$$$reportNull$$$0(8);
        }
        if (type == null) {
            LaunchUtils.$$$reportNull$$$0(9);
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (project.isDisposed()) {
                    return;
                }
                String toolWindowId = executor.getToolWindowId();
                final ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(toolWindowId);
                if (toolWindow.isVisible()) {
                    return;
                }
                String notificationMessage = "Session <a href=''>'" + sessionName + "'</a>: " + message;
                NotificationGroup group = this.getNotificationGroup(toolWindowId);
                group.createNotification("", notificationMessage, type, new NotificationListener(){

                    public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                        if (notification == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (event == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                            RunContentManager contentManager = ExecutionManager.getInstance((Project)project).getContentManager();
                            for (RunContentDescriptor d : contentManager.getAllDescriptors()) {
                                if (!sessionName.equals(d.getDisplayName())) continue;
                                Content content = d.getAttachedContent();
                                if (content != null) {
                                    content.getManager().setSelectedContent(content);
                                }
                                toolWindow.activate(null, true, true);
                                break;
                            }
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "notification";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "event";
                                break;
                            }
                        }
                        objectArray[1] = "com/android/tools/idea/run/util/LaunchUtils$1$1";
                        objectArray[2] = "hyperlinkUpdate";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }).notify(project);
            }

            @NotNull
            private NotificationGroup getNotificationGroup(@NotNull String toolWindowId) {
                String displayId;
                NotificationGroup group;
                if (toolWindowId == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((group = NotificationGroup.findRegisteredGroup((String)(displayId = "Launch Notifications for " + toolWindowId))) == null) {
                    group = NotificationGroup.toolWindowGroup((String)displayId, (String)toolWindowId);
                }
                NotificationGroup notificationGroup = group;
                if (notificationGroup == null) {
                    1.$$$reportNull$$$0(1);
                }
                return notificationGroup;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "toolWindowId";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/android/tools/idea/run/util/LaunchUtils$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/android/tools/idea/run/util/LaunchUtils$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNotificationGroup";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getNotificationGroup";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    public static void initiateDismissKeyguard(final @NotNull IDevice device) {
        AndroidVersion canDismissKeyguard;
        if (device == null) {
            LaunchUtils.$$$reportNull$$$0(10);
        }
        if ((canDismissKeyguard = new AndroidVersion(23, null)).compareTo(device.getVersion()) <= 0) {
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        device.executeShellCommand("wm dismiss-keyguard", (IShellOutputReceiver)new NullOutputReceiver(), 10L, TimeUnit.SECONDS);
                    }
                    catch (Exception e) {
                        Logger.getInstance(LaunchUtils.class).warn("Unable to dismiss keyguard before launching activity");
                    }
                }
            });
        }
    }

    @Nullable
    public static Integer getUserIdFromFlags(@Nullable String flags) {
        if (flags == null) {
            return null;
        }
        Matcher m = idKeyPattern.matcher(flags);
        return m.find() ? Integer.valueOf(Integer.parseInt(m.group(1))) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "feature";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/run/util/LaunchUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canDebugAppOnDevice";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isWatchFaceApp";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isWatchFeatureRequired";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isRequired";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "showNotification";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "initiateDismissKeyguard";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

