/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors.support;

import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class IdAnalyzer {
    private final NlProperty myProperty;
    private final Set<String> myReservedIds;
    private final PropertyGroup myPropertyGroup;
    private final Set<String> myResult;
    private static final PropertyGroup DEFAULT_GROUP = new PropertyGroup("http://schemas.android.com/apk/res/android", (List<String>)ImmutableList.of());
    private static final PropertyGroup RELATIVE_LAYOUT_GROUP = new SiblingValuePropertyGroup("http://schemas.android.com/apk/res/android", (List<String>)ImmutableList.of((Object)"layout_toRightOf", (Object)"layout_toLeftOf", (Object)"layout_above", (Object)"layout_below", (Object)"layout_alignBaseline", (Object)"layout_alignLeft", (Object)"layout_alignTop", (Object)"layout_alignRight", (Object)"layout_alignBottom", (Object)"layout_alignStart", (Object)"layout_alignEnd", (Object)"layout_toStartOf", (Object[])new String[]{"layout_toEndOf"}));
    private static final PropertyGroup CONSTRAINT_LAYOUT_GROUP = new SiblingValuePropertyGroup("http://schemas.android.com/apk/res-auto", (List<String>)ImmutableList.of((Object)"layout_constraintLeft_toLeftOf", (Object)"layout_constraintLeft_toRightOf", (Object)"layout_constraintRight_toLeftOf", (Object)"layout_constraintRight_toRightOf", (Object)"layout_constraintTop_toTopOf", (Object)"layout_constraintTop_toBottomOf", (Object)"layout_constraintBottom_toTopOf", (Object)"layout_constraintBottom_toBottomOf", (Object)"layout_constraintBaseline_toBaselineOf"));
    private static final PropertyGroup RADIO_GROUP = new ChildTagPropertyGroup("http://schemas.android.com/apk/res-auto", (List<String>)ImmutableList.of((Object)"checkedButton"), "RadioButton");
    private static final List<PropertyGroup> PROPERTY_GROUPS = ImmutableList.of((Object)RELATIVE_LAYOUT_GROUP, (Object)CONSTRAINT_LAYOUT_GROUP, (Object)RADIO_GROUP);

    public IdAnalyzer(@NotNull NlProperty property) {
        if (property == null) {
            IdAnalyzer.$$$reportNull$$$0(0);
        }
        this.myProperty = property;
        this.myPropertyGroup = IdAnalyzer.findPropertyGroup(property.getName());
        this.myReservedIds = new HashSet<String>();
        this.myResult = new HashSet<String>();
    }

    @NotNull
    public List<String> findIds() {
        this.myPropertyGroup.findIds(this);
        List<String> list = this.myResult.stream().sorted().collect(Collectors.toList());
        if (list == null) {
            IdAnalyzer.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    private static PropertyGroup findPropertyGroup(@NotNull String attributeName) {
        if (attributeName == null) {
            IdAnalyzer.$$$reportNull$$$0(2);
        }
        for (PropertyGroup group : PROPERTY_GROUPS) {
            if (!group.myAttributes.contains(attributeName)) continue;
            PropertyGroup propertyGroup = group;
            if (propertyGroup == null) {
                IdAnalyzer.$$$reportNull$$$0(3);
            }
            return propertyGroup;
        }
        PropertyGroup propertyGroup = DEFAULT_GROUP;
        if (propertyGroup == null) {
            IdAnalyzer.$$$reportNull$$$0(4);
        }
        return propertyGroup;
    }

    private void findIdsAmongSiblings() {
        List parents = this.myProperty.getComponents().stream().map(NlComponent::getParent).distinct().collect(Collectors.toList());
        if (parents.size() == 1) {
            NlComponent parent = (NlComponent)parents.get(0);
            this.reserveAllSelectedIds();
            if (!this.myReservedIds.isEmpty()) {
                this.reserveAllIdsWithTransitiveReferencesToSelectedIds(parent);
            }
            parent.getChildren().stream().map(NlComponent::getId).filter(id -> !StringUtil.isEmpty((String)id)).filter(id -> !this.myReservedIds.contains(id)).forEach(this.myResult::add);
        }
    }

    private void reserveAllSelectedIds() {
        this.myProperty.getComponents().stream().map(NlComponent::getId).filter(id -> !StringUtil.isEmpty((String)id)).forEach(this.myReservedIds::add);
    }

    private void reserveAllIdsWithTransitiveReferencesToSelectedIds(@NotNull NlComponent parent) {
        if (parent == null) {
            IdAnalyzer.$$$reportNull$$$0(5);
        }
        HashMultimap referenceMap = HashMultimap.create();
        for (NlComponent component : parent.getChildren()) {
            String id2 = component.getId();
            if (StringUtil.isEmpty((String)id2)) continue;
            for (String attribute : this.myPropertyGroup.myAttributes) {
                String referenced = NlComponent.stripId(component.getAttribute(this.myPropertyGroup.myNamespace, attribute));
                if (referenced == null) continue;
                referenceMap.put((Object)referenced, (Object)id2);
            }
        }
        HashSet<String> references = new HashSet<String>(this.myReservedIds);
        while (!references.isEmpty()) {
            String reference = (String)references.iterator().next();
            references.remove(reference);
            this.myReservedIds.add(reference);
            referenceMap.get((Object)reference).stream().filter(id -> !this.myReservedIds.contains(id)).forEach(references::add);
        }
    }

    private void findChildIdsWithTagName(@NotNull String childTagName) {
        List<NlComponent> components;
        if (childTagName == null) {
            IdAnalyzer.$$$reportNull$$$0(6);
        }
        if ((components = this.myProperty.getComponents()).size() == 1) {
            components.get(0).getChildren().stream().filter(component -> {
                if (childTagName == null) {
                    IdAnalyzer.$$$reportNull$$$0(7);
                }
                return component.getTagName().equals(childTagName);
            }).map(NlComponent::getId).filter(id -> !StringUtil.isEmpty((String)id)).forEach(this.myResult::add);
        }
    }

    private void findAllIds() {
        this.reserveAllSelectedIds();
        this.myProperty.getModel().flattenComponents().map(NlComponent::getId).filter(id -> !StringUtil.isEmpty((String)id)).filter(id -> !this.myReservedIds.contains(id)).forEach(this.myResult::add);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/property/editors/support/IdAnalyzer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTagName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/property/editors/support/IdAnalyzer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findIds";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findPropertyGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findPropertyGroup";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "reserveAllIdsWithTransitiveReferencesToSelectedIds";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findChildIdsWithTagName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findChildIdsWithTagName$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ChildTagPropertyGroup
    extends PropertyGroup {
        private final String myChildTagName;

        ChildTagPropertyGroup(@NotNull String namespace, @NotNull List<String> attributes, @NotNull String childTagName) {
            if (namespace == null) {
                ChildTagPropertyGroup.$$$reportNull$$$0(0);
            }
            if (attributes == null) {
                ChildTagPropertyGroup.$$$reportNull$$$0(1);
            }
            if (childTagName == null) {
                ChildTagPropertyGroup.$$$reportNull$$$0(2);
            }
            super(namespace, attributes);
            this.myChildTagName = childTagName;
        }

        @Override
        protected void findIds(@NotNull IdAnalyzer analyzer) {
            if (analyzer == null) {
                ChildTagPropertyGroup.$$$reportNull$$$0(3);
            }
            analyzer.findChildIdsWithTagName(this.myChildTagName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespace";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "childTagName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "analyzer";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/property/editors/support/IdAnalyzer$ChildTagPropertyGroup";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findIds";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SiblingValuePropertyGroup
    extends PropertyGroup {
        SiblingValuePropertyGroup(@NotNull String namespace, @NotNull List<String> attributes) {
            if (namespace == null) {
                SiblingValuePropertyGroup.$$$reportNull$$$0(0);
            }
            if (attributes == null) {
                SiblingValuePropertyGroup.$$$reportNull$$$0(1);
            }
            super(namespace, attributes);
        }

        @Override
        protected void findIds(@NotNull IdAnalyzer analyzer) {
            if (analyzer == null) {
                SiblingValuePropertyGroup.$$$reportNull$$$0(2);
            }
            analyzer.findIdsAmongSiblings();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespace";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "analyzer";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/property/editors/support/IdAnalyzer$SiblingValuePropertyGroup";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findIds";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PropertyGroup {
        private final String myNamespace;
        private final List<String> myAttributes;

        PropertyGroup(@NotNull String namespace, @NotNull List<String> attributes) {
            if (namespace == null) {
                PropertyGroup.$$$reportNull$$$0(0);
            }
            if (attributes == null) {
                PropertyGroup.$$$reportNull$$$0(1);
            }
            this.myNamespace = namespace;
            this.myAttributes = attributes;
        }

        protected void findIds(@NotNull IdAnalyzer analyzer) {
            if (analyzer == null) {
                PropertyGroup.$$$reportNull$$$0(2);
            }
            analyzer.findAllIds();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespace";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "analyzer";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/property/editors/support/IdAnalyzer$PropertyGroup";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findIds";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

