/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.inspector;

import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.property.NlPropertiesManager;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.NlComponentEditor;
import com.android.tools.idea.uibuilder.property.inspector.InspectorComponent;
import com.android.tools.idea.uibuilder.property.inspector.InspectorPanel;
import com.android.tools.idea.uibuilder.property.inspector.InspectorProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import icons.AndroidIcons;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

public class ViewInspectorProvider
implements InspectorProvider {
    private static final Set<String> TAG_EXCEPTIONS = ImmutableSet.of((Object)"TextView", (Object)"ProgressBar");
    private final ViewHandlerManager myViewHandlerManager;
    private final Map<String, InspectorComponent> myInspectors;

    public ViewInspectorProvider(@NotNull Project project) {
        if (project == null) {
            ViewInspectorProvider.$$$reportNull$$$0(0);
        }
        this.myViewHandlerManager = ViewHandlerManager.get(project);
        this.myInspectors = new HashMap<String, InspectorComponent>();
    }

    @Override
    public boolean isApplicable(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        if (components == null) {
            ViewInspectorProvider.$$$reportNull$$$0(1);
        }
        if (properties == null) {
            ViewInspectorProvider.$$$reportNull$$$0(2);
        }
        if (propertiesManager == null) {
            ViewInspectorProvider.$$$reportNull$$$0(3);
        }
        if (components.size() != 1) {
            return false;
        }
        String tagName = components.get(0).getTagName();
        if (TAG_EXCEPTIONS.contains(tagName)) {
            return false;
        }
        if (this.myInspectors.containsKey(tagName)) {
            return true;
        }
        ViewHandler handler = this.myViewHandlerManager.getHandler(tagName);
        if (handler == null || handler.getInspectorProperties().isEmpty()) {
            return false;
        }
        this.myInspectors.put(tagName, new ViewInspectorComponent(tagName, properties, propertiesManager, handler.getInspectorProperties()));
        return true;
    }

    @Override
    @NotNull
    public InspectorComponent createCustomInspector(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        if (components == null) {
            ViewInspectorProvider.$$$reportNull$$$0(4);
        }
        if (properties == null) {
            ViewInspectorProvider.$$$reportNull$$$0(5);
        }
        if (propertiesManager == null) {
            ViewInspectorProvider.$$$reportNull$$$0(6);
        }
        assert (components.size() == 1);
        String tagName = components.get(0).getTagName();
        InspectorComponent inspector = this.myInspectors.get(tagName);
        assert (inspector != null);
        inspector.updateProperties(components, properties, propertiesManager);
        InspectorComponent inspectorComponent = inspector;
        if (inspectorComponent == null) {
            ViewInspectorProvider.$$$reportNull$$$0(7);
        }
        return inspectorComponent;
    }

    @Override
    public void resetCache() {
        this.myInspectors.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesManager";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomInspector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createCustomInspector";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ViewInspectorComponent
    implements InspectorComponent {
        private static final List<String> LAYOUT_PROPERTIES = ImmutableList.of((Object)"layout_scrollFlags", (Object)"layout_collapseMode", (Object)"layout_collapseParallaxMultiplier", (Object)"layout_behavior");
        private final String myComponentName;
        private final List<String> myPropertyNames;
        private final List<NlComponentEditor> myEditors;
        private final int mySrcPropertyIndex;

        public ViewInspectorComponent(@NotNull String tagName, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager, @NotNull List<String> propertyNames) {
            if (tagName == null) {
                ViewInspectorComponent.$$$reportNull$$$0(0);
            }
            if (properties == null) {
                ViewInspectorComponent.$$$reportNull$$$0(1);
            }
            if (propertiesManager == null) {
                ViewInspectorComponent.$$$reportNull$$$0(2);
            }
            if (propertyNames == null) {
                ViewInspectorComponent.$$$reportNull$$$0(3);
            }
            this.myComponentName = tagName.substring(tagName.lastIndexOf(46) + 1);
            this.myPropertyNames = ViewInspectorComponent.combineLists(propertyNames, LAYOUT_PROPERTIES);
            this.mySrcPropertyIndex = this.myPropertyNames.indexOf("src");
            this.myEditors = new ArrayList<NlComponentEditor>(this.myPropertyNames.size());
            this.createEditors(properties, propertiesManager);
        }

        private void createEditors(@NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
            if (properties == null) {
                ViewInspectorComponent.$$$reportNull$$$0(4);
            }
            if (propertiesManager == null) {
                ViewInspectorComponent.$$$reportNull$$$0(5);
            }
            for (String propertyName : this.myPropertyNames) {
                boolean designPropertyRequired = propertyName.startsWith("tools:");
                NlProperty property = properties.get(propertyName = StringUtil.trimStart((String)propertyName, (String)"tools:"));
                if (property == null) continue;
                if (designPropertyRequired) {
                    property = property.getDesignTimeProperty();
                }
                NlComponentEditor editor = propertiesManager.getPropertyEditors().create(property);
                editor.setProperty(property);
                this.myEditors.add(editor);
            }
        }

        @Override
        public void updateProperties(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
            if (components == null) {
                ViewInspectorComponent.$$$reportNull$$$0(6);
            }
            if (properties == null) {
                ViewInspectorComponent.$$$reportNull$$$0(7);
            }
            if (propertiesManager == null) {
                ViewInspectorComponent.$$$reportNull$$$0(8);
            }
            this.useSrcCompatIfExist(properties);
            this.myEditors.clear();
            this.createEditors(properties, propertiesManager);
        }

        @Override
        @NotNull
        public List<NlComponentEditor> getEditors() {
            List<NlComponentEditor> list = this.myEditors;
            if (list == null) {
                ViewInspectorComponent.$$$reportNull$$$0(9);
            }
            return list;
        }

        @Override
        public int getMaxNumberOfRows() {
            return 1 + this.myEditors.size();
        }

        @Override
        public void attachToInspector(@NotNull InspectorPanel inspector) {
            if (inspector == null) {
                ViewInspectorComponent.$$$reportNull$$$0(10);
            }
            this.refresh();
            inspector.addTitle(this.myComponentName);
            for (NlComponentEditor editor : this.myEditors) {
                NlProperty property = editor.getProperty();
                if (property == null) continue;
                String propertyName = property.getName();
                JLabel label = inspector.addComponent(propertyName, property.getTooltipText(), editor.getComponent());
                if ("http://schemas.android.com/tools".equals(property.getNamespace())) {
                    label.setIcon(AndroidIcons.NeleIcons.DesignProperty);
                }
                editor.setLabel(label);
            }
        }

        @Override
        public void refresh() {
            this.myEditors.forEach(NlComponentEditor::refresh);
        }

        @NotNull
        private static List<String> combineLists(@NotNull List<String> list1, @NotNull List<String> list2) {
            if (list1 == null) {
                ViewInspectorComponent.$$$reportNull$$$0(11);
            }
            if (list2 == null) {
                ViewInspectorComponent.$$$reportNull$$$0(12);
            }
            ArrayList<String> combined = new ArrayList<String>(list1.size() + list2.size());
            combined.addAll(list1);
            combined.addAll(list2);
            ArrayList<String> arrayList = combined;
            if (arrayList == null) {
                ViewInspectorComponent.$$$reportNull$$$0(13);
            }
            return arrayList;
        }

        private void useSrcCompatIfExist(@NotNull Map<String, NlProperty> properties) {
            if (properties == null) {
                ViewInspectorComponent.$$$reportNull$$$0(14);
            }
            if (this.mySrcPropertyIndex < 0) {
                return;
            }
            this.myPropertyNames.set(this.mySrcPropertyIndex, properties.containsKey("srcCompat") ? "srcCompat" : "src");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: 
                case 13: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: 
                case 13: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tagName";
                    break;
                }
                case 1: 
                case 4: 
                case 7: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "properties";
                    break;
                }
                case 2: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "propertiesManager";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "propertyNames";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "components";
                    break;
                }
                case 9: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider$ViewInspectorComponent";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inspector";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list1";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider$ViewInspectorComponent";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditors";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "combineLists";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createEditors";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "updateProperties";
                    break;
                }
                case 9: 
                case 13: {
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "attachToInspector";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "combineLists";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "useSrcCompatIfExist";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: 
                case 13: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

