/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.idea.uibuilder.graphics.NlDrawingStyle;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.model.Coordinates;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.surface.Interaction;
import com.android.tools.idea.uibuilder.surface.Layer;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.google.common.collect.Lists;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;

public class MarqueeInteraction
extends Interaction {
    private MarqueeLayer myOverlay;
    private final ScreenView myScreenView;
    private final Collection<NlComponent> myInitialSelection;

    public MarqueeInteraction(@NotNull ScreenView surface, boolean toggle) {
        if (surface == null) {
            MarqueeInteraction.$$$reportNull$$$0(0);
        }
        this.myScreenView = surface;
        this.myInitialSelection = toggle ? this.myScreenView.getSelectionModel().getSelection() : Collections.emptySet();
    }

    @Override
    public void update(int x, int y, @JdkConstants.InputEventMask int modifiers) {
        if (this.myOverlay == null) {
            return;
        }
        int xp = Math.min(x, this.myStartX);
        int yp = Math.min(y, this.myStartY);
        int w = Math.abs(x - this.myStartX);
        int h = Math.abs(y - this.myStartY);
        this.myOverlay.updateSize(xp, yp, w, h);
        int ax = Coordinates.getAndroidX(this.myScreenView, xp);
        int ay = Coordinates.getAndroidY(this.myScreenView, yp);
        int aw = Coordinates.getAndroidDimension(this.myScreenView, w);
        int ah = Coordinates.getAndroidDimension(this.myScreenView, h);
        Collection<NlComponent> within = this.myScreenView.getModel().findWithin(ax, ay, aw, ah);
        ArrayList selection = Lists.newArrayList();
        if (!this.myInitialSelection.isEmpty()) {
            HashSet<NlComponent> result = new HashSet<NlComponent>(this.myInitialSelection);
            for (NlComponent component : selection) {
                if (this.myInitialSelection.contains(component)) {
                    result.remove(component);
                    continue;
                }
                result.add(component);
            }
            within = result;
        }
        this.myScreenView.getSelectionModel().setSelection(within);
        this.myScreenView.getSurface().repaint();
    }

    @Override
    public List<Layer> createOverlays() {
        this.myOverlay = new MarqueeLayer();
        return Collections.singletonList(this.myOverlay);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "surface", "com/android/tools/idea/uibuilder/surface/MarqueeInteraction", "<init>"));
    }

    private static class MarqueeLayer
    extends Layer {
        public int x;
        public int y;
        public int w;
        public int h;

        public void updateSize(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }

        @Override
        public void create() {
        }

        @Override
        public void dispose() {
        }

        @Override
        public void paint(@NotNull Graphics2D gc) {
            if (gc == null) {
                MarqueeLayer.$$$reportNull$$$0(0);
            }
            NlGraphics.drawFilledRect(NlDrawingStyle.SELECTION, gc, this.x, this.y, this.w, this.h);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gc", "com/android/tools/idea/uibuilder/surface/MarqueeInteraction$MarqueeLayer", "paint"));
        }
    }
}

