/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.converters.AndroidResourceReferenceBase;
import org.jetbrains.android.dom.layout.Include;
import org.jetbrains.android.dom.layout.LayoutViewElement;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.dom.resources.Style;
import org.jetbrains.android.dom.wrappers.LazyValueResourceElementWrapper;
import org.jetbrains.android.refactoring.AndroidAttributeInfo;
import org.jetbrains.android.refactoring.AndroidInlineAllStyleUsagesProcessor;
import org.jetbrains.android.refactoring.AndroidInlineLayoutDialog;
import org.jetbrains.android.refactoring.AndroidInlineLayoutProcessor;
import org.jetbrains.android.refactoring.AndroidInlineStyleDialog;
import org.jetbrains.android.refactoring.AndroidInlineTestConfig;
import org.jetbrains.android.refactoring.AndroidRefactoringUtil;
import org.jetbrains.android.refactoring.LayoutUsageData;
import org.jetbrains.android.refactoring.ParentStyleUsageData;
import org.jetbrains.android.refactoring.StyleRefData;
import org.jetbrains.android.refactoring.StyleUsageData;
import org.jetbrains.android.refactoring.ViewStyleUsageData;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.ErrorReporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AndroidInlineUtil {
    private AndroidInlineUtil() {
    }

    @Nullable
    static MyStyleData getInlinableStyleData(@NotNull XmlTag tag) {
        DomElement domElement;
        if (tag == null) {
            AndroidInlineUtil.$$$reportNull$$$0(0);
        }
        if (!((domElement = DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag)) instanceof Style)) {
            return null;
        }
        Style style = (Style)domElement;
        XmlAttributeValue nameAttrValue = style.getName().getXmlAttributeValue();
        if (nameAttrValue == null) {
            return null;
        }
        String styleName = style.getName().getStringValue();
        if (styleName == null || styleName.length() == 0) {
            return null;
        }
        return new MyStyleData(styleName, style, (PsiElement)nameAttrValue);
    }

    @Nullable
    static StyleUsageData getStyleUsageData(@NotNull XmlTag tag) {
        AndroidResourceReferenceBase reference;
        DomElement domElement;
        if (tag == null) {
            AndroidInlineUtil.$$$reportNull$$$0(1);
        }
        if ((domElement = DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag)) instanceof LayoutViewElement) {
            GenericAttributeValue<ResourceValue> styleAttribute = ((LayoutViewElement)domElement).getStyle();
            AndroidResourceReferenceBase reference2 = AndroidDomUtil.getAndroidResourceReference(styleAttribute, true);
            if (reference2 != null) {
                return new ViewStyleUsageData(tag, styleAttribute, reference2);
            }
        } else if (domElement instanceof Style && (reference = AndroidDomUtil.getAndroidResourceReference(((Style)domElement).getParentStyle(), true)) != null) {
            return new ParentStyleUsageData((Style)domElement, reference);
        }
        return null;
    }

    @Nullable
    static LayoutUsageData getLayoutUsageData(@NotNull XmlTag tag) {
        GenericAttributeValue<ResourceValue> layoutAttribute;
        AndroidResourceReferenceBase reference;
        Project project;
        DomElement domElement;
        if (tag == null) {
            AndroidInlineUtil.$$$reportNull$$$0(2);
        }
        if ((domElement = DomManager.getDomManager((Project)(project = tag.getProject())).getDomElement(tag)) instanceof Include && (reference = AndroidDomUtil.getAndroidResourceReference(layoutAttribute = ((Include)domElement).getLayout(), true)) != null) {
            return new LayoutUsageData(project, tag, reference);
        }
        return null;
    }

    static void doInlineStyleDeclaration(@NotNull Project project, @NotNull MyStyleData data, final @Nullable StyleUsageData usageData, @NotNull ErrorReporter errorReporter, @Nullable AndroidInlineTestConfig testConfig) {
        boolean inlineThisOnly;
        Style style;
        Map<AndroidAttributeInfo, String> attributeValues;
        if (project == null) {
            AndroidInlineUtil.$$$reportNull$$$0(3);
        }
        if (data == null) {
            AndroidInlineUtil.$$$reportNull$$$0(4);
        }
        if (errorReporter == null) {
            AndroidInlineUtil.$$$reportNull$$$0(5);
        }
        if ((attributeValues = AndroidRefactoringUtil.computeAttributeMap(style = data.myStyleElement, errorReporter, AndroidBundle.message("android.inline.style.title", new Object[0]))) == null) {
            return;
        }
        final StyleRefData parentStyleRef = AndroidRefactoringUtil.getParentStyle(style);
        if (testConfig != null) {
            inlineThisOnly = testConfig.isInlineThisOnly();
        } else {
            boolean invokedOnReference = usageData != null;
            AndroidInlineStyleDialog dialog = new AndroidInlineStyleDialog(project, data.myReferredElement, style.getXmlTag(), data.myStyleName, attributeValues, parentStyleRef, invokedOnReference, invokedOnReference);
            if (!dialog.showAndGet()) {
                return;
            }
            inlineThisOnly = dialog.isInlineThisOnly();
        }
        if (inlineThisOnly) {
            assert (usageData != null);
            PsiFile file = usageData.getFile();
            if (file == null) {
                return;
            }
            new WriteCommandAction(project, AndroidBundle.message("android.inline.style.command.name", data.myStyleName), new PsiFile[]{file}){

                protected void run(@NotNull Result result) throws Throwable {
                    if (result == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    usageData.inline(attributeValues, parentStyleRef);
                }

                protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
                    return UndoConfirmationPolicy.REQUEST_CONFIRMATION;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/android/refactoring/AndroidInlineUtil$1", "run"));
                }
            }.execute();
        } else if (testConfig != null) {
            AndroidInlineAllStyleUsagesProcessor processor = new AndroidInlineAllStyleUsagesProcessor(project, data.myReferredElement, style.getXmlTag(), data.myStyleName, attributeValues, parentStyleRef, testConfig);
            processor.setPreviewUsages(false);
            processor.run();
        }
    }

    @Nullable
    static MyStyleData getInlinableStyleDataFromContext(@Nullable PsiElement context) {
        XmlTag tag;
        if (context instanceof LazyValueResourceElementWrapper) {
            context = ((LazyValueResourceElementWrapper)context).computeElement();
        }
        if (context == null || !context.getManager().isInProject(context)) {
            return null;
        }
        XmlAttributeValue attrValue = (XmlAttributeValue)PsiTreeUtil.getParentOfType((PsiElement)context, XmlAttributeValue.class, (boolean)false);
        XmlTag xmlTag = tag = attrValue != null ? (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)attrValue, XmlTag.class) : null;
        if (tag == null) {
            return null;
        }
        MyStyleData data = AndroidInlineUtil.getInlinableStyleData(tag);
        return data != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)data.myReferredElement, (PsiElement)attrValue) ? data : null;
    }

    static void addReferences(@NotNull PsiElement element, @NotNull Collection<UsageInfo> result) {
        if (element == null) {
            AndroidInlineUtil.$$$reportNull$$$0(6);
        }
        if (result == null) {
            AndroidInlineUtil.$$$reportNull$$$0(7);
        }
        for (PsiReference reference : ReferencesSearch.search((PsiElement)element)) {
            result.add(new UsageInfo(reference.getElement()));
        }
    }

    @NotNull
    static MultiMap<PsiElement, String> buildConflicts(Collection<PsiElement> nonXmlUsages, Collection<PsiElement> unambiguousUsages, Collection<PsiElement> unsupportedUsages, Collection<PsiElement> implicitlyInherited) {
        MultiMap result = new MultiMap();
        for (PsiElement usage : nonXmlUsages) {
            result.putValue((Object)usage, (Object)("Non-XML reference '" + AndroidInlineUtil.toString(usage) + "' won't be updated"));
        }
        for (PsiElement usage : unambiguousUsages) {
            result.putValue((Object)usage, (Object)("Unambiguous reference '" + AndroidInlineUtil.toString(usage) + "' won't be updated"));
        }
        for (PsiElement usage : unsupportedUsages) {
            result.putValue((Object)usage, (Object)("Unsupported reference '" + AndroidInlineUtil.toString(usage) + "' won't be updated"));
        }
        for (PsiElement usage : implicitlyInherited) {
            result.putValue((Object)usage, (Object)("The style has implicit inheritor '" + AndroidInlineUtil.toString(usage) + "' which won't be updated"));
        }
        MultiMap multiMap = result;
        if (multiMap == null) {
            AndroidInlineUtil.$$$reportNull$$$0(8);
        }
        return multiMap;
    }

    private static String toString(PsiElement element) {
        return element instanceof XmlAttributeValue ? ((XmlAttributeValue)element).getValue() : element.getText();
    }

    static void doInlineLayoutFile(@NotNull Project project, @NotNull XmlFile layoutFile, @Nullable PsiElement usageElement, @Nullable AndroidInlineTestConfig testConfig) {
        if (project == null) {
            AndroidInlineUtil.$$$reportNull$$$0(9);
        }
        if (layoutFile == null) {
            AndroidInlineUtil.$$$reportNull$$$0(10);
        }
        XmlTag rootTag = layoutFile.getRootTag();
        assert (rootTag != null);
        if (testConfig == null) {
            AndroidInlineLayoutDialog dialog = new AndroidInlineLayoutDialog(project, layoutFile, rootTag, usageElement);
            dialog.show();
        } else {
            AndroidInlineLayoutProcessor processor = new AndroidInlineLayoutProcessor(project, layoutFile, rootTag, (PsiElement)(testConfig.isInlineThisOnly() ? usageElement : null), testConfig);
            processor.setPreviewUsages(false);
            processor.run();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorReporter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/refactoring/AndroidInlineUtil";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/refactoring/AndroidInlineUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "buildConflicts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInlinableStyleData";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getStyleUsageData";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLayoutUsageData";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doInlineStyleDeclaration";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addReferences";
                break;
            }
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doInlineLayoutFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class MyStyleData {
        private final String myStyleName;
        private final Style myStyleElement;
        private final PsiElement myReferredElement;

        MyStyleData(String styleName, Style styleElement, PsiElement referredElement) {
            this.myStyleName = styleName;
            this.myStyleElement = styleElement;
            this.myReferredElement = referredElement;
        }
    }
}

