/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.actions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ws.http.request.HttpRequestPsiFile;
import com.intellij.ws.http.request.run.HttpRequestHistoryManager;
import com.intellij.ws.rest.client.RestClientBundle;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import org.jetbrains.annotations.NotNull;

public class HttpRequestShowHistoryAction
extends AnAction {
    public HttpRequestShowHistoryAction() {
        super(RestClientBundle.message("http.request.show.log.file.action", new Object[0]));
        this.getTemplatePresentation().setDescription(RestClientBundle.message("http.request.show.log.file.action.description", new Object[0]));
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        HttpRequestPsiFile file = HttpRequestHistoryManager.getInstance(project).getLogFile();
        if (file != null) {
            FileEditorManager.getInstance((Project)project).openFile(file.getVirtualFile(), true);
        } else {
            this.showErrorBalloon(project, RestClientBundle.message("http.request.show.log.file.action.failed", new Object[0]), e);
        }
    }

    protected void showErrorBalloon(@NotNull Project project, @NotNull String message, @NotNull AnActionEvent event) {
        InputEvent inputEvent;
        if (project == null) {
            HttpRequestShowHistoryAction.$$$reportNull$$$0(0);
        }
        if (message == null) {
            HttpRequestShowHistoryAction.$$$reportNull$$$0(1);
        }
        if (event == null) {
            HttpRequestShowHistoryAction.$$$reportNull$$$0(2);
        }
        RelativePoint point = (inputEvent = event.getInputEvent()) instanceof MouseEvent ? new RelativePoint((MouseEvent)inputEvent) : JBPopupFactory.getInstance().guessBestPopupLocation(event.getDataContext());
        JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, MessageType.ERROR, null).setDisposable((Disposable)project).setFadeoutTime(1000L).createBalloon().show(point, Balloon.Position.below);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "message";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "event";
                break;
            }
        }
        objectArray[1] = "com/intellij/ws/actions/HttpRequestShowHistoryAction";
        objectArray[2] = "showErrorBalloon";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

